/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jboss.netty.buffer.ChannelBuffer;

public class Utils {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char BYTE_SEPARATOR = ' ';
    private static final String COPYRIGHT_NOTICE = "\nFlazr <http://flazr.com> Copyright (C) 2009  Peter Thomas.\nThis program comes with ABSOLUTELY NO WARRANTY.\nFlazr is free software, and you are welcome to redistribute it\nunder certain conditions.  You should have received a copy of the\nGNU Lesser General Public License along with Flazr.\nIf not, see <http://www.gnu.org/licenses/>\n";

    private Utils() {
    }

    public static String toHex(byte[] ba) {
        return Utils.toHex(ba, false);
    }

    public static String toHex(byte[] ba, boolean withSeparator) {
        return Utils.toHex(ba, 0, ba.length, withSeparator);
    }

    public static String toHex(byte[] ba, int offset, int length, boolean withSeparator) {
        char[] buf = withSeparator ? new char[length * 3] : new char[length * 2];
        int i = offset;
        int j = 0;
        while (i < offset + length) {
            char[] chars = Utils.toHexChars(ba[i++]);
            buf[j++] = chars[0];
            buf[j++] = chars[1];
            if (!withSeparator) continue;
            buf[j++] = 32;
        }
        return new String(buf);
    }

    private static char[] toHexChars(int b) {
        char left = HEX_DIGITS[b >>> 4 & 0xF];
        char right = HEX_DIGITS[b & 0xF];
        return new char[]{left, right};
    }

    public static String toHex(byte b) {
        char[] chars = Utils.toHexChars(b);
        return String.valueOf(chars);
    }

    public static byte[] fromHex(char[] hex) {
        int length = hex.length / 2;
        byte[] raw = new byte[length];
        for (int i = 0; i < length; ++i) {
            int low;
            int high = Character.digit(hex[i * 2], 16);
            int value = high << 4 | (low = Character.digit(hex[i * 2 + 1], 16));
            if (value > 127) {
                value -= 256;
            }
            raw[i] = (byte)value;
        }
        return raw;
    }

    public static byte[] fromHex(String s) {
        return Utils.fromHex(s.replace(" ", "").toCharArray());
    }

    public static byte[] toInt24(int value) {
        return new byte[]{(byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static int readInt32Reverse(ChannelBuffer in) {
        byte a = in.readByte();
        byte b = in.readByte();
        byte c = in.readByte();
        byte d = in.readByte();
        int val = 0;
        val += d << 24;
        val += c << 16;
        val += b << 8;
        return val += a;
    }

    public static void writeInt32Reverse(ChannelBuffer out, int value) {
        out.writeByte((byte)(0xFF & value));
        out.writeByte((byte)(0xFF & value >> 8));
        out.writeByte((byte)(0xFF & value >> 16));
        out.writeByte((byte)(0xFF & value >> 24));
    }

    public static CharSequence readAsString(String fileName) {
        return Utils.readAsString(new File(fileName));
    }

    public static CharSequence readAsString(File file) {
        StringBuilder sb = new StringBuilder();
        try {
            String s;
            FileInputStream fis = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            while ((s = reader.readLine()) != null) {
                sb.append(s);
            }
            return sb;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] readAsByteArray(String fileName) {
        File file = new File(fileName);
        return Utils.readAsByteArray(file, file.length());
    }

    public static byte[] readAsByteArray(String fileName, int length) {
        return Utils.readAsByteArray(new File(fileName), (long)length);
    }

    public static byte[] readAsByteArray(File file) {
        return Utils.readAsByteArray(file, file.length());
    }

    public static byte[] readAsByteArray(File file, long length) {
        try {
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            FileInputStream is = new FileInputStream(file);
            for (int offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            is.close();
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOverHttp(String url) {
        HttpClient client = new HttpClient();
        String response = null;
        GetMethod get = new GetMethod(url);
        try {
            client.executeMethod((HttpMethod)get);
            response = get.getResponseBodyAsString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            get.releaseConnection();
        }
        return response;
    }

    public static byte[] sha256(byte[] message, byte[] key) {
        Mac mac;
        try {
            mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return mac.doFinal(message);
    }

    public static void sendStopSignal(int port) {
        try {
            Socket s = new Socket(InetAddress.getByName("127.0.0.1"), port);
            OutputStream out = s.getOutputStream();
            System.err.println("sending server stop request");
            out.write("\r\n".getBytes());
            out.flush();
            s.close();
        }
        catch (Exception e) {
            System.err.println("stop monitor thread has terminated");
        }
    }

    public static void printlnCopyrightNotice() {
        System.err.println(COPYRIGHT_NOTICE);
    }

    public static String trimSlashes(String raw) {
        if (raw == null) {
            return null;
        }
        return raw.replace("/", "").replace("\\", "");
    }
}

