/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp.server;

import com.flazr.rtmp.RtmpHandshake;
import com.flazr.rtmp.RtmpPublisher;
import com.flazr.rtmp.server.ServerHandler;
import com.flazr.util.Utils;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerHandshakeHandler
extends FrameDecoder
implements ChannelDownstreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServerHandshakeHandler.class);
    private boolean rtmpe;
    private final RtmpHandshake handshake = new RtmpHandshake();
    private boolean partOneDone;
    private boolean handshakeDone;

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer in) {
        if (!this.partOneDone) {
            if (in.readableBytes() < 1537) {
                return null;
            }
            this.handshake.decodeClient0And1(in);
            this.rtmpe = this.handshake.isRtmpe();
            ChannelFuture future = Channels.succeededFuture((Channel)channel);
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)future, (Object)this.handshake.encodeServer0());
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)future, (Object)this.handshake.encodeServer1());
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)future, (Object)this.handshake.encodeServer2());
            this.partOneDone = true;
        }
        if (!this.handshakeDone) {
            if (in.readableBytes() < 1536) {
                return null;
            }
            this.handshake.decodeClient2(in);
            this.handshakeDone = true;
            logger.info("handshake done, rtmpe: {}", (Object)this.rtmpe);
            if (Arrays.equals(this.handshake.getPeerVersion(), Utils.fromHex("00000000"))) {
                ServerHandler serverHandler = (ServerHandler)ctx.getPipeline().get(ServerHandler.class);
                serverHandler.setAggregateModeEnabled(false);
                logger.info("old client version, disabled 'aggregate' mode");
            }
            if (!this.rtmpe) {
                channel.getPipeline().remove((ChannelHandler)this);
            }
        }
        return in;
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent ce) throws Exception {
        if (!(this.handshakeDone && this.rtmpe && ce instanceof MessageEvent)) {
            super.handleUpstream(ctx, ce);
            return;
        }
        MessageEvent me = (MessageEvent)ce;
        if (me.getMessage() instanceof RtmpPublisher.Event) {
            super.handleUpstream(ctx, ce);
            return;
        }
        ChannelBuffer in = (ChannelBuffer)((MessageEvent)ce).getMessage();
        this.handshake.cipherUpdateIn(in);
        Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)in);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent ce) {
        if (!(this.handshakeDone && this.rtmpe && ce instanceof MessageEvent)) {
            ctx.sendDownstream(ce);
            return;
        }
        ChannelBuffer in = (ChannelBuffer)((MessageEvent)ce).getMessage();
        this.handshake.cipherUpdateOut(in);
        ctx.sendDownstream(ce);
    }
}

