/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp.server;

import com.flazr.rtmp.RtmpConfig;
import com.flazr.rtmp.server.ServerApplication;
import com.flazr.rtmp.server.ServerPipelineFactory;
import com.flazr.util.StopMonitor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtmpServer {
    private static final Logger logger = LoggerFactory.getLogger(RtmpServer.class);
    protected static final ChannelGroup CHANNELS;
    protected static final Map<String, ServerApplication> APPLICATIONS;
    public static final Timer TIMER;

    public static void main(String[] args) throws Exception {
        NioServerSocketChannelFactory factory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)factory);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new ServerPipelineFactory());
        bootstrap.setOption("child.tcpNoDelay", (Object)true);
        bootstrap.setOption("child.keepAlive", (Object)true);
        InetSocketAddress socketAddress = new InetSocketAddress(RtmpConfig.SERVER_PORT);
        bootstrap.bind((SocketAddress)socketAddress);
        logger.info("server started, listening on: {}", (Object)socketAddress);
        StopMonitor monitor = new StopMonitor(RtmpConfig.SERVER_STOP_PORT);
        monitor.start();
        monitor.join();
        TIMER.stop();
        ChannelGroupFuture future = CHANNELS.close();
        logger.info("closing channels");
        future.awaitUninterruptibly();
        logger.info("releasing resources");
        factory.releaseExternalResources();
        logger.info("server stopped");
    }

    static {
        RtmpConfig.configureServer();
        CHANNELS = new DefaultChannelGroup("server-channels");
        APPLICATIONS = new ConcurrentHashMap<String, ServerApplication>();
        TIMER = new HashedWheelTimer((long)RtmpConfig.TIMER_TICK_SIZE, TimeUnit.MILLISECONDS);
    }
}

