/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp.proxy;

import com.flazr.rtmp.RtmpConfig;
import com.flazr.rtmp.proxy.ProxyPipelineFactory;
import com.flazr.util.StopMonitor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtmpProxy {
    private static final Logger logger = LoggerFactory.getLogger(RtmpProxy.class);
    protected static final ChannelGroup ALL_CHANNELS;

    public static void main(String[] args) throws Exception {
        ExecutorService executor = Executors.newCachedThreadPool();
        NioServerSocketChannelFactory factory = new NioServerSocketChannelFactory((Executor)executor, (Executor)executor);
        ServerBootstrap sb = new ServerBootstrap((ChannelFactory)factory);
        NioClientSocketChannelFactory cf = new NioClientSocketChannelFactory((Executor)executor, (Executor)executor);
        sb.setPipelineFactory((ChannelPipelineFactory)new ProxyPipelineFactory((ClientSocketChannelFactory)cf, RtmpConfig.PROXY_REMOTE_HOST, RtmpConfig.PROXY_REMOTE_PORT));
        InetSocketAddress socketAddress = new InetSocketAddress(RtmpConfig.PROXY_PORT);
        sb.bind((SocketAddress)socketAddress);
        logger.info("proxy server started, listening on {}", (Object)socketAddress);
        StopMonitor monitor = new StopMonitor(RtmpConfig.PROXY_STOP_PORT);
        monitor.start();
        monitor.join();
        ChannelGroupFuture future = ALL_CHANNELS.close();
        logger.info("closing channels");
        future.awaitUninterruptibly();
        logger.info("releasing resources");
        factory.releaseExternalResources();
        logger.info("server stopped");
    }

    static {
        RtmpConfig.configureProxy();
        ALL_CHANNELS = new DefaultChannelGroup("rtmp-proxy");
    }
}

