/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp.proxy;

import com.flazr.rtmp.RtmpDecoder;
import com.flazr.rtmp.proxy.ProxyEncoder;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelPipelineCoverage(value="one")
public class ProxyHandshakeHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(ProxyHandshakeHandler.class);
    private int bytesWritten;
    private boolean handshakeDone;

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer in = (ChannelBuffer)e.getMessage();
        this.bytesWritten += in.readableBytes();
        if (!this.handshakeDone && this.bytesWritten >= 3073) {
            int remaining = this.bytesWritten - 3073;
            if (remaining > 0) {
                Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)in.readBytes(remaining));
            }
            this.handshakeDone = true;
            logger.debug("bytes written {}, handshake complete, switching pipeline", (Object)this.bytesWritten);
            ctx.getPipeline().addFirst("encoder", (ChannelHandler)new ProxyEncoder());
            ctx.getPipeline().addFirst("decoder", (ChannelHandler)new RtmpDecoder());
            ctx.getPipeline().remove((ChannelHandler)this);
        }
        super.messageReceived(ctx, e);
    }
}

