/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp;

import com.flazr.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtmpConfig {
    private static final Logger logger = LoggerFactory.getLogger(RtmpConfig.class);
    public static String SERVER_HOME_DIR = "home";
    public static int TIMER_TICK_SIZE = 100;
    public static int SERVER_PORT = 1935;
    public static int SERVER_STOP_PORT = 1934;
    public static int PROXY_PORT = 8000;
    public static int PROXY_STOP_PORT = 7999;
    public static String PROXY_REMOTE_HOST = "127.0.0.1";
    public static int PROXY_REMOTE_PORT = 1935;

    public static void configureServer() {
        RtmpConfig.configure(Type.SERVER);
        RtmpConfig.addShutdownHook(SERVER_STOP_PORT);
    }

    public static int configureServerStop() {
        RtmpConfig.configure(Type.SERVER_STOP);
        return SERVER_STOP_PORT;
    }

    public static void configureProxy() {
        RtmpConfig.configure(Type.PROXY);
        RtmpConfig.addShutdownHook(PROXY_STOP_PORT);
    }

    public static int configureProxyStop() {
        RtmpConfig.configure(Type.PROXY_STOP);
        return PROXY_STOP_PORT;
    }

    private static void configure(Type type) {
        Utils.printlnCopyrightNotice();
        String flazrHome = null;
        InputStream is = RtmpConfig.class.getResourceAsStream("/flazr-init.properties");
        if (is != null) {
            logger.info("flazr-init.properties found on classpath");
            Properties flazrProps = RtmpConfig.loadProps(is);
            flazrHome = flazrProps.getProperty("flazr.home");
            if (flazrHome == null) {
                logger.warn("'flazr.home' key not found, will try system properties");
            }
        } else {
            logger.warn("flazr-init.properties not found on classpath, will try system property 'flazr.home'");
        }
        if (flazrHome == null) {
            flazrHome = System.getProperty("flazr.home");
        }
        if (flazrHome == null) {
            File currentDir = new File("");
            logger.warn("'flazr.home' system property not set, will use current directory: {}", (Object)currentDir.getAbsolutePath());
            flazrHome = "";
        } else if (!flazrHome.endsWith("/")) {
            flazrHome = flazrHome + "/";
            logger.info("using 'flazr.home' = {}", (Object)flazrHome);
        }
        File propsFile = new File(flazrHome + "conf/flazr.properties");
        if (!propsFile.exists()) {
            logger.warn("{} not found, will use configuration defaults", (Object)propsFile.getAbsolutePath());
        } else {
            logger.info("loading config from: {}", (Object)propsFile.getAbsolutePath());
            Properties props = RtmpConfig.loadProps(propsFile);
            switch (type) {
                case SERVER: 
                case SERVER_STOP: {
                    File homeFile;
                    Integer serverStop = RtmpConfig.parseInt(props.getProperty("server.stop.port"));
                    if (serverStop != null) {
                        SERVER_STOP_PORT = serverStop;
                    }
                    if (type == Type.SERVER_STOP) break;
                    Integer serverPort = RtmpConfig.parseInt(props.getProperty("server.port"));
                    if (serverPort != null) {
                        SERVER_PORT = serverPort;
                    }
                    if (!(homeFile = new File(SERVER_HOME_DIR = props.getProperty("server.home", "home"))).exists()) {
                        logger.error("home dir does not exist, aborting: {}", (Object)homeFile.getAbsolutePath());
                        throw new RuntimeException("home dir does not exist: " + homeFile.getAbsolutePath());
                    }
                    logger.info("home dir: '{}'", (Object)homeFile.getAbsolutePath());
                    logger.info("server port: {} (stop {})", (Object)SERVER_PORT, (Object)SERVER_STOP_PORT);
                    break;
                }
                case PROXY: 
                case PROXY_STOP: {
                    Integer proxyStop = RtmpConfig.parseInt(props.getProperty("proxy.stop.port"));
                    if (proxyStop != null) {
                        PROXY_STOP_PORT = proxyStop;
                    }
                    if (type == Type.PROXY_STOP) break;
                    Integer proxyPort = RtmpConfig.parseInt(props.getProperty("proxy.port"));
                    if (proxyPort != null) {
                        PROXY_PORT = proxyPort;
                    }
                    PROXY_REMOTE_HOST = props.getProperty("proxy.remote.host", "127.0.0.1");
                    Integer proxyRemote = RtmpConfig.parseInt(props.getProperty("proxy.remote.port"));
                    if (proxyRemote != null) {
                        PROXY_REMOTE_PORT = proxyRemote;
                    }
                    logger.info("proxy port: {} (stop {})", (Object)PROXY_PORT, (Object)PROXY_STOP_PORT);
                    logger.info("proxy remote host: {} port: {}", (Object)PROXY_REMOTE_HOST, (Object)PROXY_REMOTE_PORT);
                }
            }
        }
    }

    private static void addShutdownHook(int port) {
        Runtime.getRuntime().addShutdownHook(new ServerShutdownHook(port));
    }

    private static Properties loadProps(File file) {
        try {
            FileInputStream is = new FileInputStream(file);
            Properties props = RtmpConfig.loadProps(is);
            ((InputStream)is).close();
            return props;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Properties loadProps(InputStream is) {
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return props;
    }

    private static Integer parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            logger.warn("unable to parse into integer value: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static class ServerShutdownHook
    extends Thread {
        private final int port;

        public ServerShutdownHook(int port) {
            this.port = port;
        }

        public void run() {
            Utils.sendStopSignal(this.port);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SERVER,
        SERVER_STOP,
        PROXY,
        PROXY_STOP;

    }
}

