/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v.box;

import com.flazr.io.f4v.Payload;
import com.flazr.util.Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TKHD
implements Payload {
    private static final Logger logger = LoggerFactory.getLogger(TKHD.class);
    private byte version;
    private byte[] flags;
    private long creationTime;
    private long modificationTime;
    private int trackId;
    private int reserved1;
    private long duration;
    private int[] reserved2;
    private short layer;
    private short alternateGroup;
    private short volume;
    private short reserved3;
    private int[] transformMatrix;
    private int width;
    private int height;

    public TKHD(ChannelBuffer in) {
        this.read(in);
    }

    public int getTrackId() {
        return this.trackId;
    }

    public void read(ChannelBuffer in) {
        this.version = in.readByte();
        logger.debug("version: {}", (Object)Utils.toHex(this.version));
        this.flags = new byte[3];
        in.readBytes(this.flags);
        if (this.version == 0) {
            this.creationTime = in.readInt();
            this.modificationTime = in.readInt();
        } else {
            this.creationTime = in.readLong();
            this.modificationTime = in.readLong();
        }
        this.trackId = in.readInt();
        this.reserved1 = in.readInt();
        this.duration = this.version == 0 ? (long)in.readInt() : in.readLong();
        this.reserved2 = new int[2];
        this.reserved2[0] = in.readInt();
        this.reserved2[1] = in.readInt();
        this.layer = in.readShort();
        this.alternateGroup = in.readShort();
        this.volume = in.readShort();
        this.reserved3 = in.readShort();
        logger.debug("creationTime {} modificationTime {} trackId {} duration {} layer {} volume {}", new Object[]{this.creationTime, this.modificationTime, this.trackId, this.duration, this.layer, this.volume});
        this.transformMatrix = new int[9];
        for (int i = 0; i < this.transformMatrix.length; ++i) {
            this.transformMatrix[i] = in.readInt();
            logger.debug("transform matrix[{}]: {}", new Object[]{i, this.transformMatrix[i]});
        }
        this.width = in.readInt();
        this.height = in.readInt();
        logger.debug("width {} height {}", new Object[]{this.width, this.height});
    }

    public ChannelBuffer write() {
        ChannelBuffer out = ChannelBuffers.dynamicBuffer();
        out.writeByte(this.version);
        out.writeBytes(new byte[3]);
        if (this.version == 0) {
            out.writeInt((int)this.creationTime);
            out.writeInt((int)this.modificationTime);
        } else {
            out.writeLong(this.creationTime);
            out.writeLong(this.modificationTime);
        }
        out.writeInt(this.trackId);
        out.writeInt(this.reserved1);
        if (this.version == 0) {
            out.writeInt((int)this.duration);
        } else {
            out.writeLong(this.duration);
        }
        out.writeInt(this.reserved2[0]);
        out.writeInt(this.reserved2[1]);
        out.writeShort(this.layer);
        out.writeShort(this.alternateGroup);
        out.writeShort(this.volume);
        out.writeShort(this.reserved3);
        for (int i = 0; i < this.transformMatrix.length; ++i) {
            out.writeInt(this.transformMatrix[i]);
        }
        out.writeInt(this.width);
        out.writeInt(this.height);
        return out;
    }
}

