/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v.box;

import com.flazr.util.Utils;
import org.jboss.netty.buffer.ChannelBuffer;

public class MP4Descriptor {
    public static final int ES_TAG = 3;
    public static final int DECODER_CONFIG = 4;
    public static final int DECODER_SPECIFIC_CONFIG = 5;
    private byte[] decoderSpecificConfig = Utils.fromHex("af0013100000");

    public MP4Descriptor(ChannelBuffer in) {
        int size = in.readInt();
        in.readInt();
        in.readInt();
        while (in.readable()) {
            this.readDescriptor(in, size - 12);
        }
    }

    public byte[] getConfigBytes() {
        return this.decoderSpecificConfig;
    }

    private int readDescriptor(ChannelBuffer bitstream, int length) {
        byte tag = bitstream.readByte();
        int size = 0;
        byte b = 0;
        int read = 1;
        do {
            b = bitstream.readByte();
            size <<= 7;
            size |= b & 0x7F;
            ++read;
        } while ((b & 0x80) == 128);
        switch (tag) {
            case 3: {
                return this.parseES(bitstream, length - read) + read;
            }
            case 4: {
                return this.parseDecoderConfig(bitstream, length - read) + read;
            }
            case 5: {
                return this.parseDecoderSpecificConfig(bitstream, size, length - read) + read;
            }
        }
        bitstream.skipBytes(size);
        return size + read;
    }

    private int parseES(ChannelBuffer bitstream, int length) {
        boolean ocrFlag;
        int read = 3;
        short ES_ID = bitstream.readShort();
        byte flags = bitstream.readByte();
        boolean streamDependenceFlag = (flags & 0x80) != 0;
        boolean urlFlag = (flags & 0x40) != 0;
        boolean bl = ocrFlag = (flags & 0x20) != 0;
        if (streamDependenceFlag) {
            bitstream.skipBytes(2);
            read += 2;
        }
        if (urlFlag) {
            byte str_size = bitstream.readByte();
            bitstream.skipBytes((int)str_size);
            read += str_size;
        }
        if (ocrFlag) {
            bitstream.skipBytes(2);
            read += 2;
        }
        while (bitstream.readableBytes() > length - read) {
            read += this.readDescriptor(bitstream, length - read);
        }
        return read;
    }

    private int parseDecoderConfig(ChannelBuffer bitstream, int length) {
        byte objectTypeIndication = bitstream.readByte();
        short value = bitstream.readByte();
        boolean upstream = (value & 2) > 0;
        byte streamType = (byte)(value >> 2);
        value = bitstream.readShort();
        int bufferSizeDB = value << 8;
        value = bitstream.readByte();
        bufferSizeDB |= value & 0xFF;
        int maxBitRate = bitstream.readInt();
        int minBitRate = bitstream.readInt();
        int read = 13;
        while (bitstream.readableBytes() > length - 13) {
            read += this.readDescriptor(bitstream, length - 13);
        }
        return read;
    }

    private int parseDecoderSpecificConfig(ChannelBuffer bitstream, int size, int length) {
        this.decoderSpecificConfig = new byte[size];
        bitstream.readBytes(this.decoderSpecificConfig);
        return size;
    }
}

