/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v;

import com.flazr.io.f4v.Sample;
import com.flazr.io.f4v.SampleType;
import com.flazr.io.f4v.TrackInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chunk
implements Comparable {
    private int sampleDescIndex;
    private long fileOffset;
    private List<Sample> samples = new ArrayList<Sample>();
    private TrackInfo track;
    private SampleType sampleType;
    private BigDecimal timeScale;

    public void setTrack(TrackInfo track) {
        this.track = track;
        this.sampleType = track.getStsd().getSampleType(this.sampleDescIndex);
        this.timeScale = new BigDecimal(track.getMdhd().getTimeScale());
    }

    public BigDecimal getTimeScale() {
        return this.timeScale;
    }

    public SampleType getSampleType() {
        return this.sampleType;
    }

    public TrackInfo getTrack() {
        return this.track;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public void setFileOffset(long fileOffset) {
        this.fileOffset = fileOffset;
    }

    public int getSampleDescIndex() {
        return this.sampleDescIndex;
    }

    public void setSampleDescIndex(int sampleDescIndex) {
        this.sampleDescIndex = sampleDescIndex;
    }

    public void add(Sample sample) {
        sample.setChunk(this);
        this.samples.add(sample);
    }

    public int getSampleCount() {
        return this.samples.size();
    }

    public void setSamples(List<Sample> samples) {
        this.samples = samples;
    }

    public List<Sample> getSamples() {
        return this.samples;
    }

    public int compareTo(Object o) {
        return (int)(this.fileOffset - ((Chunk)o).fileOffset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Chunk)) {
            return false;
        }
        Chunk c = (Chunk)o;
        return this.fileOffset == c.fileOffset;
    }

    public int hashCode() {
        return (int)this.fileOffset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[type: ").append((Object)this.sampleType);
        sb.append(" offset: ").append(this.fileOffset);
        sb.append(" samples: ").append(this.samples.size());
        for (Sample sample : this.samples) {
            sb.append(sample.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

