/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.io.f4v;

import com.flazr.io.BufferReader;
import com.flazr.io.f4v.BoxType;
import com.flazr.io.f4v.Payload;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Box {
    private static final Logger logger = LoggerFactory.getLogger(Box.class);
    private final BoxType type;
    private final long fileOffset;
    private List<Box> children;
    private Payload payload;

    public Box(BufferReader in, long endPos) {
        long payloadSize;
        long boxSize = in.readUnsignedInt();
        byte[] typeBytes = in.readBytes(4);
        this.type = BoxType.parse(new String(typeBytes));
        if (boxSize == 1L) {
            byte[] extBytes = in.readBytes(8);
            BigInteger bigLen = new BigInteger(1, extBytes);
            payloadSize = bigLen.longValue() - 16L;
        } else {
            payloadSize = boxSize == 0L ? endPos - in.position() : boxSize - 8L;
        }
        this.fileOffset = in.position();
        long childEndPos = this.fileOffset + payloadSize;
        logger.debug(">> type: {}, payloadSize: {}", (Object)this.type, (Object)payloadSize);
        BoxType[] childBoxes = this.type.getChildren();
        if (childBoxes == null) {
            if (this.type == BoxType.MDAT) {
                logger.debug("skipping MDAT");
                in.position(childEndPos);
                return;
            }
            this.payload = this.type.read(in.read((int)payloadSize));
            logger.debug("<< {} payload: {}", (Object)this.type, (Object)this.payload);
            return;
        }
        while (in.position() < childEndPos) {
            if (this.children == null) {
                this.children = new ArrayList<Box>();
            }
            this.children.add(new Box(in, childEndPos));
        }
        logger.debug("<< {} children: {}", (Object)this.type, this.children);
    }

    public BoxType getType() {
        return this.type;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public List<Box> getChildren() {
        return this.children;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public static void recurse(Box box, List<Box> collect, int level) {
        if (logger.isDebugEnabled()) {
            char[] chars = new char[level * 2];
            Arrays.fill(chars, ' ');
            logger.debug("{} recursing {}, payload: {}", new Object[]{String.valueOf(chars), box.type, box.payload});
        }
        if (collect != null && box.getPayload() != null) {
            collect.add(box);
        }
        if (box.getChildren() != null) {
            for (Box child : box.getChildren()) {
                Box.recurse(child, collect, level + 1);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append((Object)this.type);
        sb.append(" fileOffset: ").append(this.fileOffset);
        if (this.children != null) {
            sb.append(" children: [");
            for (Box box : this.children) {
                sb.append((Object)box.getType()).append(' ');
            }
            sb.append(']');
        }
        sb.append(" payload: ").append(this.payload);
        sb.append(']');
        return sb.toString();
    }
}

