/*
 * Decompiled with CFR 0.152.
 */
package net.openai.util.fsm;

import java.io.Serializable;
import java.util.Vector;
import net.openai.util.fsm.State;

public abstract class Condition
implements Serializable {
    private State targetState;
    private Vector sourceStates = new Vector();

    public Condition() {
    }

    public Condition(State targetState) {
        this.setTargetState(targetState);
    }

    public final void setTargetState(State targetState) {
        this.targetState = targetState;
    }

    public final State getTargetState() {
        return this.targetState;
    }

    public final Vector getSourceStates() {
        Vector returnValue = null;
        Vector vector = this.sourceStates;
        synchronized (vector) {
            returnValue = (Vector)this.sourceStates.clone();
        }
        return returnValue;
    }

    void addSourceState(State state) {
        if (state == null) {
            throw new NullPointerException("Cannot add null source state.");
        }
        Vector vector = this.sourceStates;
        synchronized (vector) {
            if (!this.sourceStates.contains(state)) {
                this.sourceStates.addElement(state);
            }
        }
    }

    void removeSourceState(State state) {
        if (state == null) {
            return;
        }
        Vector vector = this.sourceStates;
        synchronized (vector) {
            this.sourceStates.removeElement(state);
        }
    }

    public abstract boolean satisfiedBy(Object var1);
}

