/*
 * Decompiled with CFR 0.152.
 */
package net.openai.util.fsm;

import net.openai.util.fsm.Condition;
import net.openai.util.fsm.State;

public final class ComparableCondition
extends Condition {
    public static final int EQUAL_TO = 0;
    public static final int NOT_EQUAL_TO = 1;
    public static final int GREATER_THAN = 2;
    public static final int LESS_THAN = 3;
    public static final int GREATER_THAN_OR_EQUAL_TO = 4;
    public static final int LESS_THAN_OR_EQUAL_TO = 5;
    public static final int EQ = 0;
    public static final int NE = 1;
    public static final int GT = 2;
    public static final int LT = 3;
    public static final int GTE = 4;
    public static final int LTE = 5;
    private int type = 0;
    private Comparable comparable = null;

    public ComparableCondition(Comparable comparable) {
        this.createSelf(comparable, this.type);
    }

    public ComparableCondition(Comparable comparable, int type) {
        this.createSelf(comparable, type);
    }

    public ComparableCondition(byte comparable) {
        this.createSelf(new Byte(comparable), this.type);
    }

    public ComparableCondition(byte comparable, int type) {
        this.createSelf(new Byte(comparable), type);
    }

    public ComparableCondition(char comparable) {
        this.createSelf(new Character(comparable), this.type);
    }

    public ComparableCondition(char comparable, int type) {
        this.createSelf(new Character(comparable), type);
    }

    public ComparableCondition(double comparable) {
        this.createSelf(new Double(comparable), this.type);
    }

    public ComparableCondition(double comparable, int type) {
        this.createSelf(new Double(comparable), type);
    }

    public ComparableCondition(float comparable) {
        this.createSelf(new Float(comparable), this.type);
    }

    public ComparableCondition(float comparable, int type) {
        this.createSelf(new Float(comparable), type);
    }

    public ComparableCondition(int comparable) {
        this.createSelf(new Integer(comparable), this.type);
    }

    public ComparableCondition(int comparable, int type) {
        this.createSelf(new Integer(comparable), type);
    }

    public ComparableCondition(long comparable) {
        this.createSelf(new Long(comparable), this.type);
    }

    public ComparableCondition(long comparable, int type) {
        this.createSelf(new Long(comparable), type);
    }

    public ComparableCondition(short comparable) {
        this.createSelf(new Short(comparable), this.type);
    }

    public ComparableCondition(short comparable, int type) {
        this.createSelf(new Short(comparable), type);
    }

    public ComparableCondition(State state, Comparable comparable) {
        super(state);
        this.createSelf(comparable, this.type);
    }

    public ComparableCondition(State state, Comparable comparable, int type) {
        super(state);
        this.createSelf(comparable, type);
    }

    public ComparableCondition(State state, byte comparable) {
        super(state);
        this.createSelf(new Byte(comparable), this.type);
    }

    public ComparableCondition(State state, byte comparable, int type) {
        super(state);
        this.createSelf(new Byte(comparable), type);
    }

    public ComparableCondition(State state, char comparable) {
        super(state);
        this.createSelf(new Character(comparable), this.type);
    }

    public ComparableCondition(State state, char comparable, int type) {
        super(state);
        this.createSelf(new Character(comparable), type);
    }

    public ComparableCondition(State state, double comparable) {
        super(state);
        this.createSelf(new Double(comparable), this.type);
    }

    public ComparableCondition(State state, double comparable, int type) {
        super(state);
        this.createSelf(new Double(comparable), type);
    }

    public ComparableCondition(State state, float comparable) {
        super(state);
        this.createSelf(new Float(comparable), this.type);
    }

    public ComparableCondition(State state, float comparable, int type) {
        super(state);
        this.createSelf(new Float(comparable), type);
    }

    public ComparableCondition(State state, int comparable) {
        super(state);
        this.createSelf(new Integer(comparable), this.type);
    }

    public ComparableCondition(State state, int comparable, int type) {
        super(state);
        this.createSelf(new Integer(comparable), type);
    }

    public ComparableCondition(State state, long comparable) {
        super(state);
        this.createSelf(new Long(comparable), this.type);
    }

    public ComparableCondition(State state, long comparable, int type) {
        super(state);
        this.createSelf(new Long(comparable), type);
    }

    public ComparableCondition(State state, short comparable) {
        super(state);
        this.createSelf(new Short(comparable), this.type);
    }

    public ComparableCondition(State state, short comparable, int type) {
        super(state);
        this.createSelf(new Short(comparable), type);
    }

    private final void createSelf(Comparable comparable, int type) {
        if (comparable == null) {
            throw new NullPointerException("null Comparable");
        }
        this.comparable = comparable;
        this.type = type;
    }

    public final void setType(int type) {
        if (type < 0 || type > 5) {
            throw new IndexOutOfBoundsException("Type is invalid: " + type);
        }
        this.type = type;
    }

    public final int getType() {
        return this.type;
    }

    public final boolean satisfiedBy(Object conditional) {
        if (conditional instanceof Comparable) {
            Comparable cond = (Comparable)conditional;
            int checkType = this.type;
            switch (checkType) {
                case 0: {
                    return cond.compareTo(this.comparable) == 0;
                }
                case 1: {
                    return cond.compareTo(this.comparable) != 0;
                }
                case 2: {
                    return cond.compareTo(this.comparable) > 0;
                }
                case 3: {
                    return cond.compareTo(this.comparable) < 0;
                }
                case 4: {
                    return cond.compareTo(this.comparable) >= 0;
                }
                case 5: {
                    return cond.compareTo(this.comparable) <= 0;
                }
            }
            System.err.println("ComparableCondition.satisfiedBy: WARNING: invalid type: " + checkType);
        }
        return false;
    }
}

