/*****************************************************************************
* FSMTest.java
*****************************************************************************
* @author  Thorn Halo
* @date    Wed Apr  4 20:54:44 CDT 2001
* 2001 OpenAI Labs
*****************************************************************************/

import net.openai.util.fsm.*;
import net.openai.util.fsm.event.*;


/**
* This is a simple test of the Finite State Machine package.  Basically, it
* is a pattern matching application (though this is overkill).
*/
public class FSMTest {

    /** The target string that we're trying to match. */
    public static final String targetString = "OpenAI";


    /**
     * The main entry point of this application.
     */
    public static void main(String args[]) {
        if(args.length < 1) {
            System.err.println("Usage: java FSMTest <a string>");
            System.exit(-1);
        }

        // Get the string passed in on the command line
        char[] testString = args[0].toCharArray();

        // Get the character arraw for the target string
        char[] targetCharArray = targetString.toCharArray();

        // Construct the FSM
        State startState = new TestState("Start State");
        State validEndState = new TestState("Valid String State");
        State invalidEndState = new TestState("Invalid String State");
        Machine machine = new Machine(startState);
        State tempState = startState;
        for(int i = 0; i < targetCharArray.length; i++) {
            boolean endOfTheString = (i == (targetCharArray.length - 1));
            State nextState;
            if(endOfTheString)
                nextState = validEndState;
            else
                nextState = new TestState("Matching State (" +
					  targetCharArray[i] + ")");
            Character matchChar = new Character(targetCharArray[i]);

            // go on the the next state if we match the current character
            tempState.addTransition(new ComparableCondition(matchChar),
                                    nextState);

            // everything else goes to the invalid state
            tempState.addTransition(new AnyCondition(), invalidEndState);

            tempState = nextState;
        }
        invalidEndState.addTransition(new AnyCondition(), invalidEndState);
        validEndState.addTransition(new AnyCondition(), invalidEndState);

        // Now, run it through the machine
        try {
            for(int i = 0; i < testString.length; i++)
                machine.input(testString[i]);
            State currentState = machine.getCurrentState();
            if(currentState == validEndState) {
                System.out.println("Looks like a match to me!");
            } else if(currentState == invalidEndState) {
                System.out.println("Sorry, the wrong string was entered.  " +
                                   "Try entering " + targetString);
            } else {
                System.out.println("Looks like you got part of the target " +
                                   "string correct.  Try again.");
            }
        } catch(UnhandledConditionException uce) {
            System.err.println("Caught UnhandledConditionException ... time " +
                               "to debug!");
        }
    }

    /**
     * A simple State that just prints out its ID when it is entered and
     * exited.
     */
    public static class TestState extends State {

        /**
         * Constructs a new TestState with the given name.
         */
        public TestState(String name) {
            setName(name);
        }

        /**
         * This is called whenever an instance of this State is entered.
         */
        public void enter(Object input) {
            System.out.println(getName() + " entered.");
        }

        /**
         * This is called whenever an instance of this State is exited.
         */
        public Object exit() {
            System.out.println(getName() + " exited.");
            return null;
        }
    }
}
