/*****************************************************************************
 * net.openai.fsm.NotCondition
 *****************************************************************************
 * @author  thornhalo
 * @date    Fri Oct 11 23:20:42 EDT 2002
 * 2002 OpenAI Labs
 *****************************************************************************/
package net.openai.util.fsm;

/**
 * This condition works as a negation operator to another condition.
 */
public final class NotCondition extends AbstractCondition {

    /** The Condition to negate. */
    private Condition condition = null;

    /**
     * Constructs a new NotCondition for the given condition.
     *
     * @param condition The condition to negate.
     */
    public NotCondition(Condition condition) {
	this(null, condition);
    }

    /**
     * Constructs a new NotCondition for the given target state and condition.
     *
     * @param targetState The target state for the condition.
     */
    public NotCondition(State targetState, Condition condition) {
	super(targetState);
	this.condition = condition;
    }

    /**
     * Called to check if the conditional meets the criteria defined by this
     * condition.
     *
     * @param conditional The object to check.
     * @return True if the condition passes, false otherwise.
     */
    public final boolean satisfiedBy(Object conditional) {
	return !condition.satisfiedBy(conditional);
    }
}
