/*****************************************************************************
 * net.openai.fsm.EqualsCondition
 *****************************************************************************
 * @author  JC on E
 * @date    11/2/2000
 * 2001 OpenAI Labs
 *****************************************************************************/

package net.openai.util.fsm;


/**
 * EqualsCondition class
 */
public final class EqualsCondition extends AbstractCondition {

    /** The object that we are going to check against. */
    private Object target = null;

    /**
     * Constructs a new EqualsCondition.
     */
    public EqualsCondition() {
	this(null, null);
    }

    /**
     * Constructs a new EqualsCondtion with the given target state.
     *
     * @param targetState The target state of this condition.
     */
    public EqualsCondition(State targetState) {
	this(targetState, null);
    }

    /**
     * Constructs a new EqualsCondition with the target <code>target</code>.
     * The <code>satisfiedBy</code> method will return true if the passed
     * in object is equal to (== operator) the target object.
     *
     * @param target The target of this equals condition.
     */
    public EqualsCondition(Object target) {
	this(null, target);
    }

    /**
     * Constructs a new EqualsCondition with the target <code>target</code>
     * and the given target state.   The <code>satisfiedBy</code> method will
     * return true if the passed in object is equal to (== operator) the
     * target object.
     *
     * @param targetState The target state of this condition.
     * @param target      The target of this equals condition.
     */
    public EqualsCondition(State targetState, Object target) {
	super(targetState);
	setTarget(target);
    }

    /**
     * Sets the target of this equals condition.
     *
     * @param targe The target of this equals condition.
     */
    public final void setTarget(Object target) {
	this.target = target;
    }

    /**
     * Returns the target of this equals condition.
     *
     * @return The target of this equals condition.
     */
    public final Object getTarget() {
	return this.target;
    }

    /**
     * Implemented method for the Condition interface
     *
     * Called to check if the condition meets the criteria defined by this
     * state.  In this case, the condition is met if:<b>
     * <code>conditional == target</code><br>
     *
     * @param condition The object to check.
     * @return True if conditional == target, false otherwise.
     */
    public final boolean satisfiedBy(Object conditional) {
	return (target == conditional);
    }
}
