/*****************************************************************************
 * net.openai.fsm.AbstractCondition
 *****************************************************************************
 * @author  thornhalo
 * @date    Sat Oct 12 12:15:29 EDT 2002
 * 2002 OpenAI Labs
 *****************************************************************************/

package net.openai.util.fsm;

import java.util.Vector;


/**
 * A simple base class for conditions.
 */
public abstract class AbstractCondition implements Condition {

    /** A handle to our target State. */
    private State targetState = null;

    /**
     * Constructs a new AbstractCondition object.
     */
    public AbstractCondition() {
	this(null);
    }

    /**
     * Constructs a new AbstractCondition with the given target state.
     *
     * @param targetState The target state for this AbstractCondition.
     */
    public AbstractCondition(State targetState) {
	setTargetState(targetState);
    }

    /**
     * Returns a handle to this AbstractCondition's current target state.
     *
     * @return This AbstractCondition's target state.
     */
    public final State getTargetState() {
	return targetState;
    }

    /**
     * Sets the target state for this Condition.  This is the state that
     * will be the current state in the machine if this Condition is met.
     * <br><br>
     * NOTE: If the target state is null whenever this condition is being
     *       checked by the machine and it passes, then the result will
     *       be an UnhandledConditionException being thrown by the machine.
     *       Setting this to null is allowed because it will be necessary
     *       within a Graphical Building tool such as bean box or the 
     *       planned extensions to the net.openai.gui.graph package.
     *
     * @param targetState The new target state.
     */
    public final void setTargetState(State targetState) {
	this.targetState = targetState;
    }
}
