/*
 * Decompiled with CFR 0.152.
 */
package org.mikha.utils.web.examples;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.mikha.utils.Pair;
import org.mikha.utils.web.BaseControllerServlet;
import org.mikha.utils.web.ControllerMethodMapping;
import org.mikha.utils.web.HttpMethod;
import org.mikha.utils.web.HttpParamsRequest;

public class FormsServlet
extends BaseControllerServlet {
    private static final Pair<Integer, String>[] SALUTATIONS = new Pair[]{new Pair((Object)0, (Object)"Mr."), new Pair((Object)1, (Object)"Ms."), new Pair((Object)2, (Object)"Mrs."), new Pair((Object)3, (Object)"Dr.")};
    private static final Pair<Integer, String>[] SPAM_TOPICS = new Pair[]{new Pair((Object)0, (Object)"Cars"), new Pair((Object)1, (Object)"PC - Hardware"), new Pair((Object)2, (Object)"PC - Software"), new Pair((Object)3, (Object)"PC - Games"), new Pair((Object)4, (Object)"Consoles - Hardware"), new Pair((Object)5, (Object)"Consoles - Games"), new Pair((Object)6, (Object)"Travel")};

    @ControllerMethodMapping(paths={"/scalar"})
    public String parseScalarForm(HttpParamsRequest req) {
        String submit = req.getParameter("submit");
        if (submit != null) {
            Integer int1 = req.getInteger("int1");
            Integer int2 = req.getInteger("int2", Integer.valueOf(100));
            req.setAttribute("int1", (Object)String.valueOf(int1));
            req.setAttribute("int2", (Object)String.valueOf(int2));
        }
        if (submit != null) {
            String str1 = req.getString("str1");
            String str2 = req.getString("str2", "la-la-la");
            String str3 = req.getEmail("str3");
            req.setAttribute("str1", (Object)String.valueOf(str1));
            req.setAttribute("str2", (Object)String.valueOf(str2));
            req.setAttribute("str3", (Object)String.valueOf(str3));
        }
        if (submit != null) {
            boolean bool1 = req.getBoolean("bool1");
            boolean bool2 = req.getBoolean("bool2");
            req.setAttribute("bool1", (Object)String.valueOf(bool1));
            req.setAttribute("bool2", (Object)String.valueOf(bool2));
        }
        return "scalarform.jsp";
    }

    @ControllerMethodMapping(paths={"/array"})
    public String parseArrayForm(HttpParamsRequest req) {
        int i;
        Object[] in;
        String submit = req.getParameter("submit");
        String[] out = new String[4];
        if (submit != null) {
            in = req.getIntegerArray("ints", 4);
            for (i = 0; i < Math.min(out.length, in.length); ++i) {
                out[i] = String.valueOf(in[i]);
            }
        }
        req.setAttribute("ints", (Object)out);
        out = new String[4];
        if (submit != null) {
            in = req.getBooleanArray("bools", 4);
            for (i = 0; i < Math.min(out.length, in.length); ++i) {
                out[i] = String.valueOf(in[i]);
            }
        }
        req.setAttribute("bools", (Object)out);
        out = new String[4];
        if (submit != null) {
            in = req.getStringArray("strs", 4);
            for (i = 0; i < Math.min(out.length, in.length); ++i) {
                out[i] = String.valueOf(in[i]);
            }
        }
        req.setAttribute("strs", (Object)out);
        return "arrayform.jsp";
    }

    @ControllerMethodMapping(methods={HttpMethod.GET}, paths={"/demo"})
    public String showDemoForm(HttpParamsRequest req) {
        this.putStandardDefinitions(req);
        return "demoform.jsp";
    }

    @ControllerMethodMapping(methods={HttpMethod.POST}, paths={"/demo"})
    public String processDemoForm(HttpParamsRequest req) {
        this.putStandardDefinitions(req);
        String first = req.getString("first");
        String family = req.getString("family");
        Pair salut = (Pair)req.getOption("salut", (Object[])SALUTATIONS);
        String email = req.getEmail("email");
        Integer age = req.getInteger("age");
        if (age != null && (age < 18 || age > 120)) {
            req.logParameterError("age");
        }
        List spam = req.getOptions("spam", (Object[])SPAM_TOPICS);
        String comments = req.getString("comments", "");
        if (comments.length() > 100) {
            req.logParameterError("comments");
        }
        FileItem picture = req.getFile("picture");
        if (!req.hasRecentErrors()) {
            req.setAttribute("first", (Object)first);
            req.setAttribute("family", (Object)family);
            req.setAttribute("salut", (Object)salut);
            req.setAttribute("email", (Object)email);
            req.setAttribute("age", (Object)age);
            req.setAttribute("spam", (Object)spam);
            req.setAttribute("comments", (Object)comments);
            req.setAttribute("picture", (Object)picture);
            return "demoresult.jsp";
        }
        return "demoform.jsp";
    }

    @ControllerMethodMapping(paths={"/file"})
    public String parseFileForm(HttpParamsRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        String submit = req.getParameter("submit");
        if (submit != null) {
            FileItem file = req.getFile("file");
            if (!req.hasRecentErrors()) {
                rsp.setContentType(file.getContentType());
                rsp.setContentLength((int)file.getSize());
                rsp.getOutputStream().write(file.get());
                return null;
            }
        }
        return "fileform.jsp";
    }

    private void putStandardDefinitions(HttpParamsRequest req) {
        req.setAttribute("SALUTATIONS", (Object)SALUTATIONS);
        req.setAttribute("SPAM_TOPICS", (Object)SPAM_TOPICS);
    }
}

