/*
 * Decompiled with CFR 0.152.
 */
package clime.messadmin.providers.lifecycle;

import clime.messadmin.clickstream.HttpRequestInfo;
import clime.messadmin.clickstream.Utils;
import clime.messadmin.filter.MessAdminThreadLocal;
import clime.messadmin.model.ErrorData;
import clime.messadmin.model.Server;
import clime.messadmin.model.Session;
import clime.messadmin.providers.spi.RequestExceptionProvider;
import clime.messadmin.providers.spi.RequestLifeCycleProvider;
import clime.messadmin.utils.SessionUtils;
import java.util.LinkedList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ClickStreamGatherer
implements RequestLifeCycleProvider,
RequestExceptionProvider {
    public static final int MAX_SIZE = 100;

    public void requestInitialized(HttpServletRequest httpRequest, HttpServletResponse httpResponse, ServletContext servletContext) {
        String servletPath = SessionUtils.getRequestURLWithMethodAndQueryString((HttpServletRequest)httpRequest);
        if (httpRequest.getSession(false) != null) {
            Session session = Server.getInstance().getSession(httpRequest.getSession(false));
            HttpRequestInfo requestInfo = new HttpRequestInfo(servletPath);
            LinkedList list = Utils.getPluginData(session);
            if (list.size() >= 100) {
                list.removeFirst();
            }
            list.addLast(requestInfo);
            requestInfo.requestDate = MessAdminThreadLocal.getStartTime().getTime();
        }
    }

    public void requestDestroyed(HttpServletRequest httpRequest, HttpServletResponse httpResponse, ServletContext servletContext) {
        if (httpRequest.getSession(false) != null) {
            HttpRequestInfo requestInfo;
            Session session = Server.getInstance().getSession(httpRequest.getSession(false));
            LinkedList list = Utils.getPluginData(session);
            if (list.isEmpty()) {
                requestInfo = new HttpRequestInfo(SessionUtils.getRequestURLWithMethodAndQueryString((HttpServletRequest)httpRequest));
                list.addLast(requestInfo);
                requestInfo.requestDate = MessAdminThreadLocal.getStartTime().getTime();
            } else {
                requestInfo = (HttpRequestInfo)list.getLast();
            }
            requestInfo.usedTime = MessAdminThreadLocal.getUsedTime();
        }
    }

    public void requestException(Exception e, HttpServletRequest httpRequest, HttpServletResponse httpResponse, ServletContext servletContext) {
        this.requestDestroyed(httpRequest, httpResponse, servletContext);
        if (httpRequest.getSession(false) != null) {
            Session session = Server.getInstance().getSession(httpRequest.getSession(false));
            HttpRequestInfo requestInfo = (HttpRequestInfo)Utils.getPluginData(session).getLast();
            requestInfo.error = new ErrorData(httpRequest, (Throwable)e);
        }
    }

    public int getPriority() {
        return 10;
    }
}

