/**
 * 
 */
package clime.messadmin.providers.userdata;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpSession;

import clime.messadmin.clickstream.HttpRequestInfo;
import clime.messadmin.clickstream.Utils;
import clime.messadmin.model.Server;
import clime.messadmin.model.Session;
import clime.messadmin.providers.ProviderUtils;
import clime.messadmin.providers.spi.SessionDataProvider;
import clime.messadmin.providers.spi.SizeOfProvider;
import clime.messadmin.utils.BytesFormat;
import clime.messadmin.utils.DateUtils;

/**
 * @author C&eacute;drik LIME
 */
public class ClickStreamDisplayer implements SessionDataProvider {

	/**
	 * 
	 */
	public ClickStreamDisplayer() {
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	public int getPriority() {
		return 10;
	}

	/**
	 * {@inheritDoc}
	 */
	public String getSessionDataTitle(HttpSession httpSession) {
		Session session = Server.getInstance().getApplication(httpSession.getServletContext()).getSession(httpSession.getId());
		List data = new ArrayList(Utils.getPluginData(session));
		String result = "<span title=\"";
        long currentItemSize = -1;
        Iterator iterProv = ProviderUtils.getProviders(SizeOfProvider.class).iterator();
        while (currentItemSize < 0 && iterProv.hasNext()) {
			SizeOfProvider provider = (SizeOfProvider) iterProv.next();
			currentItemSize = provider.sizeof(data);
		}
		result += "data size: " + BytesFormat.getBytesInstance().format(currentItemSize);
		result += "\">ClickStream: last " + NumberFormat.getNumberInstance().format(data.size()) + " Servlet Requests</span>";
		return result;
	}

	/**
	 * {@inheritDoc}
	 */
	public String getXHTMLSessionData(HttpSession httpSession) {
		Session session = Server.getInstance().getApplication(httpSession.getServletContext()).getSession(httpSession.getId());
		final List data = new ArrayList(Utils.getPluginData(session));
		StringBuffer buffer = new StringBuffer(16 + data.size() * 120);
		buffer.append("<ol>\n");
		int hiddenRequests = session.getSessionInfo().getHits() - data.size();
		for (int i=0; i < hiddenRequests; ++i) {
			buffer.append("<li style=\"display: hidden; list-style-type: none;\"></li>\n");
		}
		NumberFormat numberFormatter = NumberFormat.getNumberInstance();
		Iterator iter = data.iterator();
		while (iter.hasNext()) {
			HttpRequestInfo request = (HttpRequestInfo) iter.next();
			boolean error = (request.getError() != null);
			buffer.append("<li title=\"");
			buffer.append(numberFormatter.format(request.getUsedTime())).append(" ms");
			buffer.append("\">");
			if (error) {
				buffer.append("<span style=\"color: red; font-weight: bolder;\">");
			}
			buffer.append(DateUtils.dateToFormattedDateTimeString(request.getRequestDate().getTime(), "yyyy-MM-dd HH:mm:ss")).append("&nbsp;&nbsp;");
			buffer.append(request.getURL());
			if (error) {
				buffer.append("</span>");
			}
			buffer.append("</li>\n");
		}
		buffer.append("</ol>\n");

		return buffer.toString();
	}

}
