/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mavenjlex;

import java.io.File;
import java.io.IOException;
import jlex.LexGenerator;
import jlex.LexOutput;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class JLexMojo
extends AbstractMojo {
    private FilePair[] files;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        LoggerLexOutput lexout = new LoggerLexOutput(log);
        for (int i = 0; i < this.files.length; ++i) {
            FilePair pair = this.files[i];
            if (pair == null) {
                throw new MojoExecutionException("File pair is empty");
            }
            File inFile = pair.getInputFile();
            File outFile = pair.getOutputFile();
            if (inFile == null || !inFile.exists()) {
                throw new MojoExecutionException("Input file is empty or doesn't exist");
            }
            if (outFile == null) {
                throw new MojoExecutionException("Output file is empty");
            }
            String in = inFile.getPath();
            String out = outFile.getPath();
            log.info((CharSequence)("jlex input<" + in + "> output<" + out + ">"));
            try {
                LexGenerator lg = new LexGenerator(in, out, lexout);
                lg.generate();
                continue;
            }
            catch (IOException ex) {
                throw new MojoExecutionException("An error occurred running jlex", (Exception)ex);
            }
            catch (Error ex) {
                throw new MojoExecutionException("An error occured running jlex", (Throwable)ex);
            }
        }
    }

    public static class FilePair {
        File inputFile;
        File outputFile;

        public File getInputFile() {
            return this.inputFile;
        }

        public void setInputFile(File inputFile) {
            this.inputFile = inputFile;
        }

        public File getOutputFile() {
            return this.outputFile;
        }

        public void setOutputFile(File outputFile) {
            this.outputFile = outputFile;
        }
    }

    private static class LoggerLexOutput
    implements LexOutput {
        Log log;
        StringBuffer buf = new StringBuffer();

        public LoggerLexOutput(Log log) {
            this.log = log;
        }

        public void println(Object o) {
            if (this.buf.length() > 0) {
                this.log.info((CharSequence)this.buf.toString());
                this.buf = new StringBuffer();
            }
            this.log.info((CharSequence)o.toString());
        }

        public void print(Object o) {
            this.buf.append(o);
        }
    }
}

