/*
 * Decompiled with CFR 0.152.
 */
package jlex;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import jlex.CUtility;

final class SparseBitSet
implements Cloneable {
    int[] offs;
    long[] bits;
    int size;
    private static final int LG_BITS = 6;
    private static final int BITS = 64;
    private static final int BITS_M1 = 63;
    private static final BinOp AND = new BinOp(){

        public final long op(long a, long b) {
            return a & b;
        }
    };
    private static final BinOp OR = new BinOp(){

        public final long op(long a, long b) {
            return a | b;
        }
    };
    private static final BinOp XOR = new BinOp(){

        public final long op(long a, long b) {
            return a ^ b;
        }
    };

    public SparseBitSet() {
        this.bits = new long[4];
        this.offs = new int[4];
        this.size = 0;
    }

    public SparseBitSet(int nbits) {
        this();
    }

    public SparseBitSet(SparseBitSet set) {
        this.bits = new long[set.size];
        this.offs = new int[set.size];
        this.size = 0;
    }

    private void new_block(int idx, int bnum) {
        if (this.size == this.bits.length) {
            long[] nbits = new long[this.size * 3];
            int[] noffs = new int[this.size * 3];
            System.arraycopy(this.bits, 0, nbits, 0, this.size);
            System.arraycopy(this.offs, 0, noffs, 0, this.size);
            this.bits = nbits;
            this.offs = noffs;
        }
        CUtility.ASSERT(this.size < this.bits.length);
        this.insert_block(idx, bnum);
    }

    private void insert_block(int idx, int bnum) {
        CUtility.ASSERT(idx <= this.size);
        CUtility.ASSERT(idx == this.size || this.offs[idx] != bnum);
        System.arraycopy(this.bits, idx, this.bits, idx + 1, this.size - idx);
        System.arraycopy(this.offs, idx, this.offs, idx + 1, this.size - idx);
        this.offs[idx] = bnum;
        this.bits[idx] = 0L;
        ++this.size;
    }

    private int bsearch(int bnum) {
        int l = 0;
        int r = this.size;
        while (l < r) {
            int p = (l + r) / 2;
            if (bnum < this.offs[p]) {
                r = p;
                continue;
            }
            if (bnum > this.offs[p]) {
                l = p + 1;
                continue;
            }
            return p;
        }
        CUtility.ASSERT(l == r);
        return l;
    }

    public void set(int bit) {
        int bnum = bit >> 6;
        int idx = this.bsearch(bnum);
        if (idx >= this.size || this.offs[idx] != bnum) {
            this.new_block(idx, bnum);
        }
        int n = idx;
        this.bits[n] = this.bits[n] | 1L << (bit & 0x3F);
    }

    public void clear(int bit) {
        int bnum = bit >> 6;
        int idx = this.bsearch(bnum);
        if (idx >= this.size || this.offs[idx] != bnum) {
            this.new_block(idx, bnum);
        }
        int n = idx;
        this.bits[n] = this.bits[n] & (1L << (bit & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clearAll() {
        this.size = 0;
    }

    public boolean get(int bit) {
        int bnum = bit >> 6;
        int idx = this.bsearch(bnum);
        if (idx >= this.size || this.offs[idx] != bnum) {
            return false;
        }
        return 0L != (this.bits[idx] & 1L << (bit & 0x3F));
    }

    public void and(SparseBitSet set) {
        SparseBitSet.binop(this, set, AND);
    }

    public void or(SparseBitSet set) {
        SparseBitSet.binop(this, set, OR);
    }

    public void xor(SparseBitSet set) {
        SparseBitSet.binop(this, set, XOR);
    }

    private static final void binop(SparseBitSet a, SparseBitSet b, BinOp op) {
        int a_size;
        int a_zero;
        int[] noffs;
        long[] nbits;
        int nsize = a.size + b.size;
        if (a.bits.length < nsize) {
            nbits = new long[nsize];
            noffs = new int[nsize];
            a_zero = 0;
            a_size = a.size;
        } else {
            nbits = a.bits;
            noffs = a.offs;
            a_zero = a.bits.length - a.size;
            a_size = a.bits.length;
            System.arraycopy(a.bits, 0, a.bits, a_zero, a.size);
            System.arraycopy(a.offs, 0, a.offs, a_zero, a.size);
        }
        nsize = 0;
        int i = a_zero;
        int j = 0;
        while (i < a_size || j < b.size) {
            int no;
            long nb;
            if (i < a_size && (j >= b.size || a.offs[i] < b.offs[j])) {
                nb = op.op(a.bits[i], 0L);
                no = a.offs[i];
                ++i;
            } else if (j < b.size && (i >= a_size || a.offs[i] > b.offs[j])) {
                nb = op.op(0L, b.bits[j]);
                no = b.offs[j];
                ++j;
            } else {
                nb = op.op(a.bits[i], b.bits[j]);
                no = a.offs[i];
                ++i;
                ++j;
            }
            if (nb == 0L) continue;
            nbits[nsize] = nb;
            noffs[nsize] = no;
            ++nsize;
        }
        a.bits = nbits;
        a.offs = noffs;
        a.size = nsize;
    }

    public int hashCode() {
        long h = 1234L;
        for (int i = 0; i < this.size; ++i) {
            h ^= this.bits[i] * (long)this.offs[i];
        }
        return (int)(h >> 32 ^ h);
    }

    public int size() {
        return this.size == 0 ? 0 : 1 + this.offs[this.size - 1] << 6;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof SparseBitSet) {
            return SparseBitSet.equals(this, (SparseBitSet)obj);
        }
        return false;
    }

    public static boolean equals(SparseBitSet a, SparseBitSet b) {
        int i = 0;
        int j = 0;
        while (i < a.size || j < b.size) {
            if (!(i < a.size && (j >= b.size || a.offs[i] < b.offs[j]) ? a.bits[i++] != 0L : (j < b.size && (i >= a.size || a.offs[i] > b.offs[j]) ? b.bits[j++] != 0L : a.bits[i++] != b.bits[j++]))) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        try {
            SparseBitSet set = (SparseBitSet)super.clone();
            set.bits = (long[])this.bits.clone();
            set.offs = (int[])this.offs.clone();
            return set;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Enumeration elements() {
        return new Enumeration(){
            int idx = -1;
            int bit = 64;
            {
                this.advance();
            }

            public boolean hasMoreElements() {
                return this.idx < SparseBitSet.this.size;
            }

            public Object nextElement() {
                int r = this.bit + (SparseBitSet.this.offs[this.idx] << 6);
                this.advance();
                return new Integer(r);
            }

            private void advance() {
                while (this.idx < SparseBitSet.this.size) {
                    while (++this.bit < 64) {
                        if (0L == (SparseBitSet.this.bits[this.idx] & 1L << this.bit)) continue;
                        return;
                    }
                    ++this.idx;
                    this.bit = -1;
                }
            }
        };
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(e.nextElement());
        }
        sb.append('}');
        return sb.toString();
    }

    public static void main(String[] args) {
        int ITER = 500;
        int RANGE = 65536;
        SparseBitSet a = new SparseBitSet();
        CUtility.ASSERT(!a.get(0) && !a.get(1));
        CUtility.ASSERT(!a.get(123329));
        a.set(0);
        CUtility.ASSERT(a.get(0) && !a.get(1));
        a.set(1);
        CUtility.ASSERT(a.get(0) && a.get(1));
        a.clearAll();
        CUtility.ASSERT(!a.get(0) && !a.get(1));
        Random r = new Random();
        Vector<Integer> v = new Vector<Integer>();
        for (int n = 0; n < 500; ++n) {
            int rr = (r.nextInt() >>> 1) % 65536 << 1;
            a.set(rr);
            v.addElement(new Integer(rr));
            CUtility.ASSERT(a.get(rr) && !a.get(rr + 1) && !a.get(rr - 1));
            for (int i = 0; i < v.size(); ++i) {
                CUtility.ASSERT(a.get((Integer)v.elementAt(i)));
            }
        }
        SparseBitSet b = (SparseBitSet)a.clone();
        CUtility.ASSERT(a.equals(b) && b.equals(a));
        for (int n = 0; n < 250; ++n) {
            int rr = (r.nextInt() >>> 1) % v.size();
            int m = (Integer)v.elementAt(rr);
            b.clear(m);
            v.removeElementAt(rr);
            CUtility.ASSERT(!b.get(m));
        }
        CUtility.ASSERT(!a.equals(b));
        SparseBitSet c = (SparseBitSet)a.clone();
        SparseBitSet d = (SparseBitSet)a.clone();
        c.and(a);
        CUtility.ASSERT(c.equals(a) && a.equals(c));
        c.xor(a);
        CUtility.ASSERT(!c.equals(a) && c.size() == 0);
        d.or(b);
        CUtility.ASSERT(d.equals(a) && !b.equals(d));
        d.and(b);
        CUtility.ASSERT(!d.equals(a) && b.equals(d));
        d.xor(a);
        CUtility.ASSERT(!d.equals(a) && !b.equals(d));
        c.or(d);
        c.or(b);
        CUtility.ASSERT(c.equals(a) && a.equals(c));
        c = (SparseBitSet)d.clone();
        c.and(b);
        CUtility.ASSERT(c.size() == 0);
        System.out.println("Success.");
    }

    private static interface BinOp {
        public long op(long var1, long var3);
    }
}

