/*
 * Decompiled with CFR 0.152.
 */
package jlex;

import jlex.CError;
import jlex.LexOutput;

class CUtility {
    static final boolean DEBUG = true;
    static final boolean SLOW_DEBUG = true;
    static final boolean DUMP_DEBUG = true;
    static final boolean DESCENT_DEBUG = false;
    static final boolean OLD_DEBUG = false;
    static final boolean OLD_DUMP_DEBUG = false;
    static final boolean FOODEBUG = false;
    static final boolean DO_DEBUG = false;
    static final int INT_MAX = Integer.MAX_VALUE;
    static final int MAX_SEVEN_BIT = 127;
    static final int MAX_EIGHT_BIT = 255;
    static final int MAX_SIXTEEN_BIT = 65535;

    CUtility() {
    }

    static void enter(String descent, char lexeme, int token, LexOutput out) {
        out.println("Entering " + descent + " [lexeme: " + lexeme + "] [token: " + token + "]");
    }

    static void leave(String descent, char lexeme, int token, LexOutput out) {
        out.println("Leaving " + descent + " [lexeme:" + lexeme + "] [token:" + token + "]");
    }

    static void ASSERT(boolean expr) {
        if (!expr) {
            throw new Error("Assertion Failed.");
        }
    }

    static char[] doubleSize(char[] oldBuffer) {
        char[] newBuffer = new char[2 * oldBuffer.length];
        for (int elem = 0; elem < oldBuffer.length; ++elem) {
            newBuffer[elem] = oldBuffer[elem];
        }
        return newBuffer;
    }

    static byte[] doubleSize(byte[] oldBuffer) {
        byte[] newBuffer = new byte[2 * oldBuffer.length];
        for (int elem = 0; elem < oldBuffer.length; ++elem) {
            newBuffer[elem] = oldBuffer[elem];
        }
        return newBuffer;
    }

    static char hex2bin(char c, LexOutput out) {
        if ('0' <= c && '9' >= c) {
            return (char)(c - 48);
        }
        if ('a' <= c && 'f' >= c) {
            return (char)(c - 97 + 10);
        }
        if ('A' <= c && 'F' >= c) {
            return (char)(c - 65 + 10);
        }
        CError.impos("Bad hexidecimal digit" + c, out);
        return '\u0000';
    }

    static boolean ishexdigit(char c) {
        return '0' <= c && '9' >= c || 'a' <= c && 'f' >= c || 'A' <= c && 'F' >= c;
    }

    static char oct2bin(char c, LexOutput out) {
        if ('0' <= c && '7' >= c) {
            return (char)(c - 48);
        }
        CError.impos("Bad octal digit " + c, out);
        return '\u0000';
    }

    static boolean isoctdigit(char c) {
        return '0' <= c && '7' >= c;
    }

    static boolean isspace(char c) {
        return '\b' == c || '\t' == c || '\n' == c || '\f' == c || '\r' == c || ' ' == c;
    }

    static boolean isnewline(char c) {
        return '\n' == c || '\r' == c;
    }

    static int bytencmp(byte[] a, int a_first, byte[] b, int b_first, int n) {
        for (int elem = 0; elem < n; ++elem) {
            if (0 == a[a_first + elem] && 0 == b[b_first + elem]) {
                return 0;
            }
            if (a[a_first + elem] < b[b_first + elem]) {
                return 1;
            }
            if (a[a_first + elem] <= b[b_first + elem]) continue;
            return -1;
        }
        return 0;
    }

    static int charncmp(char[] a, int a_first, char[] b, int b_first, int n) {
        for (int elem = 0; elem < n; ++elem) {
            if ('\u0000' == a[a_first + elem] && '\u0000' == b[b_first + elem]) {
                return 0;
            }
            if (a[a_first + elem] < b[b_first + elem]) {
                return 1;
            }
            if (a[a_first + elem] <= b[b_first + elem]) continue;
            return -1;
        }
        return 0;
    }
}

