/*
 * Decompiled with CFR 0.152.
 */
package jlex;

import java.util.Enumeration;
import java.util.Hashtable;
import jlex.CNfa;
import jlex.CSet;
import jlex.CSpec;
import jlex.LexOutput;
import jlex.SparseBitSet;

class CSimplifyNfa {
    private int[] ccls;
    private int original_charset_size;
    private int mapped_charset_size;
    private LexOutput out;

    CSimplifyNfa(LexOutput out) {
        this.out = out;
    }

    void simplify(CSpec m_spec) {
        this.computeClasses(m_spec);
        Enumeration e = m_spec.m_nfa_states.elements();
        while (e.hasMoreElements()) {
            CNfa nfa = (CNfa)e.nextElement();
            if (nfa.m_edge == -2 || nfa.m_edge == -3) continue;
            if (nfa.m_edge == -1) {
                CSet ncset = new CSet();
                ncset.map(nfa.m_set, this.ccls);
                nfa.m_set = ncset;
                continue;
            }
            nfa.m_edge = this.ccls[nfa.m_edge];
        }
        m_spec.m_ccls_map = this.ccls;
        m_spec.m_dtrans_ncols = this.mapped_charset_size;
    }

    private void computeClasses(CSpec m_spec) {
        this.original_charset_size = m_spec.m_dtrans_ncols;
        this.ccls = new int[this.original_charset_size];
        int nextcls = 1;
        SparseBitSet clsA = new SparseBitSet();
        SparseBitSet clsB = new SparseBitSet();
        Hashtable<Integer, Integer> h = new Hashtable<Integer, Integer>();
        this.out.print("Working on character classes.");
        Enumeration e = m_spec.m_nfa_states.elements();
        while (e.hasMoreElements()) {
            int i;
            CNfa nfa = (CNfa)e.nextElement();
            if (nfa.m_edge == -2 || nfa.m_edge == -3) continue;
            clsA.clearAll();
            clsB.clearAll();
            for (i = 0; i < this.ccls.length; ++i) {
                if (nfa.m_edge == i || nfa.m_edge == -1 && nfa.m_set.contains(i)) {
                    clsA.set(this.ccls[i]);
                    continue;
                }
                clsB.set(this.ccls[i]);
            }
            clsA.and(clsB);
            this.out.print(clsA.size() == 0 ? "." : ":");
            if (clsA.size() == 0) continue;
            h.clear();
            for (i = 0; i < this.ccls.length; ++i) {
                if (!clsA.get(this.ccls[i]) || nfa.m_edge != i && (nfa.m_edge != -1 || !nfa.m_set.contains(i))) continue;
                Integer split = new Integer(this.ccls[i]);
                if (!h.containsKey(split)) {
                    h.put(split, new Integer(nextcls++));
                }
                this.ccls[i] = (Integer)h.get(split);
            }
        }
        this.out.println("");
        this.out.println("NFA has " + nextcls + " distinct character classes.");
        this.mapped_charset_size = nextcls;
    }
}

