/*
 * Decompiled with CFR 0.152.
 */
package jlex;

import java.util.Stack;
import java.util.Vector;
import jlex.CAlloc;
import jlex.CBunch;
import jlex.CDTrans;
import jlex.CDfa;
import jlex.CLexGen;
import jlex.CNfa;
import jlex.CSpec;
import jlex.CUtility;
import jlex.LexOutput;
import jlex.SparseBitSet;

class CNfa2Dfa {
    private CSpec m_spec;
    private int m_unmarked_dfa;
    private CLexGen m_lexGen;
    private LexOutput out;
    private static final int NOT_IN_DSTATES = -1;

    CNfa2Dfa(LexOutput out) {
        this.reset();
        this.out = out;
    }

    private void set(CLexGen lexGen, CSpec spec) {
        this.m_lexGen = lexGen;
        this.m_spec = spec;
        this.m_unmarked_dfa = 0;
    }

    private void reset() {
        this.m_lexGen = null;
        this.m_spec = null;
        this.m_unmarked_dfa = 0;
    }

    void make_dfa(CLexGen lexGen, CSpec spec) {
        this.reset();
        this.set(lexGen, spec);
        this.make_dtrans();
        this.free_nfa_states();
        if (this.m_spec.m_verbose) {
            // empty if block
        }
        this.free_dfa_states();
    }

    private void make_dtrans() {
        this.out.print("Working on DFA states.");
        CBunch bunch = new CBunch();
        this.m_unmarked_dfa = 0;
        int nstates = this.m_spec.m_state_rules.length;
        this.m_spec.m_state_dtrans = new int[nstates];
        for (int istate = 0; nstates > istate; ++istate) {
            CDfa dfa;
            int i;
            bunch.m_nfa_set = (Vector)this.m_spec.m_state_rules[istate].clone();
            this.sortStates(bunch.m_nfa_set);
            bunch.m_nfa_bit = new SparseBitSet();
            int size = bunch.m_nfa_set.size();
            for (i = 0; size > i; ++i) {
                CNfa nfa = (CNfa)bunch.m_nfa_set.elementAt(i);
                bunch.m_nfa_bit.set(nfa.m_label);
            }
            bunch.m_accept = null;
            bunch.m_anchor = 0;
            bunch.m_accept_index = Integer.MAX_VALUE;
            this.e_closure(bunch);
            this.add_to_dstates(bunch);
            this.m_spec.m_state_dtrans[istate] = this.m_spec.m_dtrans_vector.size();
            while (null != (dfa = this.get_unmarked())) {
                this.out.print(".");
                System.out.flush();
                CUtility.ASSERT(false == dfa.m_mark);
                dfa.m_mark = true;
                CDTrans dtrans = new CDTrans(this.m_spec.m_dtrans_vector.size(), this.m_spec);
                dtrans.m_accept = dfa.m_accept;
                dtrans.m_anchor = dfa.m_anchor;
                for (i = 0; i < this.m_spec.m_dtrans_ncols; ++i) {
                    int nextstate;
                    CUtility.ASSERT(0 <= i);
                    CUtility.ASSERT(this.m_spec.m_dtrans_ncols > i);
                    this.move(dfa.m_nfa_set, dfa.m_nfa_bit, i, bunch);
                    if (null != bunch.m_nfa_set) {
                        this.e_closure(bunch);
                    }
                    CUtility.ASSERT(null == bunch.m_nfa_set && null == bunch.m_nfa_bit || null != bunch.m_nfa_set && null != bunch.m_nfa_bit);
                    if (null == bunch.m_nfa_set) {
                        nextstate = -1;
                    } else {
                        nextstate = this.in_dstates(bunch);
                        if (-1 == nextstate) {
                            nextstate = this.add_to_dstates(bunch);
                        }
                    }
                    CUtility.ASSERT(nextstate < this.m_spec.m_dfa_states.size());
                    dtrans.m_dtrans[i] = nextstate;
                }
                CUtility.ASSERT(this.m_spec.m_dtrans_vector.size() == dfa.m_label);
                this.m_spec.m_dtrans_vector.addElement(dtrans);
            }
        }
        this.out.println("");
    }

    private void free_dfa_states() {
        this.m_spec.m_dfa_states = null;
        this.m_spec.m_dfa_sets = null;
    }

    private void free_nfa_states() {
        this.m_spec.m_nfa_states = null;
        this.m_spec.m_nfa_start = null;
        this.m_spec.m_state_rules = null;
    }

    private void e_closure(CBunch bunch) {
        CNfa state;
        CUtility.ASSERT(null != bunch);
        CUtility.ASSERT(null != bunch.m_nfa_set);
        CUtility.ASSERT(null != bunch.m_nfa_bit);
        bunch.m_accept = null;
        bunch.m_anchor = 0;
        bunch.m_accept_index = Integer.MAX_VALUE;
        Stack<CNfa> nfa_stack = new Stack<CNfa>();
        int size = bunch.m_nfa_set.size();
        for (int i = 0; i < size; ++i) {
            state = (CNfa)bunch.m_nfa_set.elementAt(i);
            CUtility.ASSERT(bunch.m_nfa_bit.get(state.m_label));
            nfa_stack.push(state);
        }
        while (!nfa_stack.empty()) {
            state = (CNfa)nfa_stack.pop();
            if (null != state.m_accept && state.m_label < bunch.m_accept_index) {
                bunch.m_accept_index = state.m_label;
                bunch.m_accept = state.m_accept;
                bunch.m_anchor = state.m_anchor;
                CUtility.ASSERT(null != bunch.m_accept);
                CUtility.ASSERT(0 == bunch.m_anchor || 0 != (bunch.m_anchor & 2) || 0 != (bunch.m_anchor & 1));
            }
            if (-3 != state.m_edge) continue;
            if (null != state.m_next && !bunch.m_nfa_set.contains(state.m_next)) {
                CUtility.ASSERT(false == bunch.m_nfa_bit.get(state.m_next.m_label));
                bunch.m_nfa_bit.set(state.m_next.m_label);
                bunch.m_nfa_set.addElement(state.m_next);
                nfa_stack.push(state.m_next);
            }
            if (null == state.m_next2 || bunch.m_nfa_set.contains(state.m_next2)) continue;
            CUtility.ASSERT(false == bunch.m_nfa_bit.get(state.m_next2.m_label));
            bunch.m_nfa_bit.set(state.m_next2.m_label);
            bunch.m_nfa_set.addElement(state.m_next2);
            nfa_stack.push(state.m_next2);
        }
        if (null != bunch.m_nfa_set) {
            this.sortStates(bunch.m_nfa_set);
        }
    }

    void move(Vector nfa_set, SparseBitSet nfa_bit, int b, CBunch bunch) {
        bunch.m_nfa_set = null;
        bunch.m_nfa_bit = null;
        int size = nfa_set.size();
        for (int index = 0; index < size; ++index) {
            CNfa state = (CNfa)nfa_set.elementAt(index);
            if (b != state.m_edge && (-1 != state.m_edge || !state.m_set.contains(b))) continue;
            if (null == bunch.m_nfa_set) {
                CUtility.ASSERT(null == bunch.m_nfa_bit);
                bunch.m_nfa_set = new Vector();
                bunch.m_nfa_bit = new SparseBitSet();
            }
            bunch.m_nfa_set.addElement(state.m_next);
            bunch.m_nfa_bit.set(state.m_next.m_label);
        }
        if (null != bunch.m_nfa_set) {
            CUtility.ASSERT(null != bunch.m_nfa_bit);
            this.sortStates(bunch.m_nfa_set);
        }
    }

    private void sortStates(Vector nfa_set) {
        int size = nfa_set.size();
        for (int begin = 0; begin < size; ++begin) {
            CNfa elem = (CNfa)nfa_set.elementAt(begin);
            int smallest_value = elem.m_label;
            int smallest_index = begin;
            for (int index = begin + 1; index < size; ++index) {
                elem = (CNfa)nfa_set.elementAt(index);
                int value = elem.m_label;
                if (value >= smallest_value) continue;
                smallest_index = index;
                smallest_value = value;
            }
            CNfa begin_elem = (CNfa)nfa_set.elementAt(begin);
            elem = (CNfa)nfa_set.elementAt(smallest_index);
            nfa_set.setElementAt(elem, begin);
            nfa_set.setElementAt(begin_elem, smallest_index);
        }
    }

    private CDfa get_unmarked() {
        int size = this.m_spec.m_dfa_states.size();
        while (this.m_unmarked_dfa < size) {
            CDfa dfa = (CDfa)this.m_spec.m_dfa_states.elementAt(this.m_unmarked_dfa);
            if (!dfa.m_mark) {
                if (this.m_spec.m_verbose) {
                    // empty if block
                }
                return dfa;
            }
            ++this.m_unmarked_dfa;
        }
        return null;
    }

    private int add_to_dstates(CBunch bunch) {
        CUtility.ASSERT(null != bunch.m_nfa_set);
        CUtility.ASSERT(null != bunch.m_nfa_bit);
        CUtility.ASSERT(null != bunch.m_accept || 0 == bunch.m_anchor);
        CDfa dfa = CAlloc.newCDfa(this.m_spec);
        dfa.m_nfa_set = (Vector)bunch.m_nfa_set.clone();
        dfa.m_nfa_bit = (SparseBitSet)bunch.m_nfa_bit.clone();
        dfa.m_accept = bunch.m_accept;
        dfa.m_anchor = bunch.m_anchor;
        dfa.m_mark = false;
        this.m_spec.m_dfa_sets.put(dfa.m_nfa_bit, dfa);
        return dfa.m_label;
    }

    private int in_dstates(CBunch bunch) {
        CDfa dfa = (CDfa)this.m_spec.m_dfa_sets.get(bunch.m_nfa_bit);
        if (null != dfa) {
            return dfa.m_label;
        }
        return -1;
    }
}

