/*
 * Decompiled with CFR 0.152.
 */
package jlex;

import java.util.Vector;
import jlex.CDTrans;
import jlex.CSpec;
import jlex.CUtility;
import jlex.LexOutput;
import jlex.SparseBitSet;

class CMinimize {
    CSpec m_spec;
    Vector m_group;
    int[] m_ingroup;
    private LexOutput out;

    CMinimize(LexOutput out) {
        this.reset();
        this.out = out;
    }

    private void reset() {
        this.m_spec = null;
        this.m_group = null;
        this.m_ingroup = null;
    }

    private void set(CSpec spec) {
        CUtility.ASSERT(null != spec);
        this.m_spec = spec;
        this.m_group = null;
        this.m_ingroup = null;
    }

    void min_dfa(CSpec spec) {
        this.set(spec);
        this.minimize();
        this.reduce();
        this.reset();
    }

    private void col_copy(int dest, int src) {
        int n = this.m_spec.m_dtrans_vector.size();
        for (int i = 0; i < n; ++i) {
            CDTrans dtrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i);
            dtrans.m_dtrans[dest] = dtrans.m_dtrans[src];
        }
    }

    private void trunc_col() {
        int n = this.m_spec.m_dtrans_vector.size();
        for (int i = 0; i < n; ++i) {
            int[] ndtrans = new int[this.m_spec.m_dtrans_ncols];
            CDTrans dtrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i);
            System.arraycopy(dtrans.m_dtrans, 0, ndtrans, 0, ndtrans.length);
            dtrans.m_dtrans = ndtrans;
        }
    }

    private void row_copy(int dest, int src) {
        CDTrans dtrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(src);
        this.m_spec.m_dtrans_vector.setElementAt(dtrans, dest);
    }

    private boolean col_equiv(int col1, int col2) {
        int n = this.m_spec.m_dtrans_vector.size();
        for (int i = 0; i < n; ++i) {
            CDTrans dtrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i);
            if (dtrans.m_dtrans[col1] == dtrans.m_dtrans[col2]) continue;
            return false;
        }
        return true;
    }

    private boolean row_equiv(int row1, int row2) {
        CDTrans dtrans1 = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(row1);
        CDTrans dtrans2 = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(row2);
        for (int i = 0; i < this.m_spec.m_dtrans_ncols; ++i) {
            if (dtrans1.m_dtrans[i] == dtrans2.m_dtrans[i]) continue;
            return false;
        }
        return true;
    }

    private void reduce() {
        int j;
        int i;
        SparseBitSet set = new SparseBitSet();
        int size = this.m_spec.m_dtrans_vector.size();
        this.m_spec.m_anchor_array = new int[size];
        this.m_spec.m_accept_vector = new Vector();
        for (i = 0; i < size; ++i) {
            CDTrans dtrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i);
            this.m_spec.m_accept_vector.addElement(dtrans.m_accept);
            this.m_spec.m_anchor_array[i] = dtrans.m_anchor;
            dtrans.m_accept = null;
        }
        this.m_spec.m_col_map = new int[this.m_spec.m_dtrans_ncols];
        for (i = 0; i < this.m_spec.m_dtrans_ncols; ++i) {
            this.m_spec.m_col_map[i] = -1;
        }
        int reduced_ncols = 0;
        while (true) {
            for (i = 0; i < reduced_ncols; ++i) {
                CUtility.ASSERT(-1 != this.m_spec.m_col_map[i]);
            }
            for (i = reduced_ncols; i < this.m_spec.m_dtrans_ncols && -1 != this.m_spec.m_col_map[i]; ++i) {
            }
            if (i >= this.m_spec.m_dtrans_ncols) break;
            CUtility.ASSERT(false == set.get(i));
            CUtility.ASSERT(-1 == this.m_spec.m_col_map[i]);
            set.set(i);
            this.m_spec.m_col_map[i] = reduced_ncols;
            for (j = i + 1; j < this.m_spec.m_dtrans_ncols; ++j) {
                if (-1 != this.m_spec.m_col_map[j] || !this.col_equiv(i, j)) continue;
                this.m_spec.m_col_map[j] = reduced_ncols;
            }
            ++reduced_ncols;
        }
        int k = 0;
        for (i = 0; i < this.m_spec.m_dtrans_ncols; ++i) {
            if (!set.get(i)) continue;
            ++k;
            set.clear(i);
            j = this.m_spec.m_col_map[i];
            CUtility.ASSERT(j <= i);
            if (j == i) continue;
            this.col_copy(j, i);
        }
        this.m_spec.m_dtrans_ncols = reduced_ncols;
        this.trunc_col();
        CUtility.ASSERT(k == reduced_ncols);
        int nrows = this.m_spec.m_dtrans_vector.size();
        this.m_spec.m_row_map = new int[nrows];
        for (i = 0; i < nrows; ++i) {
            this.m_spec.m_row_map[i] = -1;
        }
        int reduced_nrows = 0;
        while (true) {
            for (i = 0; i < reduced_nrows; ++i) {
                CUtility.ASSERT(-1 != this.m_spec.m_row_map[i]);
            }
            for (i = reduced_nrows; i < nrows && -1 != this.m_spec.m_row_map[i]; ++i) {
            }
            if (i >= nrows) break;
            CUtility.ASSERT(false == set.get(i));
            CUtility.ASSERT(-1 == this.m_spec.m_row_map[i]);
            set.set(i);
            this.m_spec.m_row_map[i] = reduced_nrows;
            for (j = i + 1; j < nrows; ++j) {
                if (-1 != this.m_spec.m_row_map[j] || !this.row_equiv(i, j)) continue;
                this.m_spec.m_row_map[j] = reduced_nrows;
            }
            ++reduced_nrows;
        }
        k = 0;
        for (i = 0; i < nrows; ++i) {
            if (!set.get(i)) continue;
            ++k;
            set.clear(i);
            j = this.m_spec.m_row_map[i];
            CUtility.ASSERT(j <= i);
            if (j == i) continue;
            this.row_copy(j, i);
        }
        this.m_spec.m_dtrans_vector.setSize(reduced_nrows);
        CUtility.ASSERT(k == reduced_nrows);
    }

    private void fix_dtrans() {
        int i;
        Vector<CDTrans> new_vector = new Vector<CDTrans>();
        int size = this.m_spec.m_state_dtrans.length;
        for (i = 0; i < size; ++i) {
            if (-1 == this.m_spec.m_state_dtrans[i]) continue;
            this.m_spec.m_state_dtrans[i] = this.m_ingroup[this.m_spec.m_state_dtrans[i]];
        }
        size = this.m_group.size();
        for (i = 0; i < size; ++i) {
            Vector dtrans_group = (Vector)this.m_group.elementAt(i);
            CDTrans first = (CDTrans)dtrans_group.elementAt(0);
            new_vector.addElement(first);
            for (int c = 0; c < this.m_spec.m_dtrans_ncols; ++c) {
                if (-1 == first.m_dtrans[c]) continue;
                first.m_dtrans[c] = this.m_ingroup[first.m_dtrans[c]];
            }
        }
        this.m_group = null;
        this.m_spec.m_dtrans_vector = new_vector;
    }

    private void minimize() {
        this.init_groups();
        int group_count = this.m_group.size();
        int old_group_count = group_count - 1;
        while (old_group_count != group_count) {
            old_group_count = group_count;
            CUtility.ASSERT(this.m_group.size() == group_count);
            for (int i = 0; i < group_count; ++i) {
                Vector dtrans_group = (Vector)this.m_group.elementAt(i);
                int group_size = dtrans_group.size();
                if (group_size <= 1) continue;
                Vector<CDTrans> new_group = new Vector<CDTrans>();
                boolean added = false;
                CDTrans first = (CDTrans)dtrans_group.elementAt(0);
                block2: for (int j = 1; j < group_size; ++j) {
                    CDTrans next = (CDTrans)dtrans_group.elementAt(j);
                    for (int c = 0; c < this.m_spec.m_dtrans_ncols; ++c) {
                        int goto_first = first.m_dtrans[c];
                        int goto_next = next.m_dtrans[c];
                        if (goto_first == goto_next || goto_first != -1 && goto_next != -1 && this.m_ingroup[goto_next] == this.m_ingroup[goto_first]) continue;
                        CUtility.ASSERT(dtrans_group.elementAt(j) == next);
                        dtrans_group.removeElementAt(j);
                        --j;
                        --group_size;
                        new_group.addElement(next);
                        if (!added) {
                            added = true;
                            ++group_count;
                            this.m_group.addElement(new_group);
                        }
                        this.m_ingroup[next.m_label] = this.m_group.size() - 1;
                        CUtility.ASSERT(this.m_group.contains(new_group));
                        CUtility.ASSERT(this.m_group.contains(dtrans_group));
                        CUtility.ASSERT(dtrans_group.contains(first));
                        CUtility.ASSERT(!dtrans_group.contains(next));
                        CUtility.ASSERT(!new_group.contains(first));
                        CUtility.ASSERT(new_group.contains(next));
                        CUtility.ASSERT(dtrans_group.size() == group_size);
                        CUtility.ASSERT(i == this.m_ingroup[first.m_label]);
                        CUtility.ASSERT(this.m_group.size() - 1 == this.m_ingroup[next.m_label]);
                        continue block2;
                    }
                }
            }
        }
        this.out.println(this.m_group.size() + " states after removal of redundant states.");
        if (this.m_spec.m_verbose) {
            // empty if block
        }
        this.fix_dtrans();
    }

    private void init_groups() {
        this.m_group = new Vector();
        int group_count = 0;
        int size = this.m_spec.m_dtrans_vector.size();
        this.m_ingroup = new int[size];
        for (int i = 0; i < size; ++i) {
            Vector<CDTrans> dtrans_group;
            boolean group_found = false;
            CDTrans dtrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i);
            CUtility.ASSERT(i == dtrans.m_label);
            CUtility.ASSERT(false == group_found);
            CUtility.ASSERT(group_count == this.m_group.size());
            for (int j = 0; j < group_count; ++j) {
                dtrans_group = (Vector<CDTrans>)this.m_group.elementAt(j);
                CUtility.ASSERT(false == group_found);
                CUtility.ASSERT(0 < dtrans_group.size());
                CDTrans first = (CDTrans)dtrans_group.elementAt(0);
                int s = dtrans_group.size();
                CUtility.ASSERT(0 < s);
                for (int k = 1; k < s; ++k) {
                    CDTrans check = (CDTrans)dtrans_group.elementAt(k);
                    CUtility.ASSERT(check.m_accept == first.m_accept);
                }
                if (first.m_accept != dtrans.m_accept) continue;
                dtrans_group.addElement(dtrans);
                this.m_ingroup[i] = j;
                group_found = true;
                CUtility.ASSERT(j == this.m_ingroup[dtrans.m_label]);
                break;
            }
            if (group_found) continue;
            dtrans_group = new Vector<CDTrans>();
            dtrans_group.addElement(dtrans);
            this.m_ingroup[i] = this.m_group.size();
            this.m_group.addElement(dtrans_group);
            ++group_count;
        }
        if (this.m_spec.m_verbose) {
            // empty if block
        }
    }

    private void pset(Vector dtrans_group) {
        int size = dtrans_group.size();
        for (int i = 0; i < size; ++i) {
            CDTrans dtrans = (CDTrans)dtrans_group.elementAt(i);
            this.out.print(dtrans.m_label + " ");
        }
    }

    private void pgroups() {
        int i;
        int group_size = this.m_group.size();
        for (i = 0; i < group_size; ++i) {
            this.out.print("\tGroup " + i + " {");
            this.pset((Vector)this.m_group.elementAt(i));
            this.out.println("}");
            this.out.println("");
        }
        this.out.println("");
        int dtrans_size = this.m_spec.m_dtrans_vector.size();
        for (i = 0; i < dtrans_size; ++i) {
            this.out.println("\tstate " + i + " is in group " + this.m_ingroup[i]);
        }
    }
}

