/*
 * Decompiled with CFR 0.152.
 */
package jlex;

import java.io.IOException;
import java.util.Vector;
import jlex.CAccept;
import jlex.CAlloc;
import jlex.CError;
import jlex.CInput;
import jlex.CLexGen;
import jlex.CNfa;
import jlex.CNfaPair;
import jlex.CSet;
import jlex.CSpec;
import jlex.CUtility;
import jlex.LexOutput;
import jlex.SparseBitSet;

class CMakeNfa {
    private CSpec m_spec;
    private CLexGen m_lexGen;
    private CInput m_input;
    private LexOutput out;

    CMakeNfa(LexOutput out) {
        this.reset();
        this.out = out;
    }

    private void reset() {
        this.m_input = null;
        this.m_lexGen = null;
        this.m_spec = null;
    }

    private void set(CLexGen lexGen, CSpec spec, CInput input) {
        CUtility.ASSERT(null != input);
        CUtility.ASSERT(null != lexGen);
        CUtility.ASSERT(null != spec);
        this.m_input = input;
        this.m_lexGen = lexGen;
        this.m_spec = spec;
    }

    void allocate_BOL_EOF(CSpec spec) {
        CUtility.ASSERT(true);
        spec.BOL = spec.m_dtrans_ncols++;
        spec.EOF = spec.m_dtrans_ncols++;
    }

    void thompson(CLexGen lexGen, CSpec spec, CInput input) throws IOException {
        int i;
        this.reset();
        this.set(lexGen, spec, input);
        int size = this.m_spec.m_states.size();
        this.m_spec.m_state_rules = new Vector[size];
        for (i = 0; i < size; ++i) {
            this.m_spec.m_state_rules[i] = new Vector();
        }
        this.m_spec.m_nfa_start = this.machine();
        size = this.m_spec.m_nfa_states.size();
        i = 0;
        while (i < size) {
            CNfa elem = (CNfa)this.m_spec.m_nfa_states.elementAt(i);
            elem.m_label = i++;
        }
        if (this.m_spec.m_verbose) {
            this.out.println("NFA comprised of " + (this.m_spec.m_nfa_states.size() + 1) + " states.");
        }
        this.reset();
    }

    private void discardCNfa(CNfa nfa) {
        this.m_spec.m_nfa_states.removeElement(nfa);
    }

    private void processStates(SparseBitSet states, CNfa current) {
        int size = this.m_spec.m_states.size();
        for (int i = 0; i < size; ++i) {
            if (!states.get(i)) continue;
            this.m_spec.m_state_rules[i].addElement(current);
        }
    }

    private CNfa machine() throws IOException {
        CNfa start;
        CNfa p = start = CAlloc.newCNfa(this.m_spec);
        SparseBitSet states = this.m_lexGen.getStates();
        this.m_spec.m_current_token = 1;
        this.m_lexGen.advance();
        if (11 != this.m_spec.m_current_token) {
            p.m_next = this.rule();
            this.processStates(states, p.m_next);
        }
        while (11 != this.m_spec.m_current_token) {
            states = this.m_lexGen.getStates();
            this.m_lexGen.advance();
            if (11 == this.m_spec.m_current_token) break;
            p = p.m_next2 = CAlloc.newCNfa(this.m_spec);
            p.m_next = this.rule();
            this.processStates(states, p.m_next);
        }
        SparseBitSet all_states = new SparseBitSet();
        for (int i = 0; i < this.m_spec.m_states.size(); ++i) {
            all_states.set(i);
        }
        p = p.m_next2 = CAlloc.newCNfa(this.m_spec);
        p.m_next = CAlloc.newCNfa(this.m_spec);
        p.m_next.m_edge = -1;
        p.m_next.m_next = CAlloc.newCNfa(this.m_spec);
        p.m_next.m_set = new CSet();
        p.m_next.m_set.add(this.m_spec.BOL);
        p.m_next.m_set.add(this.m_spec.EOF);
        p.m_next.m_next.m_accept = new CAccept(new char[0], 0, this.m_input.m_line_number + 1);
        this.processStates(all_states, p.m_next);
        return start;
    }

    private CNfa rule() throws IOException {
        CNfa start = null;
        CNfa end = null;
        int anchor = 0;
        CNfaPair pair = CAlloc.newCNfaPair();
        if (3 == this.m_spec.m_current_token) {
            anchor |= 1;
            this.m_lexGen.advance();
            this.expr(pair);
            start = CAlloc.newCNfa(this.m_spec);
            start.m_edge = this.m_spec.BOL;
            start.m_next = pair.m_start;
            end = pair.m_end;
        } else {
            this.expr(pair);
            start = pair.m_start;
            end = pair.m_end;
        }
        if (4 == this.m_spec.m_current_token) {
            this.m_lexGen.advance();
            CNfaPair nlpair = CAlloc.newNLPair(this.m_spec);
            end.m_next = CAlloc.newCNfa(this.m_spec);
            end.m_next.m_next = nlpair.m_start;
            end.m_next.m_next2 = CAlloc.newCNfa(this.m_spec);
            end.m_next.m_next2.m_edge = this.m_spec.EOF;
            end.m_next.m_next2.m_next = nlpair.m_end;
            end = nlpair.m_end;
            anchor |= 2;
        }
        if (end == null) {
            CError.parse_error(19, this.m_input.m_line_number, this.out);
        }
        end.m_accept = this.m_lexGen.packAccept();
        end.m_anchor = anchor;
        return start;
    }

    private void expr(CNfaPair pair) throws IOException {
        CUtility.ASSERT(null != pair);
        CNfaPair e2_pair = CAlloc.newCNfaPair();
        this.cat_expr(pair);
        while (16 == this.m_spec.m_current_token) {
            this.m_lexGen.advance();
            this.cat_expr(e2_pair);
            CNfa p = CAlloc.newCNfa(this.m_spec);
            p.m_next2 = e2_pair.m_start;
            p.m_next = pair.m_start;
            pair.m_start = p;
            pair.m_end.m_next = p = CAlloc.newCNfa(this.m_spec);
            e2_pair.m_end.m_next = p;
            pair.m_end = p;
        }
    }

    private void cat_expr(CNfaPair pair) throws IOException {
        CUtility.ASSERT(null != pair);
        CNfaPair e2_pair = CAlloc.newCNfaPair();
        if (this.first_in_cat(this.m_spec.m_current_token)) {
            this.factor(pair);
        }
        while (this.first_in_cat(this.m_spec.m_current_token)) {
            this.factor(e2_pair);
            pair.m_end.mimic(e2_pair.m_start);
            this.discardCNfa(e2_pair.m_start);
            pair.m_end = e2_pair.m_end;
        }
    }

    private boolean first_in_cat(int token) {
        switch (token) {
            case 1: 
            case 4: 
            case 8: 
            case 16: {
                return false;
            }
            case 9: 
            case 15: 
            case 17: {
                CError.parse_error(5, this.m_input.m_line_number, this.out);
                return false;
            }
            case 5: {
                CError.parse_error(3, this.m_input.m_line_number, this.out);
                return false;
            }
            case 3: {
                CError.parse_error(4, this.m_input.m_line_number, this.out);
                return false;
            }
        }
        return true;
    }

    private void factor(CNfaPair pair) throws IOException {
        CNfa start = null;
        CNfa end = null;
        this.term(pair);
        if (9 == this.m_spec.m_current_token || 17 == this.m_spec.m_current_token || 15 == this.m_spec.m_current_token) {
            start = CAlloc.newCNfa(this.m_spec);
            end = CAlloc.newCNfa(this.m_spec);
            start.m_next = pair.m_start;
            pair.m_end.m_next = end;
            if (9 == this.m_spec.m_current_token || 15 == this.m_spec.m_current_token) {
                start.m_next2 = end;
            }
            if (9 == this.m_spec.m_current_token || 17 == this.m_spec.m_current_token) {
                pair.m_end.m_next2 = pair.m_start;
            }
            pair.m_start = start;
            pair.m_end = end;
            this.m_lexGen.advance();
        }
    }

    private void term(CNfaPair pair) throws IOException {
        if (14 == this.m_spec.m_current_token) {
            this.m_lexGen.advance();
            this.expr(pair);
            if (8 == this.m_spec.m_current_token) {
                this.m_lexGen.advance();
            } else {
                CError.parse_error(16, this.m_input.m_line_number, this.out);
            }
        } else {
            CNfa start;
            pair.m_start = start = CAlloc.newCNfa(this.m_spec);
            pair.m_end = start.m_next = CAlloc.newCNfa(this.m_spec);
            boolean isAlphaL = 12 == this.m_spec.m_current_token && Character.isLetter(this.m_spec.m_lexeme);
            if (!(2 == this.m_spec.m_current_token || 6 == this.m_spec.m_current_token || this.m_spec.m_ignorecase && isAlphaL)) {
                start.m_edge = this.m_spec.m_lexeme;
                this.m_lexGen.advance();
            } else {
                start.m_edge = -1;
                start.m_set = new CSet();
                if (this.m_spec.m_ignorecase && isAlphaL) {
                    start.m_set.addncase(this.m_spec.m_lexeme);
                } else if (2 == this.m_spec.m_current_token) {
                    start.m_set.add(10);
                    start.m_set.add(13);
                    start.m_set.add(this.m_spec.BOL);
                    start.m_set.add(this.m_spec.EOF);
                    start.m_set.complement();
                } else {
                    this.m_lexGen.advance();
                    if (3 == this.m_spec.m_current_token) {
                        this.m_lexGen.advance();
                        start.m_set.add(this.m_spec.BOL);
                        start.m_set.add(this.m_spec.EOF);
                        start.m_set.complement();
                    }
                    if (!(5 == this.m_spec.m_current_token)) {
                        this.dodash(start.m_set);
                    }
                }
                this.m_lexGen.advance();
            }
        }
    }

    private void dodash(CSet set) throws IOException {
        int first = -1;
        while (1 != this.m_spec.m_current_token && 5 != this.m_spec.m_current_token) {
            if (10 == this.m_spec.m_current_token && -1 != first) {
                this.m_lexGen.advance();
                if (this.m_spec.m_current_token == 5) {
                    set.add(45);
                    break;
                }
                while (first <= this.m_spec.m_lexeme) {
                    if (this.m_spec.m_ignorecase) {
                        set.addncase((char)first);
                    } else {
                        set.add(first);
                    }
                    ++first;
                }
            } else {
                first = this.m_spec.m_lexeme;
                if (this.m_spec.m_ignorecase) {
                    set.addncase(this.m_spec.m_lexeme);
                } else {
                    set.add(this.m_spec.m_lexeme);
                }
            }
            this.m_lexGen.advance();
        }
    }
}

