/*
 * Decompiled with CFR 0.152.
 */
package jlex;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jlex.CAccept;
import jlex.CDTrans;
import jlex.CEmit;
import jlex.CError;
import jlex.CInput;
import jlex.CMakeNfa;
import jlex.CMinimize;
import jlex.CNfa;
import jlex.CNfa2Dfa;
import jlex.CSet;
import jlex.CSimplifyNfa;
import jlex.CSpec;
import jlex.CUtility;
import jlex.LexOutput;
import jlex.SparseBitSet;
import jlex.SystemOutLexOutput;

class CLexGen {
    private Reader m_instream;
    private PrintWriter m_outstream;
    private CInput m_input;
    private Hashtable m_tokens;
    private CSpec m_spec;
    private boolean m_init_flag;
    private CMakeNfa m_makeNfa;
    private CNfa2Dfa m_nfa2dfa;
    private CMinimize m_minimize;
    private CSimplifyNfa m_simplifyNfa;
    private CEmit m_emit;
    private static final boolean ERROR = false;
    private static final boolean NOT_ERROR = true;
    private static final int BUFFER_SIZE = 1024;
    static final int EOS = 1;
    static final int ANY = 2;
    static final int AT_BOL = 3;
    static final int AT_EOL = 4;
    static final int CCL_END = 5;
    static final int CCL_START = 6;
    static final int CLOSE_CURLY = 7;
    static final int CLOSE_PAREN = 8;
    static final int CLOSURE = 9;
    static final int DASH = 10;
    static final int END_OF_INPUT = 11;
    static final int L = 12;
    static final int OPEN_CURLY = 13;
    static final int OPEN_PAREN = 14;
    static final int OPTIONAL = 15;
    static final int OR = 16;
    static final int PLUS_CLOSE = 17;
    private LexOutput out;
    private final int CLASS_CODE = 0;
    private final int INIT_CODE = 1;
    private final int EOF_CODE = 2;
    private final int INIT_THROW_CODE = 3;
    private final int YYLEX_THROW_CODE = 4;
    private final int EOF_THROW_CODE = 5;
    private final int EOF_VALUE_CODE = 6;
    private char[] m_state_dir = new char[]{'%', 's', 't', 'a', 't', 'e', '\u0000'};
    private char[] m_char_dir = new char[]{'%', 'c', 'h', 'a', 'r', '\u0000'};
    private char[] m_line_dir = new char[]{'%', 'l', 'i', 'n', 'e', '\u0000'};
    private char[] m_cup_dir = new char[]{'%', 'c', 'u', 'p', '\u0000'};
    private char[] m_class_dir = new char[]{'%', 'c', 'l', 'a', 's', 's', '\u0000'};
    private char[] m_implements_dir = new char[]{'%', 'i', 'm', 'p', 'l', 'e', 'm', 'e', 'n', 't', 's', '\u0000'};
    private char[] m_function_dir = new char[]{'%', 'f', 'u', 'n', 'c', 't', 'i', 'o', 'n', '\u0000'};
    private char[] m_type_dir = new char[]{'%', 't', 'y', 'p', 'e', '\u0000'};
    private char[] m_integer_dir = new char[]{'%', 'i', 'n', 't', 'e', 'g', 'e', 'r', '\u0000'};
    private char[] m_intwrap_dir = new char[]{'%', 'i', 'n', 't', 'w', 'r', 'a', 'p', '\u0000'};
    private char[] m_full_dir = new char[]{'%', 'f', 'u', 'l', 'l', '\u0000'};
    private char[] m_unicode_dir = new char[]{'%', 'u', 'n', 'i', 'c', 'o', 'd', 'e', '\u0000'};
    private char[] m_ignorecase_dir = new char[]{'%', 'i', 'g', 'n', 'o', 'r', 'e', 'c', 'a', 's', 'e', '\u0000'};
    private char[] m_notunix_dir = new char[]{'%', 'n', 'o', 't', 'u', 'n', 'i', 'x', '\u0000'};
    private char[] m_init_code_dir = new char[]{'%', 'i', 'n', 'i', 't', '{', '\u0000'};
    private char[] m_init_code_end_dir = new char[]{'%', 'i', 'n', 'i', 't', '}', '\u0000'};
    private char[] m_init_throw_code_dir = new char[]{'%', 'i', 'n', 'i', 't', 't', 'h', 'r', 'o', 'w', '{', '\u0000'};
    private char[] m_init_throw_code_end_dir = new char[]{'%', 'i', 'n', 'i', 't', 't', 'h', 'r', 'o', 'w', '}', '\u0000'};
    private char[] m_yylex_throw_code_dir = new char[]{'%', 'y', 'y', 'l', 'e', 'x', 't', 'h', 'r', 'o', 'w', '{', '\u0000'};
    private char[] m_yylex_throw_code_end_dir = new char[]{'%', 'y', 'y', 'l', 'e', 'x', 't', 'h', 'r', 'o', 'w', '}', '\u0000'};
    private char[] m_eof_code_dir = new char[]{'%', 'e', 'o', 'f', '{', '\u0000'};
    private char[] m_eof_code_end_dir = new char[]{'%', 'e', 'o', 'f', '}', '\u0000'};
    private char[] m_eof_value_code_dir = new char[]{'%', 'e', 'o', 'f', 'v', 'a', 'l', '{', '\u0000'};
    private char[] m_eof_value_code_end_dir = new char[]{'%', 'e', 'o', 'f', 'v', 'a', 'l', '}', '\u0000'};
    private char[] m_eof_throw_code_dir = new char[]{'%', 'e', 'o', 'f', 't', 'h', 'r', 'o', 'w', '{', '\u0000'};
    private char[] m_eof_throw_code_end_dir = new char[]{'%', 'e', 'o', 'f', 't', 'h', 'r', 'o', 'w', '}', '\u0000'};
    private char[] m_class_code_dir = new char[]{'%', '{', '\u0000'};
    private char[] m_class_code_end_dir = new char[]{'%', '}', '\u0000'};
    private char[] m_yyeof_dir = new char[]{'%', 'y', 'y', 'e', 'o', 'f', '\u0000'};
    private char[] m_public_dir = new char[]{'%', 'p', 'u', 'b', 'l', 'i', 'c', '\u0000'};
    private SparseBitSet all_states = null;
    private boolean m_advance_stop = false;

    CLexGen(String filename, String outputFilename) throws FileNotFoundException, IOException {
        this(filename, outputFilename, new SystemOutLexOutput());
    }

    CLexGen(String filename, String outputFilename, LexOutput out) throws FileNotFoundException, IOException {
        this.out = out;
        this.m_init_flag = false;
        this.m_instream = new FileReader(filename);
        if (null == this.m_instream) {
            out.println("Error: Unable to open input file " + filename + ".");
            return;
        }
        this.m_outstream = new PrintWriter(new BufferedWriter(new FileWriter(outputFilename)));
        if (null == this.m_outstream) {
            out.println("Error: Unable to open output file " + filename + ".java.");
            return;
        }
        this.m_input = new CInput(this.m_instream);
        this.m_tokens = new Hashtable();
        this.m_tokens.put(new Character('$'), new Integer(4));
        this.m_tokens.put(new Character('('), new Integer(14));
        this.m_tokens.put(new Character(')'), new Integer(8));
        this.m_tokens.put(new Character('*'), new Integer(9));
        this.m_tokens.put(new Character('+'), new Integer(17));
        this.m_tokens.put(new Character('-'), new Integer(10));
        this.m_tokens.put(new Character('.'), new Integer(2));
        this.m_tokens.put(new Character('?'), new Integer(15));
        this.m_tokens.put(new Character('['), new Integer(6));
        this.m_tokens.put(new Character(']'), new Integer(5));
        this.m_tokens.put(new Character('^'), new Integer(3));
        this.m_tokens.put(new Character('{'), new Integer(13));
        this.m_tokens.put(new Character('|'), new Integer(16));
        this.m_tokens.put(new Character('}'), new Integer(7));
        this.m_spec = new CSpec();
        this.m_nfa2dfa = new CNfa2Dfa(out);
        this.m_minimize = new CMinimize(out);
        this.m_makeNfa = new CMakeNfa(out);
        this.m_simplifyNfa = new CSimplifyNfa(out);
        this.m_emit = new CEmit(out);
        this.m_init_flag = true;
    }

    void generate() throws IOException, FileNotFoundException {
        if (!this.m_init_flag) {
            CError.parse_error(10, 0, this.out);
        }
        CUtility.ASSERT(null != this);
        CUtility.ASSERT(null != this.m_outstream);
        CUtility.ASSERT(null != this.m_input);
        CUtility.ASSERT(null != this.m_tokens);
        CUtility.ASSERT(null != this.m_spec);
        CUtility.ASSERT(this.m_init_flag);
        if (this.m_spec.m_verbose) {
            this.out.println("Processing first section -- user code.");
        }
        this.userCode();
        if (this.m_input.m_eof_reached) {
            CError.parse_error(11, this.m_input.m_line_number, this.out);
        }
        if (this.m_spec.m_verbose) {
            this.out.println("Processing second section -- JLex declarations.");
        }
        this.userDeclare();
        if (this.m_input.m_eof_reached) {
            CError.parse_error(11, this.m_input.m_line_number, this.out);
        }
        if (this.m_spec.m_verbose) {
            this.out.println("Processing third section -- lexical rules.");
        }
        this.userRules();
        if (this.m_spec.m_verbose) {
            this.out.println("Outputting lexical analyzer code.");
        }
        this.m_emit.emit(this.m_spec, this.m_outstream);
        if (this.m_spec.m_verbose) {
            // empty if block
        }
        this.m_outstream.close();
    }

    private void userCode() throws IOException {
        if (!this.m_init_flag) {
            CError.parse_error(10, 0, this.out);
        }
        CUtility.ASSERT(null != this);
        CUtility.ASSERT(null != this.m_outstream);
        CUtility.ASSERT(null != this.m_input);
        CUtility.ASSERT(null != this.m_tokens);
        CUtility.ASSERT(null != this.m_spec);
        if (this.m_input.m_eof_reached) {
            CError.parse_error(11, 0, this.out);
        }
        while (true) {
            if (this.m_input.getLine()) {
                CError.parse_error(11, 0, this.out);
            }
            if (2 <= this.m_input.m_line_read && '%' == this.m_input.m_line[0] && '%' == this.m_input.m_line[1]) {
                this.m_input.m_line_index = this.m_input.m_line_read;
                return;
            }
            this.m_outstream.print(new String(this.m_input.m_line, 0, this.m_input.m_line_read));
        }
    }

    private char[] getName() {
        int elem;
        while (this.m_input.m_line_index < this.m_input.m_line_read && CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
            ++this.m_input.m_line_index;
        }
        if (this.m_input.m_line_index >= this.m_input.m_line_read) {
            CError.parse_error(12, 0, this.out);
        }
        for (elem = this.m_input.m_line_index; elem < this.m_input.m_line_read && !CUtility.isnewline(this.m_input.m_line[elem]); ++elem) {
        }
        char[] buffer = new char[elem - this.m_input.m_line_index];
        elem = 0;
        while (this.m_input.m_line_index < this.m_input.m_line_read && !CUtility.isnewline(this.m_input.m_line[this.m_input.m_line_index])) {
            buffer[elem] = this.m_input.m_line[this.m_input.m_line_index];
            ++elem;
            ++this.m_input.m_line_index;
        }
        return buffer;
    }

    /*
     * Unable to fully structure code
     */
    private char[] packCode(char[] start_dir, char[] end_dir, char[] prev_code, int prev_read, int specified) throws IOException {
        CUtility.ASSERT(1 == specified || 0 == specified || 2 == specified || 6 == specified || 3 == specified || 4 == specified || 5 == specified);
        if (0 != CUtility.charncmp(this.m_input.m_line, 0, start_dir, 0, start_dir.length - 1)) {
            CError.parse_error(13, 0, this.out);
        }
        if (null == prev_code) {
            prev_code = new char[1024];
            prev_read = 0;
        }
        if (prev_read >= prev_code.length) {
            prev_code = CUtility.doubleSize(prev_code);
        }
        this.m_input.m_line_index = start_dir.length - 1;
        block9: while (true) {
            if (this.m_input.m_line_index >= this.m_input.m_line_read) {
                if (this.m_input.getLine()) {
                    CError.parse_error(11, this.m_input.m_line_number, this.out);
                }
                if (0 != CUtility.charncmp(this.m_input.m_line, 0, end_dir, 0, end_dir.length - 1)) continue;
                this.m_input.m_line_index = end_dir.length - 1;
                switch (specified) {
                    case 0: {
                        this.m_spec.m_class_read = prev_read;
                        break;
                    }
                    case 1: {
                        this.m_spec.m_init_read = prev_read;
                        break;
                    }
                    case 2: {
                        this.m_spec.m_eof_read = prev_read;
                        break;
                    }
                    case 6: {
                        this.m_spec.m_eof_value_read = prev_read;
                        break;
                    }
                    case 3: {
                        this.m_spec.m_init_throw_read = prev_read;
                        break;
                    }
                    case 4: {
                        this.m_spec.m_yylex_throw_read = prev_read;
                        break;
                    }
                    case 5: {
                        this.m_spec.m_eof_throw_read = prev_read;
                        break;
                    }
                    default: {
                        CError.parse_error(13, this.m_input.m_line_number, this.out);
                    }
                }
                return prev_code;
            }
            while (true) {
                if (this.m_input.m_line_index < this.m_input.m_line_read) ** break;
                continue block9;
                prev_code[prev_read] = this.m_input.m_line[this.m_input.m_line_index];
                ++this.m_input.m_line_index;
                if (++prev_read < prev_code.length) continue;
                prev_code = CUtility.doubleSize(prev_code);
            }
            break;
        }
    }

    private void userDeclare() throws IOException {
        CUtility.ASSERT(null != this);
        CUtility.ASSERT(null != this.m_outstream);
        CUtility.ASSERT(null != this.m_input);
        CUtility.ASSERT(null != this.m_tokens);
        CUtility.ASSERT(null != this.m_spec);
        if (this.m_input.m_eof_reached) {
            CError.parse_error(11, this.m_input.m_line_number, this.out);
        }
        block14: while (!this.m_input.getLine()) {
            if (2 <= this.m_input.m_line_read && '%' == this.m_input.m_line[0] && '%' == this.m_input.m_line[1]) {
                this.m_input.m_line_read -= 2;
                System.arraycopy(this.m_input.m_line, 2, this.m_input.m_line, 0, this.m_input.m_line_read);
                this.m_input.m_pushback_line = true;
                if (0 == this.m_input.m_line_read || '\n' == this.m_input.m_line[0]) {
                    this.m_input.m_pushback_line = false;
                }
                return;
            }
            if (0 == this.m_input.m_line_read) continue;
            if ('%' == this.m_input.m_line[0]) {
                if (1 >= this.m_input.m_line_read) {
                    CError.parse_error(12, this.m_input.m_line_number, this.out);
                    continue;
                }
                switch (this.m_input.m_line[1]) {
                    case '{': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_class_code_dir, 0, this.m_class_code_dir.length - 1)) {
                            this.m_spec.m_class_code = this.packCode(this.m_class_code_dir, this.m_class_code_end_dir, this.m_spec.m_class_code, this.m_spec.m_class_read, 0);
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number, this.out);
                        continue block14;
                    }
                    case 'c': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_char_dir, 0, this.m_char_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_char_dir.length;
                            this.m_spec.m_count_chars = true;
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_class_dir, 0, this.m_class_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_class_dir.length;
                            this.m_spec.m_class_name = this.getName();
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_cup_dir, 0, this.m_cup_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_cup_dir.length;
                            this.m_spec.m_cup_compatible = true;
                            this.m_spec.m_implements_name = "java_cup.runtime.Scanner".toCharArray();
                            this.m_spec.m_function_name = "next_token".toCharArray();
                            this.m_spec.m_type_name = "java_cup.runtime.Symbol".toCharArray();
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number, this.out);
                        continue block14;
                    }
                    case 'e': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_eof_code_dir, 0, this.m_eof_code_dir.length - 1)) {
                            this.m_spec.m_eof_code = this.packCode(this.m_eof_code_dir, this.m_eof_code_end_dir, this.m_spec.m_eof_code, this.m_spec.m_eof_read, 2);
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_eof_value_code_dir, 0, this.m_eof_value_code_dir.length - 1)) {
                            this.m_spec.m_eof_value_code = this.packCode(this.m_eof_value_code_dir, this.m_eof_value_code_end_dir, this.m_spec.m_eof_value_code, this.m_spec.m_eof_value_read, 6);
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_eof_throw_code_dir, 0, this.m_eof_throw_code_dir.length - 1)) {
                            this.m_spec.m_eof_throw_code = this.packCode(this.m_eof_throw_code_dir, this.m_eof_throw_code_end_dir, this.m_spec.m_eof_throw_code, this.m_spec.m_eof_throw_read, 5);
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number, this.out);
                        continue block14;
                    }
                    case 'f': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_function_dir, 0, this.m_function_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_function_dir.length;
                            this.m_spec.m_function_name = this.getName();
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_full_dir, 0, this.m_full_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_full_dir.length;
                            this.m_spec.m_dtrans_ncols = 256;
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number, this.out);
                        continue block14;
                    }
                    case 'i': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_integer_dir, 0, this.m_integer_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_integer_dir.length;
                            this.m_spec.m_integer_type = true;
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_intwrap_dir, 0, this.m_intwrap_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_integer_dir.length;
                            this.m_spec.m_intwrap_type = true;
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_init_code_dir, 0, this.m_init_code_dir.length - 1)) {
                            this.m_spec.m_init_code = this.packCode(this.m_init_code_dir, this.m_init_code_end_dir, this.m_spec.m_init_code, this.m_spec.m_init_read, 1);
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_init_throw_code_dir, 0, this.m_init_throw_code_dir.length - 1)) {
                            this.m_spec.m_init_throw_code = this.packCode(this.m_init_throw_code_dir, this.m_init_throw_code_end_dir, this.m_spec.m_init_throw_code, this.m_spec.m_init_throw_read, 3);
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_implements_dir, 0, this.m_implements_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_implements_dir.length;
                            this.m_spec.m_implements_name = this.getName();
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_ignorecase_dir, 0, this.m_ignorecase_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_ignorecase_dir.length;
                            this.m_spec.m_ignorecase = true;
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number, this.out);
                        continue block14;
                    }
                    case 'l': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_line_dir, 0, this.m_line_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_line_dir.length;
                            this.m_spec.m_count_lines = true;
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number, this.out);
                        continue block14;
                    }
                    case 'n': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_notunix_dir, 0, this.m_notunix_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_notunix_dir.length;
                            this.m_spec.m_unix = false;
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number, this.out);
                        continue block14;
                    }
                    case 'p': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_public_dir, 0, this.m_public_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_public_dir.length;
                            this.m_spec.m_public = true;
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number, this.out);
                        continue block14;
                    }
                    case 's': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_state_dir, 0, this.m_state_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_state_dir.length;
                            this.saveStates();
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number, this.out);
                        continue block14;
                    }
                    case 't': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_type_dir, 0, this.m_type_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_type_dir.length;
                            this.m_spec.m_type_name = this.getName();
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number, this.out);
                        continue block14;
                    }
                    case 'u': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_unicode_dir, 0, this.m_unicode_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_unicode_dir.length;
                            this.m_spec.m_dtrans_ncols = 65536;
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number, this.out);
                        continue block14;
                    }
                    case 'y': {
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_yyeof_dir, 0, this.m_yyeof_dir.length - 1)) {
                            this.m_input.m_line_index = this.m_yyeof_dir.length;
                            this.m_spec.m_yyeof = true;
                            continue block14;
                        }
                        if (0 == CUtility.charncmp(this.m_input.m_line, 0, this.m_yylex_throw_code_dir, 0, this.m_yylex_throw_code_dir.length - 1)) {
                            this.m_spec.m_yylex_throw_code = this.packCode(this.m_yylex_throw_code_dir, this.m_yylex_throw_code_end_dir, this.m_spec.m_yylex_throw_code, this.m_spec.m_yylex_throw_read, 4);
                            continue block14;
                        }
                        CError.parse_error(12, this.m_input.m_line_number, this.out);
                        continue block14;
                    }
                }
                CError.parse_error(12, this.m_input.m_line_number, this.out);
                continue;
            }
            this.m_input.m_line_index = 0;
            this.saveMacro();
        }
    }

    private void userRules() throws IOException {
        if (!this.m_init_flag) {
            CError.parse_error(10, 0, this.out);
        }
        CUtility.ASSERT(null != this);
        CUtility.ASSERT(null != this.m_outstream);
        CUtility.ASSERT(null != this.m_input);
        CUtility.ASSERT(null != this.m_tokens);
        CUtility.ASSERT(null != this.m_spec);
        if (this.m_spec.m_verbose) {
            this.out.println("Creating NFA machine representation.");
        }
        this.m_makeNfa.allocate_BOL_EOF(this.m_spec);
        this.m_makeNfa.thompson(this, this.m_spec, this.m_input);
        this.m_simplifyNfa.simplify(this.m_spec);
        CUtility.ASSERT(11 == this.m_spec.m_current_token);
        if (this.m_spec.m_verbose) {
            this.out.println("Creating DFA transition table.");
        }
        this.m_nfa2dfa.make_dfa(this, this.m_spec);
        if (this.m_spec.m_verbose) {
            this.out.println("Minimizing DFA transition table.");
        }
        this.m_minimize.min_dfa(this.m_spec);
    }

    private void printccl(CSet set) {
        this.out.print(" [");
        for (int i = 0; i < this.m_spec.m_dtrans_ncols; ++i) {
            if (!set.contains(i)) continue;
            this.out.print(this.interp_int(i));
        }
        this.out.print("]");
    }

    private String plab(CNfa state) {
        if (null == state) {
            return new String("--");
        }
        int index = this.m_spec.m_nfa_states.indexOf(state);
        return new Integer(index).toString();
    }

    private String interp_int(int i) {
        switch (i) {
            case 8: {
                return new String("\\b");
            }
            case 9: {
                return new String("\\t");
            }
            case 10: {
                return new String("\\n");
            }
            case 12: {
                return new String("\\f");
            }
            case 13: {
                return new String("\\r");
            }
            case 32: {
                return new String("\\ ");
            }
        }
        return new Character((char)i).toString();
    }

    void print_nfa() {
        CNfa nfa;
        this.out.println("--------------------- NFA -----------------------");
        int size = this.m_spec.m_nfa_states.size();
        for (int elem = 0; elem < size; ++elem) {
            nfa = (CNfa)this.m_spec.m_nfa_states.elementAt(elem);
            this.out.print("Nfa state " + this.plab(nfa) + ": ");
            if (null == nfa.m_next) {
                this.out.print("(TERMINAL)");
            } else {
                this.out.print("--> " + this.plab(nfa.m_next));
                this.out.print("--> " + this.plab(nfa.m_next2));
                switch (nfa.m_edge) {
                    case -1: {
                        this.printccl(nfa.m_set);
                        break;
                    }
                    case -3: {
                        this.out.print(" EPSILON ");
                        break;
                    }
                    default: {
                        this.out.print(" " + this.interp_int(nfa.m_edge));
                    }
                }
            }
            if (0 == elem) {
                this.out.print(" (START STATE)");
            }
            if (null != nfa.m_accept) {
                this.out.print(" accepting " + (0 != (nfa.m_anchor & 1) ? "^" : "") + "<" + new String(nfa.m_accept.m_action, 0, nfa.m_accept.m_action_read) + ">" + (0 != (nfa.m_anchor & 2) ? "$" : ""));
            }
            this.out.println("");
        }
        Enumeration states = this.m_spec.m_states.keys();
        while (states.hasMoreElements()) {
            String state = (String)states.nextElement();
            Integer index = (Integer)this.m_spec.m_states.get(state);
            CUtility.ASSERT(null != state);
            CUtility.ASSERT(null != index);
            this.out.println("State \"" + state + "\" has identifying index " + index.toString() + ".");
            this.out.print("\tStart states of matching rules: ");
            int i = index;
            int vsize = this.m_spec.m_state_rules[i].size();
            for (int j = 0; j < vsize; ++j) {
                nfa = (CNfa)this.m_spec.m_state_rules[i].elementAt(j);
                this.out.print(this.m_spec.m_nfa_states.indexOf(nfa) + " ");
            }
            this.out.println("");
        }
        this.out.println("-------------------- NFA ----------------------");
    }

    SparseBitSet getStates() throws IOException {
        CUtility.ASSERT(null != this);
        CUtility.ASSERT(null != this.m_outstream);
        CUtility.ASSERT(null != this.m_input);
        CUtility.ASSERT(null != this.m_tokens);
        CUtility.ASSERT(null != this.m_spec);
        SparseBitSet states = null;
        while (CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
            ++this.m_input.m_line_index;
            while (this.m_input.m_line_index >= this.m_input.m_line_read) {
                if (!this.m_input.getLine()) continue;
                return null;
            }
        }
        if ('<' == this.m_input.m_line[this.m_input.m_line_index]) {
            ++this.m_input.m_line_index;
            states = new SparseBitSet();
            while (true) {
                int count_state;
                String name;
                Integer index;
                if (this.m_input.m_line_index >= this.m_input.m_line_read) {
                    if (!this.m_input.getLine()) continue;
                    CError.parse_error(11, this.m_input.m_line_number, this.out);
                    return states;
                }
                block3: while (true) {
                    if (CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                        ++this.m_input.m_line_index;
                        do {
                            if (this.m_input.m_line_index < this.m_input.m_line_read) continue block3;
                        } while (!this.m_input.getLine());
                        CError.parse_error(11, this.m_input.m_line_number, this.out);
                        return states;
                    }
                    if (',' != this.m_input.m_line[this.m_input.m_line_index]) break;
                    ++this.m_input.m_line_index;
                }
                if ('>' == this.m_input.m_line[this.m_input.m_line_index]) {
                    ++this.m_input.m_line_index;
                    if (this.m_input.m_line_index < this.m_input.m_line_read) {
                        this.m_advance_stop = true;
                    }
                    return states;
                }
                int start_state = this.m_input.m_line_index;
                while (!CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index]) && ',' != this.m_input.m_line[this.m_input.m_line_index] && '>' != this.m_input.m_line[this.m_input.m_line_index]) {
                    ++this.m_input.m_line_index;
                    if (this.m_input.m_line_index < this.m_input.m_line_read) continue;
                }
                if (null == (index = (Integer)this.m_spec.m_states.get(name = new String(this.m_input.m_line, start_state, count_state = this.m_input.m_line_index - start_state)))) {
                    this.out.println("Uninitialized State Name: " + name);
                    CError.parse_error(14, this.m_input.m_line_number, this.out);
                }
                states.set(index);
            }
        }
        if (null == this.all_states) {
            this.all_states = new SparseBitSet();
            int size = this.m_spec.m_states.size();
            for (int i = 0; i < size; ++i) {
                this.all_states.set(i);
            }
        }
        if (this.m_input.m_line_index < this.m_input.m_line_read) {
            this.m_advance_stop = true;
        }
        return this.all_states;
    }

    private boolean expandMacro() {
        int rep_elem;
        CUtility.ASSERT(null != this);
        CUtility.ASSERT(null != this.m_outstream);
        CUtility.ASSERT(null != this.m_input);
        CUtility.ASSERT(null != this.m_tokens);
        CUtility.ASSERT(null != this.m_spec);
        if ('{' != this.m_input.m_line[this.m_input.m_line_index]) {
            CError.parse_error(13, this.m_input.m_line_number, this.out);
            return false;
        }
        int start_macro = this.m_input.m_line_index;
        int elem = this.m_input.m_line_index + 1;
        if (elem >= this.m_input.m_line_read) {
            CError.impos("Unfinished macro name", this.out);
            return false;
        }
        int start_name = elem;
        while ('}' != this.m_input.m_line[elem]) {
            if (++elem < this.m_input.m_line_read) continue;
            CError.impos("Unfinished macro name at line " + this.m_input.m_line_number, this.out);
            return false;
        }
        int count_name = elem - start_name;
        int end_macro = elem;
        if (0 == count_name) {
            CError.impos("Nonexistent macro name", this.out);
            return false;
        }
        CUtility.ASSERT(0 < count_name);
        String name = new String(this.m_input.m_line, start_name, count_name);
        String def = (String)this.m_spec.m_macros.get(name);
        if (null == def) {
            this.out.println("Error: Undefined macro \"" + name + "\".");
            CError.parse_error(8, this.m_input.m_line_number, this.out);
            return false;
        }
        char[] replace = new char[this.m_input.m_line.length];
        for (rep_elem = 0; rep_elem < start_macro; ++rep_elem) {
            replace[rep_elem] = this.m_input.m_line[rep_elem];
            CUtility.ASSERT(rep_elem < replace.length);
        }
        if (rep_elem >= replace.length) {
            replace = CUtility.doubleSize(replace);
        }
        for (int def_elem = 0; def_elem < def.length(); ++def_elem) {
            replace[rep_elem] = def.charAt(def_elem);
            if (++rep_elem < replace.length) continue;
            replace = CUtility.doubleSize(replace);
        }
        if (rep_elem >= replace.length) {
            replace = CUtility.doubleSize(replace);
        }
        for (elem = end_macro + 1; elem < this.m_input.m_line_read; ++elem) {
            replace[rep_elem] = this.m_input.m_line[elem];
            if (++rep_elem < replace.length) continue;
            replace = CUtility.doubleSize(replace);
        }
        this.m_input.m_line = replace;
        this.m_input.m_line_read = rep_elem;
        return true;
    }

    private void saveMacro() {
        int count_def;
        CUtility.ASSERT(null != this);
        CUtility.ASSERT(null != this.m_outstream);
        CUtility.ASSERT(null != this.m_input);
        CUtility.ASSERT(null != this.m_tokens);
        CUtility.ASSERT(null != this.m_spec);
        int elem = 0;
        while (CUtility.isspace(this.m_input.m_line[elem])) {
            if (++elem < this.m_input.m_line_read) continue;
            return;
        }
        int start_name = elem;
        while (!CUtility.isspace(this.m_input.m_line[elem]) && '=' != this.m_input.m_line[elem]) {
            if (++elem < this.m_input.m_line_read) continue;
            CError.parse_error(15, this.m_input.m_line_number, this.out);
        }
        int count_name = elem - start_name;
        if (0 == count_name) {
            CError.parse_error(15, this.m_input.m_line_number, this.out);
        }
        while (CUtility.isspace(this.m_input.m_line[elem])) {
            if (++elem < this.m_input.m_line_read) continue;
            CError.parse_error(15, this.m_input.m_line_number, this.out);
        }
        if ('=' == this.m_input.m_line[elem]) {
            if (++elem >= this.m_input.m_line_read) {
                CError.parse_error(15, this.m_input.m_line_number, this.out);
            }
        } else {
            CError.parse_error(15, this.m_input.m_line_number, this.out);
        }
        while (CUtility.isspace(this.m_input.m_line[elem])) {
            if (++elem < this.m_input.m_line_read) continue;
            CError.parse_error(15, this.m_input.m_line_number, this.out);
        }
        int start_def = elem;
        boolean in_quote = false;
        boolean in_ccl = false;
        boolean saw_escape = false;
        while (!CUtility.isspace(this.m_input.m_line[elem]) || in_quote || in_ccl || saw_escape) {
            if ('\"' == this.m_input.m_line[elem] && !saw_escape) {
                in_quote = !in_quote;
            }
            if (!(saw_escape = '\\' == this.m_input.m_line[elem] && false == saw_escape) && !in_quote) {
                if ('[' == this.m_input.m_line[elem] && !in_ccl) {
                    in_ccl = true;
                }
                if (']' == this.m_input.m_line[elem] && in_ccl) {
                    in_ccl = false;
                }
            }
            if (++elem < this.m_input.m_line_read) continue;
        }
        if (0 == (count_def = elem - start_def)) {
            CError.parse_error(15, this.m_input.m_line_number, this.out);
        }
        CUtility.ASSERT(0 < count_def);
        CUtility.ASSERT(0 < count_name);
        CUtility.ASSERT(null != this.m_spec.m_macros);
        this.m_spec.m_macros.put(new String(this.m_input.m_line, start_name, count_name), new String(this.m_input.m_line, start_def, count_def));
    }

    private void saveStates() {
        CUtility.ASSERT(null != this);
        CUtility.ASSERT(null != this.m_outstream);
        CUtility.ASSERT(null != this.m_input);
        CUtility.ASSERT(null != this.m_tokens);
        CUtility.ASSERT(null != this.m_spec);
        if (this.m_input.m_eof_reached) {
            return;
        }
        CUtility.ASSERT('%' == this.m_input.m_line[0]);
        CUtility.ASSERT('s' == this.m_input.m_line[1]);
        CUtility.ASSERT(this.m_input.m_line_index <= this.m_input.m_line_read);
        CUtility.ASSERT(0 <= this.m_input.m_line_index);
        CUtility.ASSERT(0 <= this.m_input.m_line_read);
        if (this.m_input.m_line_index >= this.m_input.m_line_read) {
            return;
        }
        while (this.m_input.m_line_index < this.m_input.m_line_read) {
            while (CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                ++this.m_input.m_line_index;
                if (this.m_input.m_line_index < this.m_input.m_line_read) continue;
                return;
            }
            int start_state = this.m_input.m_line_index;
            while (!CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index]) && ',' != this.m_input.m_line[this.m_input.m_line_index]) {
                ++this.m_input.m_line_index;
                if (this.m_input.m_line_index < this.m_input.m_line_read) continue;
            }
            int count_state = this.m_input.m_line_index - start_state;
            this.m_spec.m_states.put(new String(this.m_input.m_line, start_state, count_state), new Integer(this.m_spec.m_states.size()));
            if (',' != this.m_input.m_line[this.m_input.m_line_index]) continue;
            ++this.m_input.m_line_index;
            if (this.m_input.m_line_index < this.m_input.m_line_read) continue;
            return;
        }
    }

    private char expandEscape() {
        char r;
        CUtility.ASSERT(this.m_input.m_line_index < this.m_input.m_line_read);
        CUtility.ASSERT(0 < this.m_input.m_line_read);
        CUtility.ASSERT(0 <= this.m_input.m_line_index);
        if ('\\' != this.m_input.m_line[this.m_input.m_line_index]) {
            ++this.m_input.m_line_index;
            return this.m_input.m_line[this.m_input.m_line_index - 1];
        }
        boolean unicode_escape = false;
        ++this.m_input.m_line_index;
        switch (this.m_input.m_line[this.m_input.m_line_index]) {
            case 'b': {
                ++this.m_input.m_line_index;
                return '\b';
            }
            case 't': {
                ++this.m_input.m_line_index;
                return '\t';
            }
            case 'n': {
                ++this.m_input.m_line_index;
                return '\n';
            }
            case 'f': {
                ++this.m_input.m_line_index;
                return '\f';
            }
            case 'r': {
                ++this.m_input.m_line_index;
                return '\r';
            }
            case '^': {
                ++this.m_input.m_line_index;
                char r2 = Character.toUpperCase(this.m_input.m_line[this.m_input.m_line_index]);
                if (r2 < '@' || r2 > 'Z') {
                    CError.parse_error(20, this.m_input.m_line_number, this.out);
                }
                r2 = (char)(r2 - 64);
                ++this.m_input.m_line_index;
                return r2;
            }
            case 'u': {
                unicode_escape = true;
            }
            case 'x': {
                ++this.m_input.m_line_index;
                char r3 = '\u0000';
                for (int i = 0; i < (unicode_escape ? 4 : 2) && CUtility.ishexdigit(this.m_input.m_line[this.m_input.m_line_index]); ++i) {
                    r3 = (char)(r3 << 4);
                    r3 = (char)(r3 | CUtility.hex2bin(this.m_input.m_line[this.m_input.m_line_index], this.out));
                    ++this.m_input.m_line_index;
                }
                return r3;
            }
        }
        if (!CUtility.isoctdigit(this.m_input.m_line[this.m_input.m_line_index])) {
            r = this.m_input.m_line[this.m_input.m_line_index];
            ++this.m_input.m_line_index;
        } else {
            r = '\u0000';
            for (int i = 0; i < 3 && CUtility.isoctdigit(this.m_input.m_line[this.m_input.m_line_index]); ++i) {
                r = (char)(r << 3);
                r = (char)(r | CUtility.oct2bin(this.m_input.m_line[this.m_input.m_line_index], this.out));
                ++this.m_input.m_line_index;
            }
        }
        return r;
    }

    CAccept packAccept() throws IOException {
        int action_index;
        char[] action;
        block23: {
            action = new char[1024];
            action_index = 0;
            CUtility.ASSERT(null != this);
            CUtility.ASSERT(null != this.m_outstream);
            CUtility.ASSERT(null != this.m_input);
            CUtility.ASSERT(null != this.m_tokens);
            CUtility.ASSERT(null != this.m_spec);
            while (this.m_input.m_line_index >= this.m_input.m_line_read) {
                if (!this.m_input.getLine()) continue;
                CError.parse_error(11, this.m_input.m_line_number, this.out);
                return null;
            }
            while (CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                ++this.m_input.m_line_index;
                while (this.m_input.m_line_index >= this.m_input.m_line_read) {
                    if (!this.m_input.getLine()) continue;
                    CError.parse_error(11, this.m_input.m_line_number, this.out);
                    return null;
                }
            }
            if ('{' != this.m_input.m_line[this.m_input.m_line_index]) {
                CError.parse_error(17, this.m_input.m_line_number, this.out);
            }
            int brackets = 0;
            boolean slashed = false;
            boolean escaped = false;
            boolean instarcomment = false;
            boolean inslashcomment = false;
            boolean indoublequotes = false;
            boolean insinglequotes = false;
            block3: while (true) {
                action[action_index] = this.m_input.m_line[this.m_input.m_line_index];
                if ((insinglequotes || indoublequotes) && escaped) {
                    escaped = false;
                } else if ((insinglequotes || indoublequotes) && '\\' == this.m_input.m_line[this.m_input.m_line_index]) {
                    escaped = true;
                } else if (!(insinglequotes || inslashcomment || instarcomment || '\"' != this.m_input.m_line[this.m_input.m_line_index])) {
                    indoublequotes = !indoublequotes;
                } else if (!(indoublequotes || inslashcomment || instarcomment || '\'' != this.m_input.m_line[this.m_input.m_line_index])) {
                    boolean bl = insinglequotes = !insinglequotes;
                }
                if (instarcomment) {
                    if (slashed && '/' == this.m_input.m_line[this.m_input.m_line_index]) {
                        slashed = false;
                        instarcomment = false;
                    } else {
                        slashed = '*' == this.m_input.m_line[this.m_input.m_line_index];
                    }
                } else if (!(inslashcomment || insinglequotes || indoublequotes)) {
                    inslashcomment = slashed && '/' == this.m_input.m_line[this.m_input.m_line_index];
                    instarcomment = slashed && '*' == this.m_input.m_line[this.m_input.m_line_index];
                    boolean bl = slashed = '/' == this.m_input.m_line[this.m_input.m_line_index];
                }
                if (!(insinglequotes || indoublequotes || instarcomment || inslashcomment)) {
                    if ('{' == this.m_input.m_line[this.m_input.m_line_index]) {
                        ++brackets;
                    } else if ('}' == this.m_input.m_line[this.m_input.m_line_index] && 0 == --brackets) {
                        ++this.m_input.m_line_index;
                        break block23;
                    }
                }
                if (++action_index >= action.length) {
                    action = CUtility.doubleSize(action);
                }
                ++this.m_input.m_line_index;
                do {
                    if (this.m_input.m_line_index < this.m_input.m_line_read) continue block3;
                    slashed = false;
                    inslashcomment = false;
                    if (!insinglequotes && !indoublequotes) continue;
                    CError.parse_error(6, this.m_input.m_line_number, this.out);
                    indoublequotes = false;
                    insinglequotes = false;
                } while (!this.m_input.getLine());
                break;
            }
            CError.parse_error(16, this.m_input.m_line_number, this.out);
            return null;
        }
        CAccept accept = new CAccept(action, ++action_index, this.m_input.m_line_number);
        CUtility.ASSERT(null != accept);
        return accept;
    }

    /*
     * Unable to fully structure code
     */
    int advance() throws IOException {
        block19: {
            saw_escape = false;
            if (this.m_input.m_eof_reached) {
                this.m_spec.m_current_token = 11;
                this.m_spec.m_lexeme = '\u0000';
                return this.m_spec.m_current_token;
            }
            if (1 == this.m_spec.m_current_token || this.m_input.m_line_index >= this.m_input.m_line_read) {
                if (this.m_spec.m_in_quote) {
                    CError.parse_error(16, this.m_input.m_line_number, this.out);
                }
                do {
                    if (!this.m_advance_stop || this.m_input.m_line_index >= this.m_input.m_line_read) {
                        if (this.m_input.getLine()) {
                            this.m_spec.m_current_token = 11;
                            this.m_spec.m_lexeme = '\u0000';
                            return this.m_spec.m_current_token;
                        }
                        this.m_input.m_line_index = 0;
                    } else {
                        this.m_advance_stop = false;
                    }
                    while (this.m_input.m_line_index < this.m_input.m_line_read && CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                        ++this.m_input.m_line_index;
                    }
                } while (this.m_input.m_line_index >= this.m_input.m_line_read);
            }
            CUtility.ASSERT(this.m_input.m_line_index <= this.m_input.m_line_read);
            do lbl-1000:
            // 3 sources

            {
                block20: {
                    if (this.m_spec.m_in_quote || '{' != this.m_input.m_line[this.m_input.m_line_index]) break block20;
                    if (!this.expandMacro()) break block19;
                    if (this.m_input.m_line_index < this.m_input.m_line_read) ** GOTO lbl-1000
                    this.m_spec.m_current_token = 1;
                    this.m_spec.m_lexeme = '\u0000';
                    return this.m_spec.m_current_token;
                }
                if ('\"' != this.m_input.m_line[this.m_input.m_line_index]) break block19;
                this.m_spec.m_in_quote = this.m_spec.m_in_quote == false;
                ++this.m_input.m_line_index;
            } while (this.m_input.m_line_index < this.m_input.m_line_read);
            this.m_spec.m_current_token = 1;
            this.m_spec.m_lexeme = '\u0000';
            return this.m_spec.m_current_token;
        }
        if (this.m_input.m_line_index > this.m_input.m_line_read) {
            this.out.println("m_input.m_line_index = " + this.m_input.m_line_index);
            this.out.println("m_input.m_line_read = " + this.m_input.m_line_read);
            CUtility.ASSERT(this.m_input.m_line_index <= this.m_input.m_line_read);
        }
        saw_escape = '\\' == this.m_input.m_line[this.m_input.m_line_index];
        if (!this.m_spec.m_in_quote) {
            if (!this.m_spec.m_in_ccl && CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                this.m_spec.m_current_token = 1;
                this.m_spec.m_lexeme = '\u0000';
                return this.m_spec.m_current_token;
            }
            if (saw_escape) {
                this.m_spec.m_lexeme = this.expandEscape();
            } else {
                this.m_spec.m_lexeme = this.m_input.m_line[this.m_input.m_line_index];
                ++this.m_input.m_line_index;
            }
        } else if (saw_escape && this.m_input.m_line_index + 1 < this.m_input.m_line_read && '\"' == this.m_input.m_line[this.m_input.m_line_index + 1]) {
            this.m_spec.m_lexeme = (char)34;
            this.m_input.m_line_index += 2;
        } else {
            this.m_spec.m_lexeme = this.m_input.m_line[this.m_input.m_line_index];
            ++this.m_input.m_line_index;
        }
        code = (Integer)this.m_tokens.get(new Character(this.m_spec.m_lexeme));
        this.m_spec.m_current_token = this.m_spec.m_in_quote != false || true == saw_escape ? 12 : (null == code ? 12 : code);
        if (6 == this.m_spec.m_current_token) {
            this.m_spec.m_in_ccl = true;
        }
        if (5 == this.m_spec.m_current_token) {
            this.m_spec.m_in_ccl = false;
        }
        return this.m_spec.m_current_token;
    }

    private void details() {
        this.out.println("");
        this.out.println("\t** Macros **");
        Enumeration names = this.m_spec.m_macros.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String def = (String)this.m_spec.m_macros.get(name);
            CUtility.ASSERT(null != name);
            CUtility.ASSERT(null != def);
            this.out.println("Macro name \"" + name + "\" has definition \"" + def + "\".");
        }
        this.out.println("");
        this.out.println("\t** States **");
        Enumeration states = this.m_spec.m_states.keys();
        while (states.hasMoreElements()) {
            String state = (String)states.nextElement();
            Integer index = (Integer)this.m_spec.m_states.get(state);
            CUtility.ASSERT(null != state);
            CUtility.ASSERT(null != index);
            this.out.println("State \"" + state + "\" has identifying index " + index.toString() + ".");
        }
        this.out.println("");
        this.out.println("\t** Character Counting **");
        if (!this.m_spec.m_count_chars) {
            this.out.println("Character counting is off.");
        } else {
            CUtility.ASSERT(this.m_spec.m_count_lines);
            this.out.println("Character counting is on.");
        }
        this.out.println("");
        this.out.println("\t** Line Counting **");
        if (!this.m_spec.m_count_lines) {
            this.out.println("Line counting is off.");
        } else {
            CUtility.ASSERT(this.m_spec.m_count_lines);
            this.out.println("Line counting is on.");
        }
        this.out.println("");
        this.out.println("\t** Operating System Specificity **");
        if (!this.m_spec.m_unix) {
            this.out.println("Not generating UNIX-specific code.");
            this.out.println("(This means that \"\\r\\n\" is a newline, rather than \"\\n\".)");
        } else {
            this.out.println("Generating UNIX-specific code.");
            this.out.println("(This means that \"\\n\" is a newline, rather than \"\\r\\n\".)");
        }
        this.out.println("");
        this.out.println("\t** Java CUP Compatibility **");
        if (!this.m_spec.m_cup_compatible) {
            this.out.println("Generating CUP compatible code.");
            this.out.println("(Scanner implements java_cup.runtime.Scanner.)");
        } else {
            this.out.println("Not generating CUP compatible code.");
        }
        if (null != this.m_spec.m_dtrans_vector) {
            this.out.println("");
            this.out.println("\t** DFA transition table **");
        }
    }

    void print_set(Vector nfa_set) {
        int size = nfa_set.size();
        if (0 == size) {
            this.out.print("empty ");
        }
        for (int elem = 0; elem < size; ++elem) {
            CNfa nfa = (CNfa)nfa_set.elementAt(elem);
            this.out.print(nfa.m_label + " ");
        }
    }

    private void print_header() {
        int i;
        int chars_printed = 0;
        System.out.println("/*---------------------- DFA -----------------------");
        Enumeration states = this.m_spec.m_states.keys();
        while (states.hasMoreElements()) {
            String state = (String)states.nextElement();
            Integer index = (Integer)this.m_spec.m_states.get(state);
            CUtility.ASSERT(null != state);
            CUtility.ASSERT(null != index);
            this.out.println("State \"" + state + "\" has identifying index " + index.toString() + ".");
            i = index;
            if (-1 != this.m_spec.m_state_dtrans[i]) {
                this.out.println("\tStart index in transition table: " + this.m_spec.m_state_dtrans[i]);
                continue;
            }
            this.out.println("\tNo associated transition states.");
        }
        for (i = 0; i < this.m_spec.m_dtrans_vector.size(); ++i) {
            CDTrans dtrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i);
            if (null == this.m_spec.m_accept_vector && null == this.m_spec.m_anchor_array) {
                if (null == dtrans.m_accept) {
                    this.out.print(" * State " + i + " [nonaccepting]");
                } else {
                    this.out.print(" * State " + i + " [accepting, line " + dtrans.m_accept.m_line_number + " <" + new String(dtrans.m_accept.m_action, 0, dtrans.m_accept.m_action_read) + ">]");
                    if (0 != dtrans.m_anchor) {
                        System.out.print(" Anchor: " + (0 != (dtrans.m_anchor & 1) ? "start " : "") + (0 != (dtrans.m_anchor & 2) ? "end " : ""));
                    }
                }
            } else {
                CAccept accept = (CAccept)this.m_spec.m_accept_vector.elementAt(i);
                if (null == accept) {
                    this.out.print(" * State " + i + " [nonaccepting]");
                } else {
                    this.out.print(" * State " + i + " [accepting, line " + accept.m_line_number + " <" + new String(accept.m_action, 0, accept.m_action_read) + ">]");
                    if (0 != this.m_spec.m_anchor_array[i]) {
                        System.out.print(" Anchor: " + (0 != (this.m_spec.m_anchor_array[i] & 1) ? "start " : "") + (0 != (this.m_spec.m_anchor_array[i] & 2) ? "end " : ""));
                    }
                }
            }
            int last_transition = -1;
            for (int j = 0; j < this.m_spec.m_dtrans_ncols; ++j) {
                if (-1 == dtrans.m_dtrans[j]) continue;
                if (last_transition != dtrans.m_dtrans[j]) {
                    this.out.println("");
                    this.out.print(" *    goto " + dtrans.m_dtrans[j] + " on ");
                    chars_printed = 0;
                }
                String str = this.interp_int(j);
                this.out.print(str);
                if (56 < (chars_printed += str.length())) {
                    this.out.println("");
                    this.out.print(" *             ");
                    chars_printed = 0;
                }
                last_transition = dtrans.m_dtrans[j];
            }
            this.out.println("");
        }
        this.out.println(" */");
        this.out.println("");
    }
}

