/*
 * Decompiled with CFR 0.152.
 */
package jlex;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import jlex.CAccept;
import jlex.CDTrans;
import jlex.CSpec;
import jlex.CUtility;
import jlex.LexOutput;

class CEmit {
    private CSpec m_spec;
    private LexOutput out;
    private PrintWriter m_outstream;
    private final boolean NOT_EDBG = false;

    CEmit(LexOutput out) {
        this.reset();
        this.out = out;
    }

    private void reset() {
        this.m_spec = null;
        this.m_outstream = null;
        this.out = null;
    }

    private void set(CSpec spec, PrintWriter outstream) {
        CUtility.ASSERT(null != spec);
        CUtility.ASSERT(null != outstream);
        this.m_spec = spec;
        this.m_outstream = outstream;
    }

    private void print_details() {
        this.out.println("---------------------- Transition Table ----------------------");
        for (int i = 0; i < this.m_spec.m_row_map.length; ++i) {
            this.out.print("State " + i);
            CAccept accept = (CAccept)this.m_spec.m_accept_vector.elementAt(i);
            if (null == accept) {
                this.out.println(" [nonaccepting]");
            } else {
                this.out.println(" [accepting, line " + accept.m_line_number + " <" + new String(accept.m_action, 0, accept.m_action_read) + ">]");
            }
            CDTrans dtrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(this.m_spec.m_row_map[i]);
            boolean tr = false;
            int state = dtrans.m_dtrans[this.m_spec.m_col_map[0]];
            if (-1 != state) {
                tr = true;
                this.out.print("\tgoto " + state + " on [" + '\u0000');
            }
            for (int j = 1; j < this.m_spec.m_dtrans_ncols; ++j) {
                int next = dtrans.m_dtrans[this.m_spec.m_col_map[j]];
                if (state == next) {
                    if (-1 == state) continue;
                    this.out.print((char)j + "");
                    continue;
                }
                state = next;
                if (tr) {
                    this.out.println("]");
                    tr = false;
                }
                if (-1 == state) continue;
                tr = true;
                this.out.print("\tgoto " + state + " on [" + (char)j);
            }
            if (!tr) continue;
            this.out.println("]");
        }
        this.out.println("---------------------- Transition Table ----------------------");
    }

    void emit(CSpec spec, PrintWriter outstream) throws IOException {
        this.set(spec, outstream);
        CUtility.ASSERT(null != this.m_spec);
        CUtility.ASSERT(null != this.m_outstream);
        this.emit_header();
        this.emit_construct();
        this.emit_helpers();
        this.emit_driver();
        this.emit_footer();
        this.reset();
    }

    private void emit_construct() throws IOException {
        CUtility.ASSERT(null != this.m_spec);
        CUtility.ASSERT(null != this.m_outstream);
        this.m_outstream.println("\tprivate final int YY_BUFFER_SIZE = 512;");
        this.m_outstream.println("\tprivate final int YY_F = -1;");
        this.m_outstream.println("\tprivate final int YY_NO_STATE = -1;");
        this.m_outstream.println("\tprivate final int YY_NOT_ACCEPT = 0;");
        this.m_outstream.println("\tprivate final int YY_START = 1;");
        this.m_outstream.println("\tprivate final int YY_END = 2;");
        this.m_outstream.println("\tprivate final int YY_NO_ANCHOR = 4;");
        this.m_outstream.println("\tprivate final int YY_BOL = " + this.m_spec.BOL + ";");
        this.m_outstream.println("\tprivate final int YY_EOF = " + this.m_spec.EOF + ";");
        if (this.m_spec.m_integer_type || this.m_spec.m_yyeof) {
            this.m_outstream.println("\tpublic final int YYEOF = -1;");
        }
        if (null != this.m_spec.m_class_code) {
            this.m_outstream.print(new String(this.m_spec.m_class_code, 0, this.m_spec.m_class_read));
        }
        this.m_outstream.println("\tprivate java.io.BufferedReader yy_reader;");
        this.m_outstream.println("\tprivate int yy_buffer_index;");
        this.m_outstream.println("\tprivate int yy_buffer_read;");
        this.m_outstream.println("\tprivate int yy_buffer_start;");
        this.m_outstream.println("\tprivate int yy_buffer_end;");
        this.m_outstream.println("\tprivate char yy_buffer[];");
        if (this.m_spec.m_count_chars) {
            this.m_outstream.println("\tprivate int yychar;");
        }
        if (this.m_spec.m_count_lines) {
            this.m_outstream.println("\tprivate int yyline;");
        }
        this.m_outstream.println("\tprivate boolean yy_at_bol;");
        this.m_outstream.println("\tprivate int yy_lexical_state;");
        this.m_outstream.println("");
        this.m_outstream.print("\t");
        if (this.m_spec.m_public) {
            this.m_outstream.print("public ");
        }
        this.m_outstream.print(new String(this.m_spec.m_class_name));
        this.m_outstream.print(" (java.io.Reader reader)");
        if (null != this.m_spec.m_init_throw_code) {
            this.m_outstream.println("");
            this.m_outstream.print("\t\tthrows ");
            this.m_outstream.print(new String(this.m_spec.m_init_throw_code, 0, this.m_spec.m_init_throw_read));
            this.m_outstream.println("");
            this.m_outstream.println("\t\t{");
        } else {
            this.m_outstream.println(" {");
        }
        this.m_outstream.println("\t\tthis ();");
        this.m_outstream.println("\t\tif (null == reader) {");
        this.m_outstream.println("\t\t\tthrow (new Error(\"Error: Bad input stream initializer.\"));");
        this.m_outstream.println("\t\t}");
        this.m_outstream.println("\t\tyy_reader = new java.io.BufferedReader(reader);");
        this.m_outstream.println("\t}");
        this.m_outstream.println("");
        this.m_outstream.print("\t");
        if (this.m_spec.m_public) {
            this.m_outstream.print("public ");
        }
        this.m_outstream.print(new String(this.m_spec.m_class_name));
        this.m_outstream.print(" (java.io.InputStream instream)");
        if (null != this.m_spec.m_init_throw_code) {
            this.m_outstream.println("");
            this.m_outstream.print("\t\tthrows ");
            this.m_outstream.println(new String(this.m_spec.m_init_throw_code, 0, this.m_spec.m_init_throw_read));
            this.m_outstream.println("\t\t{");
        } else {
            this.m_outstream.println(" {");
        }
        this.m_outstream.println("\t\tthis ();");
        this.m_outstream.println("\t\tif (null == instream) {");
        this.m_outstream.println("\t\t\tthrow (new Error(\"Error: Bad input stream initializer.\"));");
        this.m_outstream.println("\t\t}");
        this.m_outstream.println("\t\tyy_reader = new java.io.BufferedReader(new java.io.InputStreamReader(instream));");
        this.m_outstream.println("\t}");
        this.m_outstream.println("");
        this.m_outstream.print("\tprivate ");
        this.m_outstream.print(new String(this.m_spec.m_class_name));
        this.m_outstream.print(" ()");
        if (null != this.m_spec.m_init_throw_code) {
            this.m_outstream.println("");
            this.m_outstream.print("\t\tthrows ");
            this.m_outstream.println(new String(this.m_spec.m_init_throw_code, 0, this.m_spec.m_init_throw_read));
            this.m_outstream.println("\t\t{");
        } else {
            this.m_outstream.println(" {");
        }
        this.m_outstream.println("\t\tyy_buffer = new char[YY_BUFFER_SIZE];");
        this.m_outstream.println("\t\tyy_buffer_read = 0;");
        this.m_outstream.println("\t\tyy_buffer_index = 0;");
        this.m_outstream.println("\t\tyy_buffer_start = 0;");
        this.m_outstream.println("\t\tyy_buffer_end = 0;");
        if (this.m_spec.m_count_chars) {
            this.m_outstream.println("\t\tyychar = 0;");
        }
        if (this.m_spec.m_count_lines) {
            this.m_outstream.println("\t\tyyline = 0;");
        }
        this.m_outstream.println("\t\tyy_at_bol = true;");
        this.m_outstream.println("\t\tyy_lexical_state = YYINITIAL;");
        if (null != this.m_spec.m_init_code) {
            this.m_outstream.print(new String(this.m_spec.m_init_code, 0, this.m_spec.m_init_read));
        }
        this.m_outstream.println("\t}");
        this.m_outstream.println("");
    }

    private void emit_states() throws IOException {
        Enumeration states = this.m_spec.m_states.keys();
        while (states.hasMoreElements()) {
            String state = (String)states.nextElement();
            CUtility.ASSERT(null != state);
            this.m_outstream.println("\tprivate final int " + state + " = " + this.m_spec.m_states.get(state).toString() + ";");
        }
        this.m_outstream.println("\tprivate final int yy_state_dtrans[] = {");
        for (int index = 0; index < this.m_spec.m_state_dtrans.length; ++index) {
            this.m_outstream.print("\t\t" + this.m_spec.m_state_dtrans[index]);
            if (index < this.m_spec.m_state_dtrans.length - 1) {
                this.m_outstream.println(",");
                continue;
            }
            this.m_outstream.println("");
        }
        this.m_outstream.println("\t};");
    }

    private void emit_helpers() throws IOException {
        CUtility.ASSERT(null != this.m_spec);
        CUtility.ASSERT(null != this.m_outstream);
        this.m_outstream.println("\tprivate boolean yy_eof_done = false;");
        if (null != this.m_spec.m_eof_code) {
            this.m_outstream.print("\tprivate void yy_do_eof ()");
            if (null != this.m_spec.m_eof_throw_code) {
                this.m_outstream.println("");
                this.m_outstream.print("\t\tthrows ");
                this.m_outstream.println(new String(this.m_spec.m_eof_throw_code, 0, this.m_spec.m_eof_throw_read));
                this.m_outstream.println("\t\t{");
            } else {
                this.m_outstream.println(" {");
            }
            this.m_outstream.println("\t\tif (false == yy_eof_done) {");
            this.m_outstream.print(new String(this.m_spec.m_eof_code, 0, this.m_spec.m_eof_read));
            this.m_outstream.println("\t\t}");
            this.m_outstream.println("\t\tyy_eof_done = true;");
            this.m_outstream.println("\t}");
        }
        this.emit_states();
        this.m_outstream.println("\tprivate void yybegin (int state) {");
        this.m_outstream.println("\t\tyy_lexical_state = state;");
        this.m_outstream.println("\t}");
        this.m_outstream.println("\tprivate int yy_advance ()");
        this.m_outstream.println("\t\tthrows java.io.IOException {");
        this.m_outstream.println("\t\tint next_read;");
        this.m_outstream.println("\t\tint i;");
        this.m_outstream.println("\t\tint j;");
        this.m_outstream.println("");
        this.m_outstream.println("\t\tif (yy_buffer_index < yy_buffer_read) {");
        this.m_outstream.println("\t\t\treturn yy_buffer[yy_buffer_index++];");
        this.m_outstream.println("\t\t}");
        this.m_outstream.println("");
        this.m_outstream.println("\t\tif (0 != yy_buffer_start) {");
        this.m_outstream.println("\t\t\ti = yy_buffer_start;");
        this.m_outstream.println("\t\t\tj = 0;");
        this.m_outstream.println("\t\t\twhile (i < yy_buffer_read) {");
        this.m_outstream.println("\t\t\t\tyy_buffer[j] = yy_buffer[i];");
        this.m_outstream.println("\t\t\t\t++i;");
        this.m_outstream.println("\t\t\t\t++j;");
        this.m_outstream.println("\t\t\t}");
        this.m_outstream.println("\t\t\tyy_buffer_end = yy_buffer_end - yy_buffer_start;");
        this.m_outstream.println("\t\t\tyy_buffer_start = 0;");
        this.m_outstream.println("\t\t\tyy_buffer_read = j;");
        this.m_outstream.println("\t\t\tyy_buffer_index = j;");
        this.m_outstream.println("\t\t\tnext_read = yy_reader.read(yy_buffer,");
        this.m_outstream.println("\t\t\t\t\tyy_buffer_read,");
        this.m_outstream.println("\t\t\t\t\tyy_buffer.length - yy_buffer_read);");
        this.m_outstream.println("\t\t\tif (-1 == next_read) {");
        this.m_outstream.println("\t\t\t\treturn YY_EOF;");
        this.m_outstream.println("\t\t\t}");
        this.m_outstream.println("\t\t\tyy_buffer_read = yy_buffer_read + next_read;");
        this.m_outstream.println("\t\t}");
        this.m_outstream.println("");
        this.m_outstream.println("\t\twhile (yy_buffer_index >= yy_buffer_read) {");
        this.m_outstream.println("\t\t\tif (yy_buffer_index >= yy_buffer.length) {");
        this.m_outstream.println("\t\t\t\tyy_buffer = yy_double(yy_buffer);");
        this.m_outstream.println("\t\t\t}");
        this.m_outstream.println("\t\t\tnext_read = yy_reader.read(yy_buffer,");
        this.m_outstream.println("\t\t\t\t\tyy_buffer_read,");
        this.m_outstream.println("\t\t\t\t\tyy_buffer.length - yy_buffer_read);");
        this.m_outstream.println("\t\t\tif (-1 == next_read) {");
        this.m_outstream.println("\t\t\t\treturn YY_EOF;");
        this.m_outstream.println("\t\t\t}");
        this.m_outstream.println("\t\t\tyy_buffer_read = yy_buffer_read + next_read;");
        this.m_outstream.println("\t\t}");
        this.m_outstream.println("\t\treturn yy_buffer[yy_buffer_index++];");
        this.m_outstream.println("\t}");
        this.m_outstream.println("\tprivate void yy_move_end () {");
        this.m_outstream.println("\t\tif (yy_buffer_end > yy_buffer_start &&");
        this.m_outstream.println("\t\t    '\\n' == yy_buffer[yy_buffer_end-1])");
        this.m_outstream.println("\t\t\tyy_buffer_end--;");
        this.m_outstream.println("\t\tif (yy_buffer_end > yy_buffer_start &&");
        this.m_outstream.println("\t\t    '\\r' == yy_buffer[yy_buffer_end-1])");
        this.m_outstream.println("\t\t\tyy_buffer_end--;");
        this.m_outstream.println("\t}");
        this.m_outstream.println("\tprivate boolean yy_last_was_cr=false;");
        this.m_outstream.println("\tprivate void yy_mark_start () {");
        if (this.m_spec.m_count_lines || this.m_spec.m_count_chars) {
            if (this.m_spec.m_count_lines) {
                this.m_outstream.println("\t\tint i;");
                this.m_outstream.println("\t\tfor (i = yy_buffer_start; i < yy_buffer_index; ++i) {");
                this.m_outstream.println("\t\t\tif ('\\n' == yy_buffer[i] && !yy_last_was_cr) {");
                this.m_outstream.println("\t\t\t\t++yyline;");
                this.m_outstream.println("\t\t\t}");
                this.m_outstream.println("\t\t\tif ('\\r' == yy_buffer[i]) {");
                this.m_outstream.println("\t\t\t\t++yyline;");
                this.m_outstream.println("\t\t\t\tyy_last_was_cr=true;");
                this.m_outstream.println("\t\t\t} else yy_last_was_cr=false;");
                this.m_outstream.println("\t\t}");
            }
            if (this.m_spec.m_count_chars) {
                this.m_outstream.println("\t\tyychar = yychar");
                this.m_outstream.println("\t\t\t+ yy_buffer_index - yy_buffer_start;");
            }
        }
        this.m_outstream.println("\t\tyy_buffer_start = yy_buffer_index;");
        this.m_outstream.println("\t}");
        this.m_outstream.println("\tprivate void yy_mark_end () {");
        this.m_outstream.println("\t\tyy_buffer_end = yy_buffer_index;");
        this.m_outstream.println("\t}");
        this.m_outstream.println("\tprivate void yy_to_mark () {");
        this.m_outstream.println("\t\tyy_buffer_index = yy_buffer_end;");
        this.m_outstream.println("\t\tyy_at_bol = (yy_buffer_end > yy_buffer_start) &&");
        this.m_outstream.println("\t\t            ('\\r' == yy_buffer[yy_buffer_end-1] ||");
        this.m_outstream.println("\t\t             '\\n' == yy_buffer[yy_buffer_end-1] ||");
        this.m_outstream.println("\t\t             2028/*LS*/ == yy_buffer[yy_buffer_end-1] ||");
        this.m_outstream.println("\t\t             2029/*PS*/ == yy_buffer[yy_buffer_end-1]);");
        this.m_outstream.println("\t}");
        this.m_outstream.println("\tprivate java.lang.String yytext () {");
        this.m_outstream.println("\t\treturn (new java.lang.String(yy_buffer,");
        this.m_outstream.println("\t\t\tyy_buffer_start,");
        this.m_outstream.println("\t\t\tyy_buffer_end - yy_buffer_start));");
        this.m_outstream.println("\t}");
        this.m_outstream.println("\tprivate int yylength () {");
        this.m_outstream.println("\t\treturn yy_buffer_end - yy_buffer_start;");
        this.m_outstream.println("\t}");
        this.m_outstream.println("\tprivate char[] yy_double (char buf[]) {");
        this.m_outstream.println("\t\tint i;");
        this.m_outstream.println("\t\tchar newbuf[];");
        this.m_outstream.println("\t\tnewbuf = new char[2*buf.length];");
        this.m_outstream.println("\t\tfor (i = 0; i < buf.length; ++i) {");
        this.m_outstream.println("\t\t\tnewbuf[i] = buf[i];");
        this.m_outstream.println("\t\t}");
        this.m_outstream.println("\t\treturn newbuf;");
        this.m_outstream.println("\t}");
        this.m_outstream.println("\tprivate final int YY_E_INTERNAL = 0;");
        this.m_outstream.println("\tprivate final int YY_E_MATCH = 1;");
        this.m_outstream.println("\tprivate java.lang.String yy_error_string[] = {");
        this.m_outstream.println("\t\t\"Error: Internal error.\\n\",");
        this.m_outstream.println("\t\t\"Error: Unmatched input.\\n\"");
        this.m_outstream.println("\t};");
        this.m_outstream.println("\tprivate void yy_error (int code,boolean fatal) {");
        this.m_outstream.println("\t\tjava.lang.System.out.print(yy_error_string[code]);");
        this.m_outstream.println("\t\tjava.lang.System.out.flush();");
        this.m_outstream.println("\t\tif (fatal) {");
        this.m_outstream.println("\t\t\tthrow new Error(\"Fatal Error.\\n\");");
        this.m_outstream.println("\t\t}");
        this.m_outstream.println("\t}");
        this.m_outstream.println("\tprivate int[][] unpackFromString(int size1, int size2, String st) {");
        this.m_outstream.println("\t\tint colonIndex = -1;");
        this.m_outstream.println("\t\tString lengthString;");
        this.m_outstream.println("\t\tint sequenceLength = 0;");
        this.m_outstream.println("\t\tint sequenceInteger = 0;");
        this.m_outstream.println("");
        this.m_outstream.println("\t\tint commaIndex;");
        this.m_outstream.println("\t\tString workString;");
        this.m_outstream.println("");
        this.m_outstream.println("\t\tint res[][] = new int[size1][size2];");
        this.m_outstream.println("\t\tfor (int i= 0; i < size1; i++) {");
        this.m_outstream.println("\t\t\tfor (int j= 0; j < size2; j++) {");
        this.m_outstream.println("\t\t\t\tif (sequenceLength != 0) {");
        this.m_outstream.println("\t\t\t\t\tres[i][j] = sequenceInteger;");
        this.m_outstream.println("\t\t\t\t\tsequenceLength--;");
        this.m_outstream.println("\t\t\t\t\tcontinue;");
        this.m_outstream.println("\t\t\t\t}");
        this.m_outstream.println("\t\t\t\tcommaIndex = st.indexOf(',');");
        this.m_outstream.println("\t\t\t\tworkString = (commaIndex==-1) ? st :");
        this.m_outstream.println("\t\t\t\t\tst.substring(0, commaIndex);");
        this.m_outstream.println("\t\t\t\tst = st.substring(commaIndex+1);");
        this.m_outstream.println("\t\t\t\tcolonIndex = workString.indexOf(':');");
        this.m_outstream.println("\t\t\t\tif (colonIndex == -1) {");
        this.m_outstream.println("\t\t\t\t\tres[i][j]=Integer.parseInt(workString);");
        this.m_outstream.println("\t\t\t\t\tcontinue;");
        this.m_outstream.println("\t\t\t\t}");
        this.m_outstream.println("\t\t\t\tlengthString =");
        this.m_outstream.println("\t\t\t\t\tworkString.substring(colonIndex+1);");
        this.m_outstream.println("\t\t\t\tsequenceLength=Integer.parseInt(lengthString);");
        this.m_outstream.println("\t\t\t\tworkString=workString.substring(0,colonIndex);");
        this.m_outstream.println("\t\t\t\tsequenceInteger=Integer.parseInt(workString);");
        this.m_outstream.println("\t\t\t\tres[i][j] = sequenceInteger;");
        this.m_outstream.println("\t\t\t\tsequenceLength--;");
        this.m_outstream.println("\t\t\t}");
        this.m_outstream.println("\t\t}");
        this.m_outstream.println("\t\treturn res;");
        this.m_outstream.println("\t}");
    }

    private void emit_header() throws IOException {
        CUtility.ASSERT(null != this.m_spec);
        CUtility.ASSERT(null != this.m_outstream);
        this.m_outstream.println("");
        this.m_outstream.println("");
        if (this.m_spec.m_public) {
            this.m_outstream.print("public ");
        }
        this.m_outstream.print("class ");
        this.m_outstream.print(new String(this.m_spec.m_class_name, 0, this.m_spec.m_class_name.length));
        if (this.m_spec.m_implements_name.length > 0) {
            this.m_outstream.print(" implements ");
            this.m_outstream.print(new String(this.m_spec.m_implements_name, 0, this.m_spec.m_implements_name.length));
        }
        this.m_outstream.println(" {");
    }

    private void emit_table() throws IOException {
        int elem;
        CUtility.ASSERT(null != this.m_spec);
        CUtility.ASSERT(null != this.m_outstream);
        this.m_outstream.println("\tprivate int yy_acpt[] = {");
        int size = this.m_spec.m_accept_vector.size();
        for (elem = 0; elem < size; ++elem) {
            CAccept accept = (CAccept)this.m_spec.m_accept_vector.elementAt(elem);
            this.m_outstream.print("\t\t/* " + elem + " */ ");
            if (null != accept) {
                boolean is_end;
                boolean is_start = 0 != (this.m_spec.m_anchor_array[elem] & 1);
                boolean bl = is_end = 0 != (this.m_spec.m_anchor_array[elem] & 2);
                if (is_start && is_end) {
                    this.m_outstream.print("YY_START | YY_END");
                } else if (is_start) {
                    this.m_outstream.print("YY_START");
                } else if (is_end) {
                    this.m_outstream.print("YY_END");
                } else {
                    this.m_outstream.print("YY_NO_ANCHOR");
                }
            } else {
                this.m_outstream.print("YY_NOT_ACCEPT");
            }
            if (elem < size - 1) {
                this.m_outstream.print(",");
            }
            this.m_outstream.println("");
        }
        this.m_outstream.println("\t};");
        int[] yy_cmap = new int[this.m_spec.m_ccls_map.length];
        for (int i = 0; i < this.m_spec.m_ccls_map.length; ++i) {
            yy_cmap[i] = this.m_spec.m_col_map[this.m_spec.m_ccls_map[i]];
        }
        this.m_outstream.print("\tprivate int yy_cmap[] = unpackFromString(");
        this.emit_table_as_string(new int[][]{yy_cmap});
        this.m_outstream.println(")[0];");
        this.m_outstream.println("");
        this.m_outstream.print("\tprivate int yy_rmap[] = unpackFromString(");
        this.emit_table_as_string(new int[][]{this.m_spec.m_row_map});
        this.m_outstream.println(")[0];");
        this.m_outstream.println("");
        size = this.m_spec.m_dtrans_vector.size();
        int[][] yy_nxt = new int[size][];
        for (elem = 0; elem < size; ++elem) {
            CDTrans dtrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(elem);
            CUtility.ASSERT(dtrans.m_dtrans.length == this.m_spec.m_dtrans_ncols);
            yy_nxt[elem] = dtrans.m_dtrans;
        }
        this.m_outstream.print("\tprivate int yy_nxt[][] = unpackFromString(");
        this.emit_table_as_string(yy_nxt);
        this.m_outstream.println(");");
        this.m_outstream.println("");
    }

    private void emit_table_as_string(int[][] ia) {
        int sequenceLength = 0;
        boolean sequenceStarted = false;
        int previousInt = -20;
        this.m_outstream.print(ia.length);
        this.m_outstream.print(",");
        this.m_outstream.print(ia.length > 0 ? ia[0].length : 0);
        this.m_outstream.println(",");
        StringBuffer outstr = new StringBuffer();
        for (int elem = 0; elem < ia.length; ++elem) {
            for (int i = 0; i < ia[elem].length; ++i) {
                int writeInt = ia[elem][i];
                if (writeInt == previousInt) {
                    if (sequenceStarted) {
                        ++sequenceLength;
                    } else {
                        outstr.append(writeInt);
                        outstr.append(":");
                        sequenceLength = 2;
                        sequenceStarted = true;
                    }
                } else if (sequenceStarted) {
                    outstr.append(sequenceLength);
                    outstr.append(",");
                    sequenceLength = 0;
                    sequenceStarted = false;
                } else if (previousInt != -20) {
                    outstr.append(previousInt);
                    outstr.append(",");
                }
                previousInt = writeInt;
                if (outstr.length() <= 75) continue;
                String s = outstr.toString();
                this.m_outstream.println("\"" + s.substring(0, 75) + "\" +");
                outstr = new StringBuffer(s.substring(75));
            }
        }
        if (sequenceStarted) {
            outstr.append(sequenceLength);
        } else {
            outstr.append(previousInt);
        }
        if (outstr.length() > 75) {
            String s = outstr.toString();
            this.m_outstream.println("\"" + s.substring(0, 75) + "\" +");
            outstr = new StringBuffer(s.substring(75));
        }
        this.m_outstream.print("\"" + outstr + "\"");
    }

    private void emit_driver() throws IOException {
        CUtility.ASSERT(null != this.m_spec);
        CUtility.ASSERT(null != this.m_outstream);
        this.emit_table();
        if (this.m_spec.m_integer_type) {
            this.m_outstream.print("\tpublic int ");
            this.m_outstream.print(new String(this.m_spec.m_function_name));
            this.m_outstream.println(" ()");
        } else if (this.m_spec.m_intwrap_type) {
            this.m_outstream.print("\tpublic java.lang.Integer ");
            this.m_outstream.print(new String(this.m_spec.m_function_name));
            this.m_outstream.println(" ()");
        } else {
            this.m_outstream.print("\tpublic ");
            this.m_outstream.print(new String(this.m_spec.m_type_name));
            this.m_outstream.print(" ");
            this.m_outstream.print(new String(this.m_spec.m_function_name));
            this.m_outstream.println(" ()");
        }
        this.m_outstream.print("\t\tthrows java.io.IOException");
        if (null != this.m_spec.m_yylex_throw_code) {
            this.m_outstream.print(", ");
            this.m_outstream.print(new String(this.m_spec.m_yylex_throw_code, 0, this.m_spec.m_yylex_throw_read));
            this.m_outstream.println("");
            this.m_outstream.println("\t\t{");
        } else {
            this.m_outstream.println(" {");
        }
        this.m_outstream.println("\t\tint yy_lookahead;");
        this.m_outstream.println("\t\tint yy_anchor = YY_NO_ANCHOR;");
        this.m_outstream.println("\t\tint yy_state = yy_state_dtrans[yy_lexical_state];");
        this.m_outstream.println("\t\tint yy_next_state = YY_NO_STATE;");
        this.m_outstream.println("\t\tint yy_last_accept_state = YY_NO_STATE;");
        this.m_outstream.println("\t\tboolean yy_initial = true;");
        this.m_outstream.println("\t\tint yy_this_accept;");
        this.m_outstream.println("");
        this.m_outstream.println("\t\tyy_mark_start();");
        this.m_outstream.println("\t\tyy_this_accept = yy_acpt[yy_state];");
        this.m_outstream.println("\t\tif (YY_NOT_ACCEPT != yy_this_accept) {");
        this.m_outstream.println("\t\t\tyy_last_accept_state = yy_state;");
        this.m_outstream.println("\t\t\tyy_mark_end();");
        this.m_outstream.println("\t\t}");
        this.m_outstream.println("\t\twhile (true) {");
        this.m_outstream.println("\t\t\tif (yy_initial && yy_at_bol) yy_lookahead = YY_BOL;");
        this.m_outstream.println("\t\t\telse yy_lookahead = yy_advance();");
        this.m_outstream.println("\t\t\tyy_next_state = YY_F;");
        this.m_outstream.println("\t\t\tyy_next_state = yy_nxt[yy_rmap[yy_state]][yy_cmap[yy_lookahead]];");
        this.m_outstream.println("\t\t\tif (YY_EOF == yy_lookahead && true == yy_initial) {");
        if (null != this.m_spec.m_eof_code) {
            this.m_outstream.println("\t\t\t\tyy_do_eof();");
        }
        if (this.m_spec.m_integer_type) {
            this.m_outstream.println("\t\t\t\treturn YYEOF;");
        } else if (null != this.m_spec.m_eof_value_code) {
            this.m_outstream.print(new String(this.m_spec.m_eof_value_code, 0, this.m_spec.m_eof_value_read));
        } else {
            this.m_outstream.println("\t\t\t\treturn null;");
        }
        this.m_outstream.println("\t\t\t}");
        this.m_outstream.println("\t\t\tif (YY_F != yy_next_state) {");
        this.m_outstream.println("\t\t\t\tyy_state = yy_next_state;");
        this.m_outstream.println("\t\t\t\tyy_initial = false;");
        this.m_outstream.println("\t\t\t\tyy_this_accept = yy_acpt[yy_state];");
        this.m_outstream.println("\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {");
        this.m_outstream.println("\t\t\t\t\tyy_last_accept_state = yy_state;");
        this.m_outstream.println("\t\t\t\t\tyy_mark_end();");
        this.m_outstream.println("\t\t\t\t}");
        this.m_outstream.println("\t\t\t}");
        this.m_outstream.println("\t\t\telse {");
        this.m_outstream.println("\t\t\t\tif (YY_NO_STATE == yy_last_accept_state) {");
        this.m_outstream.println("\t\t\t\t\tthrow (new Error(\"Lexical Error: Unmatched Input.\"));");
        this.m_outstream.println("\t\t\t\t}");
        this.m_outstream.println("\t\t\t\telse {");
        this.m_outstream.println("\t\t\t\t\tyy_anchor = yy_acpt[yy_last_accept_state];");
        this.m_outstream.println("\t\t\t\t\tif (0 != (YY_END & yy_anchor)) {");
        this.m_outstream.println("\t\t\t\t\t\tyy_move_end();");
        this.m_outstream.println("\t\t\t\t\t}");
        this.m_outstream.println("\t\t\t\t\tyy_to_mark();");
        this.m_outstream.println("\t\t\t\t\tswitch (yy_last_accept_state) {");
        this.emit_actions("\t\t\t\t\t");
        this.m_outstream.println("\t\t\t\t\tdefault:");
        this.m_outstream.println("\t\t\t\t\t\tyy_error(YY_E_INTERNAL,false);");
        this.m_outstream.println("\t\t\t\t\tcase -1:");
        this.m_outstream.println("\t\t\t\t\t}");
        this.m_outstream.println("\t\t\t\t\tyy_initial = true;");
        this.m_outstream.println("\t\t\t\t\tyy_state = yy_state_dtrans[yy_lexical_state];");
        this.m_outstream.println("\t\t\t\t\tyy_next_state = YY_NO_STATE;");
        this.m_outstream.println("\t\t\t\t\tyy_last_accept_state = YY_NO_STATE;");
        this.m_outstream.println("\t\t\t\t\tyy_mark_start();");
        this.m_outstream.println("\t\t\t\t\tyy_this_accept = yy_acpt[yy_state];");
        this.m_outstream.println("\t\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {");
        this.m_outstream.println("\t\t\t\t\t\tyy_last_accept_state = yy_state;");
        this.m_outstream.println("\t\t\t\t\t\tyy_mark_end();");
        this.m_outstream.println("\t\t\t\t\t}");
        this.m_outstream.println("\t\t\t\t}");
        this.m_outstream.println("\t\t\t}");
        this.m_outstream.println("\t\t}");
        this.m_outstream.println("\t}");
    }

    private void emit_actions(String tabs) throws IOException {
        CUtility.ASSERT(this.m_spec.m_accept_vector.size() == this.m_spec.m_anchor_array.length);
        int bogus_index = -2;
        int size = this.m_spec.m_accept_vector.size();
        for (int elem = 0; elem < size; ++elem) {
            CAccept accept = (CAccept)this.m_spec.m_accept_vector.elementAt(elem);
            if (null == accept) continue;
            this.m_outstream.println(tabs + "case " + elem + ":");
            this.m_outstream.print(tabs + "\t");
            this.m_outstream.print(new String(accept.m_action, 0, accept.m_action_read));
            this.m_outstream.println("");
            this.m_outstream.println(tabs + "case " + bogus_index + ":");
            this.m_outstream.println(tabs + "\tbreak;");
            --bogus_index;
        }
    }

    private void emit_footer() throws IOException {
        CUtility.ASSERT(null != this.m_spec);
        CUtility.ASSERT(null != this.m_outstream);
        this.m_outstream.println("}");
    }
}

