/*
 * Decompiled with CFR 0.152.
 */
package jscl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public class ArrayUtils {
    private static final int BINARYSEARCH_THRESHOLD = 5000;

    private ArrayUtils() {
    }

    public static Object[] concat(Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
        return objectArray3;
    }

    public static Object[] toArray(List list, Object[] objectArray) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = list.get(i);
        }
        return objectArray;
    }

    public static int[] toArray(List list, int[] nArray) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            nArray[i] = (Integer)list.get(i);
        }
        return nArray;
    }

    public static List list(Collection collection) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static String toString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(objectArray[i]).append(i < objectArray.length - 1 ? ", " : "");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static int binarySearch(List list, Object object) {
        if (list instanceof RandomAccess || list.size() < 5000) {
            return ArrayUtils.indexedBinarySearch(list, object);
        }
        return ArrayUtils.iteratorBinarySearch(list, object);
    }

    private static int indexedBinarySearch(List list, Object object) {
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            Object e = list.get(n3);
            int n4 = ((Comparable)e).compareTo(object);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private static int iteratorBinarySearch(List list, Object object) {
        int n = 0;
        int n2 = list.size() - 1;
        ListIterator listIterator = list.listIterator();
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            Object object2 = ArrayUtils.get(listIterator, n3);
            int n4 = ((Comparable)object2).compareTo(object);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private static Object get(ListIterator listIterator, int n) {
        Object var2_2 = null;
        int n2 = listIterator.nextIndex();
        if (n2 <= n) {
            do {
                var2_2 = listIterator.next();
            } while (n2++ < n);
        } else {
            do {
                var2_2 = listIterator.previous();
            } while (--n2 > n);
        }
        return var2_2;
    }
}

