/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial.groebner;

import java.util.List;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.groebner.F4Reduction;
import jscl.math.polynomial.groebner.Pair;

class Projection
implements Comparable {
    final Monomial monomial;
    final Polynomial polynomial;

    Projection(Pair pair, int n) {
        this(pair.scm.divide(pair.monomial[n]), pair.polynomial[n]);
    }

    Projection(Monomial monomial, Polynomial polynomial) {
        this.monomial = monomial;
        this.polynomial = polynomial;
    }

    Monomial scm() {
        return this.polynomial.head().monomial().multiply(this.monomial);
    }

    Polynomial mult() {
        return this.polynomial.multiply(this.monomial);
    }

    Projection simplify(List list) {
        Monomial monomial = this.monomial;
        if (monomial.degree() > 0) {
            Monomial monomial2 = this.polynomial.head().monomial();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                List list2 = ((F4Reduction)list.get((int)i)).polys;
                for (Polynomial polynomial : list2) {
                    Monomial monomial3 = polynomial.head().monomial();
                    if (!monomial3.multiple(monomial2, true) || !monomial.multiple(monomial3 = monomial3.divide(monomial2), true)) continue;
                    Projection projection = new Projection(monomial.divide(monomial3), polynomial).simplify(list);
                    return projection;
                }
            }
        }
        return this;
    }

    public int compareTo(Projection projection) {
        int n = this.monomial.compareTo(projection.monomial);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        n = this.polynomial.index() - projection.polynomial.index();
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object object) {
        return this.compareTo((Projection)object);
    }

    public String toString() {
        return "{" + this.monomial + ", " + this.polynomial.head().monomial() + "}";
    }
}

