/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial.groebner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jscl.math.Debug;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.Term;
import jscl.math.polynomial.groebner.Pair;
import jscl.math.polynomial.groebner.Projection;
import jscl.math.polynomial.groebner.ReducedRowEchelonForm;

class F4Reduction {
    final Collection ideal;
    final List list;
    final int flags;
    final List polys = new ArrayList();
    final List content = new ArrayList();
    final Map considered = new TreeMap();
    final Map head = new TreeMap();
    final Map proj = new TreeMap();

    F4Reduction(Collection collection, List list, int n) {
        this.ideal = collection;
        this.list = list;
        this.flags = n;
    }

    static List compute(List list, Collection collection, List list2, int n) {
        F4Reduction f4Reduction = new F4Reduction(collection, list2, n);
        f4Reduction.compute(list);
        return f4Reduction.content;
    }

    void compute(List list) {
        for (Pair pair : list) {
            this.considered.put(pair.scm, null);
            this.add(pair);
        }
        this.process();
        if ((this.flags & 0x2000) > 0) {
            this.list.add(this);
        }
    }

    void add(Pair pair) {
        Debug.println(pair);
        Projection[] projectionArray = new Projection[]{new Projection(pair, 0), new Projection(pair, 1)};
        for (int i = 0; i < projectionArray.length; ++i) {
            if (this.proj.containsKey(projectionArray[i])) continue;
            this.add(projectionArray[i].simplify(this.list));
            this.proj.put(projectionArray[i], null);
        }
    }

    void add(Projection projection) {
        Polynomial polynomial = projection.mult();
        Monomial monomial = projection.scm();
        this.head.put(monomial, null);
        Iterator iterator = polynomial.iterator(monomial);
        block0: while (iterator.hasNext()) {
            Term term = (Term)iterator.next();
            Monomial monomial2 = term.monomial();
            if (this.considered.containsKey(monomial2)) continue;
            this.considered.put(monomial2, null);
            for (Polynomial polynomial2 : this.ideal) {
                Monomial monomial3 = polynomial2.head().monomial();
                if (!monomial2.multiple(monomial3)) continue;
                Monomial monomial4 = monomial2.divide(monomial3);
                this.add(new Projection(monomial4, polynomial2).simplify(this.list));
                continue block0;
            }
        }
        this.content.add(polynomial);
    }

    void process() {
        List list = ReducedRowEchelonForm.compute(this.content);
        this.content.clear();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Polynomial polynomial = (Polynomial)list.get(i);
            if (polynomial.signum() == 0) continue;
            Monomial monomial = polynomial.head().monomial();
            if (!this.head.containsKey(monomial)) {
                this.content.add(polynomial);
                continue;
            }
            if (polynomial.index() != -1) {
                polynomial = polynomial.copy();
            }
            polynomial.setIndex(this.polys.size());
            this.polys.add(polynomial);
        }
    }
}

