/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Iterator;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Literal;
import jscl.math.NotDivisibleException;
import jscl.math.Variable;
import jscl.math.function.Inv;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.SquarefreeDecomposition;
import jscl.math.polynomial.Term;

public class UnivariatePolynomial
extends Polynomial {
    protected final Variable variable;
    Generic[] content = new Generic[8];
    int degree;

    protected UnivariatePolynomial(Variable variable) {
        this(variable, null);
    }

    UnivariatePolynomial(Variable variable, Generic generic) {
        super(Monomial.factory(new Variable[]{variable}), generic);
        this.variable = variable;
    }

    public Variable variable() {
        return this.variable;
    }

    @Override
    public int size() {
        return this.degree + 1;
    }

    @Override
    public Iterator iterator(boolean bl, Monomial monomial) {
        return new ContentIterator(bl, monomial);
    }

    Term term(int n) {
        return new Term(this.monomial(Literal.valueOf(this.variable, n)), this.get(n));
    }

    int indexOf(Monomial monomial, boolean bl) {
        if (monomial == null) {
            return bl ? this.degree + 1 : 0;
        }
        return monomial.degree();
    }

    @Override
    public Polynomial add(Polynomial polynomial) {
        int n;
        UnivariatePolynomial univariatePolynomial = this.newinstance();
        UnivariatePolynomial univariatePolynomial2 = (UnivariatePolynomial)polynomial;
        for (int i = n = Math.max(this.degree, univariatePolynomial2.degree); i >= 0; --i) {
            univariatePolynomial.put(i, this.get(i).add(univariatePolynomial2.get(i)));
        }
        return univariatePolynomial;
    }

    @Override
    public Polynomial subtract(Polynomial polynomial) {
        int n;
        UnivariatePolynomial univariatePolynomial = this.newinstance();
        UnivariatePolynomial univariatePolynomial2 = (UnivariatePolynomial)polynomial;
        for (int i = n = Math.max(this.degree, univariatePolynomial2.degree); i >= 0; --i) {
            univariatePolynomial.put(i, this.get(i).subtract(univariatePolynomial2.get(i)));
        }
        return univariatePolynomial;
    }

    @Override
    public Polynomial multiply(Polynomial polynomial) {
        UnivariatePolynomial univariatePolynomial = this.newinstance();
        UnivariatePolynomial univariatePolynomial2 = (UnivariatePolynomial)polynomial;
        for (int i = this.degree; i >= 0; --i) {
            for (int j = univariatePolynomial2.degree; j >= 0; --j) {
                univariatePolynomial.put(i + j, this.get(i).multiply(univariatePolynomial2.get(j)));
            }
        }
        return univariatePolynomial;
    }

    @Override
    public Polynomial multiply(Generic generic) {
        UnivariatePolynomial univariatePolynomial = this.newinstance();
        for (int i = this.degree; i >= 0; --i) {
            univariatePolynomial.put(i, this.get(i).multiply(generic));
        }
        return univariatePolynomial;
    }

    public Polynomial multiply(Monomial monomial, Generic generic) {
        int n;
        UnivariatePolynomial univariatePolynomial = this.newinstance();
        int n2 = monomial.degree();
        for (n = this.degree; n >= 0; --n) {
            univariatePolynomial.put(n + n2, this.get(n).multiply(generic));
        }
        for (n = n2 - 1; n >= 0; --n) {
            univariatePolynomial.put(n, JSCLInteger.valueOf(0L));
        }
        return univariatePolynomial;
    }

    @Override
    public Polynomial multiply(Monomial monomial) {
        return this.multiply(monomial, JSCLInteger.valueOf(1L));
    }

    @Override
    public Polynomial divide(Generic generic) throws ArithmeticException {
        UnivariatePolynomial univariatePolynomial = this.newinstance();
        for (int i = this.degree; i >= 0; --i) {
            univariatePolynomial.put(i, this.get(i).divide(generic));
        }
        return univariatePolynomial;
    }

    @Override
    public Polynomial divide(Monomial monomial) throws ArithmeticException {
        int n;
        UnivariatePolynomial univariatePolynomial = this.newinstance();
        int n2 = monomial.degree();
        for (n = n2 - 1; n >= 0; --n) {
            if (this.get(n).signum() == 0) continue;
            throw new NotDivisibleException();
        }
        for (n = this.degree; n >= n2; --n) {
            univariatePolynomial.put(n - n2, this.get(n));
        }
        return univariatePolynomial;
    }

    @Override
    public Polynomial[] divideAndRemainder(Polynomial polynomial) throws ArithmeticException {
        Polynomial[] polynomialArray = new UnivariatePolynomial[]{this.newinstance(), this};
        UnivariatePolynomial univariatePolynomial = (UnivariatePolynomial)polynomial;
        if (polynomialArray[1].signum() == 0) {
            return polynomialArray;
        }
        for (int i = ((UnivariatePolynomial)polynomialArray[1]).degree - univariatePolynomial.degree; i >= 0; --i) {
            ((UnivariatePolynomial)polynomialArray[0]).put(i, ((UnivariatePolynomial)polynomialArray[1]).get(i + univariatePolynomial.degree).divide(univariatePolynomial.get(univariatePolynomial.degree)));
            UnivariatePolynomial univariatePolynomial2 = this.newinstance();
            for (int j = i + univariatePolynomial.degree - 1; j >= 0; --j) {
                Generic generic = ((UnivariatePolynomial)polynomialArray[1]).get(j);
                univariatePolynomial2.put(j, generic.subtract(univariatePolynomial.get(j - i).multiply(((UnivariatePolynomial)polynomialArray[0]).get(i))));
            }
            polynomialArray[1] = univariatePolynomial2;
        }
        return polynomialArray;
    }

    @Override
    public Polynomial remainderUpToCoefficient(Polynomial polynomial) throws ArithmeticException {
        UnivariatePolynomial univariatePolynomial = this;
        UnivariatePolynomial univariatePolynomial2 = (UnivariatePolynomial)polynomial;
        if (univariatePolynomial.signum() == 0) {
            return univariatePolynomial;
        }
        for (int i = univariatePolynomial.degree - univariatePolynomial2.degree; i >= 0; --i) {
            UnivariatePolynomial univariatePolynomial3 = this.newinstance();
            for (int j = i + univariatePolynomial2.degree - 1; j >= 0; --j) {
                Generic generic = univariatePolynomial.get(j).multiply(univariatePolynomial2.get(univariatePolynomial2.degree));
                univariatePolynomial3.put(j, generic.subtract(univariatePolynomial2.get(j - i).multiply(univariatePolynomial.get(i + univariatePolynomial2.degree))));
            }
            univariatePolynomial = univariatePolynomial3;
        }
        return univariatePolynomial;
    }

    @Override
    public Polynomial gcd(Polynomial polynomial) {
        UnivariatePolynomial univariatePolynomial = this;
        UnivariatePolynomial univariatePolynomial2 = (UnivariatePolynomial)polynomial;
        if (univariatePolynomial.signum() == 0) {
            return univariatePolynomial2;
        }
        if (univariatePolynomial2.signum() == 0) {
            return univariatePolynomial;
        }
        if (univariatePolynomial.degree < univariatePolynomial2.degree) {
            UnivariatePolynomial univariatePolynomial3 = univariatePolynomial;
            univariatePolynomial = univariatePolynomial2;
            univariatePolynomial2 = univariatePolynomial3;
        }
        int n = univariatePolynomial.degree - univariatePolynomial2.degree;
        Generic generic = JSCLInteger.valueOf(-1L);
        Generic generic2 = JSCLInteger.valueOf(-1L).pow(n + 1);
        Polynomial[] polynomialArray = univariatePolynomial.gcdAndNormalize();
        Polynomial[] polynomialArray2 = univariatePolynomial2.gcdAndNormalize();
        Generic generic3 = polynomialArray[0].genericValue();
        Generic generic4 = polynomialArray2[0].genericValue();
        univariatePolynomial = (UnivariatePolynomial)polynomialArray[1];
        univariatePolynomial2 = (UnivariatePolynomial)polynomialArray2[1];
        while (univariatePolynomial2.degree > 0) {
            UnivariatePolynomial univariatePolynomial4 = (UnivariatePolynomial)univariatePolynomial.remainderUpToCoefficient(univariatePolynomial2).divide(generic2);
            generic = n > 1 ? univariatePolynomial2.get(univariatePolynomial2.degree).negate().pow(n).divide(generic.pow(n - 1)) : univariatePolynomial2.get(univariatePolynomial2.degree).negate().pow(n).multiply(generic.pow(1 - n));
            univariatePolynomial = univariatePolynomial2;
            univariatePolynomial2 = univariatePolynomial4;
            n = univariatePolynomial.degree - univariatePolynomial2.degree;
            generic2 = univariatePolynomial.get(univariatePolynomial.degree).negate().multiply(generic.pow(n));
        }
        if (univariatePolynomial2.signum() == 0) {
            univariatePolynomial = (UnivariatePolynomial)univariatePolynomial.normalize();
        } else {
            univariatePolynomial = this.newinstance();
            univariatePolynomial.put(0, JSCLInteger.valueOf(1L));
        }
        return univariatePolynomial.multiply(generic3.gcd(generic4));
    }

    @Override
    public Generic gcd() {
        Generic generic = this.coefficient(JSCLInteger.valueOf(0L));
        for (int i = this.degree; i >= 0; --i) {
            generic = generic.gcd(this.get(i));
        }
        return generic.signum() == this.signum() ? generic : generic.negate();
    }

    @Override
    public Monomial monomialGcd() {
        return this.monomial(this.tail());
    }

    @Override
    public int degree() {
        return this.degree;
    }

    public UnivariatePolynomial valueof(Generic[] genericArray) {
        UnivariatePolynomial univariatePolynomial = this.newinstance();
        univariatePolynomial.init(genericArray);
        return univariatePolynomial;
    }

    @Override
    public Polynomial valueof(Polynomial polynomial) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Polynomial valueof(Generic generic) {
        UnivariatePolynomial univariatePolynomial = this.newinstance();
        univariatePolynomial.init(generic);
        return univariatePolynomial;
    }

    @Override
    public Polynomial valueof(Monomial monomial) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Polynomial freeze() {
        return this;
    }

    @Override
    public Term head() {
        return this.term(this.degree);
    }

    @Override
    public Generic coefficient(Monomial monomial) {
        return this.term(monomial.degree()).coef();
    }

    public Polynomial reduce(Generic generic, Monomial monomial, Polynomial polynomial, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic genericValue() {
        Generic generic = JSCLInteger.valueOf(0L);
        for (int i = this.degree; i >= 0; --i) {
            Expression expression = this.get(i).expressionValue();
            generic = ((Generic)generic).add(i > 0 ? ((Generic)expression).multiply(Expression.valueOf(Literal.valueOf(this.variable, i))) : expression);
        }
        return generic;
    }

    @Override
    public Generic[] elements() {
        Generic[] genericArray = new Generic[this.degree + 1];
        for (int i = this.degree; i >= 0; --i) {
            genericArray[i] = this.get(i);
        }
        return genericArray;
    }

    public UnivariatePolynomial derivative(Variable variable) {
        return (UnivariatePolynomial)this.derivative().multiply(this.variable.derivative(variable));
    }

    public Generic substitute(Generic generic) {
        Generic generic2 = JSCLInteger.valueOf(0L);
        for (int i = this.degree; i >= 0; --i) {
            generic2 = ((Generic)generic2).add(this.get(i).multiply(generic.pow(i)));
        }
        return generic2;
    }

    public Generic solve() {
        if (this.degree == 1) {
            return this.get(0).multiply(new Inv(this.get(1)).evaluate()).negate();
        }
        return null;
    }

    public Generic[] identification(UnivariatePolynomial univariatePolynomial) {
        UnivariatePolynomial univariatePolynomial2;
        UnivariatePolynomial univariatePolynomial3 = this;
        UnivariatePolynomial univariatePolynomial4 = univariatePolynomial;
        if (univariatePolynomial3.degree < univariatePolynomial4.degree || univariatePolynomial3.degree == 0 && univariatePolynomial4.signum() == 0) {
            univariatePolynomial2 = univariatePolynomial3;
            univariatePolynomial3 = univariatePolynomial4;
            univariatePolynomial4 = univariatePolynomial2;
        }
        univariatePolynomial2 = (UnivariatePolynomial)univariatePolynomial3.remainderUpToCoefficient(univariatePolynomial4);
        Generic[] genericArray = new Generic[univariatePolynomial2.degree + 1];
        for (int i = univariatePolynomial2.degree; i >= 0; --i) {
            genericArray[univariatePolynomial2.degree - i] = univariatePolynomial2.get(i);
        }
        return genericArray;
    }

    public Generic resultant(UnivariatePolynomial univariatePolynomial) {
        UnivariatePolynomial univariatePolynomial2 = this;
        UnivariatePolynomial univariatePolynomial3 = univariatePolynomial;
        if (univariatePolynomial2.degree < univariatePolynomial3.degree || univariatePolynomial2.degree == 0 && univariatePolynomial3.signum() == 0) {
            UnivariatePolynomial univariatePolynomial4 = univariatePolynomial2;
            univariatePolynomial2 = univariatePolynomial3;
            univariatePolynomial3 = univariatePolynomial4;
        }
        int n = univariatePolynomial2.degree - univariatePolynomial3.degree;
        Generic generic = JSCLInteger.valueOf(-1L);
        Generic generic2 = JSCLInteger.valueOf(-1L).pow(n + 1);
        while (univariatePolynomial3.degree > 0) {
            UnivariatePolynomial univariatePolynomial5 = (UnivariatePolynomial)univariatePolynomial2.remainderUpToCoefficient(univariatePolynomial3).divide(generic2);
            generic = n > 1 ? univariatePolynomial3.get(univariatePolynomial3.degree).negate().pow(n).divide(generic.pow(n - 1)) : univariatePolynomial3.get(univariatePolynomial3.degree).negate().pow(n).multiply(generic.pow(1 - n));
            univariatePolynomial2 = univariatePolynomial3;
            univariatePolynomial3 = univariatePolynomial5;
            n = univariatePolynomial2.degree - univariatePolynomial3.degree;
            generic2 = univariatePolynomial2.get(univariatePolynomial2.degree).negate().multiply(generic.pow(n));
        }
        return univariatePolynomial3.get(0);
    }

    public UnivariatePolynomial[] remainderSequence(UnivariatePolynomial univariatePolynomial) {
        UnivariatePolynomial[] univariatePolynomialArray;
        Object object = this;
        UnivariatePolynomial univariatePolynomial2 = univariatePolynomial;
        if (((UnivariatePolynomial)object).degree < univariatePolynomial2.degree || ((UnivariatePolynomial)object).degree == 0 && univariatePolynomial2.signum() == 0) {
            univariatePolynomialArray = object;
            object = univariatePolynomial2;
            univariatePolynomial2 = univariatePolynomialArray;
        }
        univariatePolynomialArray = new UnivariatePolynomial[univariatePolynomial2.degree + 1];
        univariatePolynomialArray[univariatePolynomial2.degree] = univariatePolynomial2;
        int n = ((UnivariatePolynomial)object).degree - univariatePolynomial2.degree;
        Generic generic = JSCLInteger.valueOf(-1L);
        Generic generic2 = JSCLInteger.valueOf(-1L).pow(n + 1);
        while (univariatePolynomial2.degree > 0) {
            UnivariatePolynomial univariatePolynomial3 = (UnivariatePolynomial)((UnivariatePolynomial)object).remainderUpToCoefficient(univariatePolynomial2).divide(generic2);
            generic = n > 1 ? univariatePolynomial2.get(univariatePolynomial2.degree).negate().pow(n).divide(generic.pow(n - 1)) : univariatePolynomial2.get(univariatePolynomial2.degree).negate().pow(n).multiply(generic.pow(1 - n));
            object = univariatePolynomial2;
            univariatePolynomialArray[univariatePolynomial2.degree] = univariatePolynomial2 = univariatePolynomial3;
            n = ((UnivariatePolynomial)object).degree - univariatePolynomial2.degree;
            generic2 = ((UnivariatePolynomial)object).get(((UnivariatePolynomial)object).degree).negate().multiply(generic.pow(n));
        }
        return univariatePolynomialArray;
    }

    public UnivariatePolynomial squarefree() {
        return (UnivariatePolynomial)this.divide(this.gcd(this.derivative()));
    }

    public UnivariatePolynomial[] squarefreeDecomposition() {
        return SquarefreeDecomposition.compute(this);
    }

    public UnivariatePolynomial antiderivative() {
        UnivariatePolynomial univariatePolynomial = this.newinstance();
        for (int i = this.degree; i >= 0; --i) {
            univariatePolynomial.put(i + 1, this.get(i).multiply(new Inv(JSCLInteger.valueOf(i + 1)).evaluate()));
        }
        return univariatePolynomial;
    }

    public UnivariatePolynomial derivative() {
        UnivariatePolynomial univariatePolynomial = this.newinstance();
        for (int i = this.degree - 1; i >= 0; --i) {
            univariatePolynomial.put(i, this.get(i + 1).multiply(JSCLInteger.valueOf(i + 1)));
        }
        return univariatePolynomial;
    }

    @Override
    public int compareTo(Polynomial polynomial) {
        int n;
        UnivariatePolynomial univariatePolynomial = (UnivariatePolynomial)polynomial;
        for (int i = n = Math.max(this.degree, univariatePolynomial.degree); i >= 0; --i) {
            Generic generic;
            Generic generic2 = this.get(i);
            int n2 = generic2.compareTo(generic = univariatePolynomial.get(i));
            if (n2 < 0) {
                return -1;
            }
            if (n2 <= 0) continue;
            return 1;
        }
        return 0;
    }

    void init(Generic[] genericArray) {
        for (int i = 0; i < genericArray.length; ++i) {
            this.put(i, this.coefficient(genericArray[i]));
        }
    }

    void init(Expression expression) {
        int n = expression.size();
        for (int i = 0; i < n; ++i) {
            Literal literal = expression.literal(i);
            JSCLInteger jSCLInteger = expression.coef(i);
            Monomial monomial = this.monomial(literal);
            if ((literal = literal.divide(monomial.literalValue())).degree() > 0) {
                this.put(monomial.degree(), this.coefficient(jSCLInteger.multiply(Expression.valueOf(literal))));
                continue;
            }
            this.put(monomial.degree(), this.coefficient(jSCLInteger));
        }
    }

    protected void init(Generic generic) {
        if (generic instanceof Expression) {
            this.init((Expression)generic);
        } else {
            this.put(0, this.coefficient(generic));
        }
    }

    void put(int n, Generic generic) {
        Generic generic2 = generic.add(this.get(n));
        if (generic2.signum() == 0) {
            if (n <= this.degree) {
                this.content[n] = null;
            }
            if (n == this.degree) {
                while (n > 0 && this.content[n] == null) {
                    --n;
                }
                this.degree = n;
            }
        } else {
            if (n >= this.content.length) {
                this.resize(n);
            }
            this.content[n] = generic2;
            this.degree = Math.max(this.degree, n);
        }
    }

    void resize(int n) {
        int n2;
        for (n2 = this.content.length << 1; n >= n2; n2 <<= 1) {
        }
        Generic[] genericArray = new Generic[n2];
        System.arraycopy(this.content, 0, genericArray, 0, this.content.length);
        this.content = genericArray;
    }

    public Generic get(int n) {
        JSCLInteger jSCLInteger = n < 0 || n > this.degree ? null : this.content[n];
        return jSCLInteger == null ? JSCLInteger.valueOf(0L) : jSCLInteger;
    }

    protected UnivariatePolynomial newinstance() {
        return new UnivariatePolynomial(this.variable, this.coefFactory);
    }

    class ContentIterator
    implements Iterator {
        final boolean direction;
        int index;

        ContentIterator(boolean bl, Monomial monomial) {
            this.direction = bl;
            if (bl) {
                this.index = UnivariatePolynomial.this.indexOf(monomial, true);
            } else {
                this.index = UnivariatePolynomial.this.indexOf(monomial, false);
                if (monomial != null && UnivariatePolynomial.this.get(this.index).signum() != 0) {
                    ++this.index;
                }
            }
            this.seek();
        }

        void seek() {
            if (this.direction) {
                while (this.index > 0 && UnivariatePolynomial.this.get(this.index).signum() == 0) {
                    --this.index;
                }
            } else {
                while (this.index <= UnivariatePolynomial.this.degree && UnivariatePolynomial.this.get(this.index).signum() == 0) {
                    ++this.index;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.direction ? this.index > 0 : this.index <= UnivariatePolynomial.this.degree;
        }

        public Object next() {
            Term term = this.direction ? UnivariatePolynomial.this.term(--this.index) : UnivariatePolynomial.this.term(this.index++);
            this.seek();
            return term;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

