/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Literal;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.Term;

final class TreePolynomial
extends Polynomial {
    final SortedMap content = new TreeMap(this.ordering);
    int degree;
    boolean mutable = true;

    TreePolynomial(Monomial monomial, Generic generic) {
        super(monomial, generic);
    }

    @Override
    public int size() {
        return this.content.size();
    }

    @Override
    public Iterator iterator(boolean bl, Monomial monomial) {
        return new ContentIterator(bl, monomial);
    }

    Term term(Map.Entry entry) {
        return new Term((Monomial)entry.getKey(), (Generic)entry.getValue());
    }

    Term term(Monomial monomial) {
        return new Term(monomial, null){

            @Override
            public Generic coef() {
                return this.coef == null ? TreePolynomial.this.coefficient(this.monomial) : this.coef;
            }
        };
    }

    SortedMap subContent(Monomial monomial, boolean bl) {
        if (monomial == null) {
            return this.content;
        }
        return bl ? this.content.headMap(monomial) : this.content.tailMap(monomial);
    }

    @Override
    public Polynomial subtract(Polynomial polynomial) {
        if (polynomial.signum() == 0) {
            return this;
        }
        if (this.mutable) {
            TreePolynomial treePolynomial = (TreePolynomial)polynomial;
            for (Map.Entry entry : treePolynomial.content.entrySet()) {
                Monomial monomial = (Monomial)entry.getKey();
                Generic generic = (Generic)entry.getValue();
                Generic generic2 = this.coefficient(monomial).subtract(generic);
                if (generic2.signum() == 0) {
                    this.content.remove(monomial);
                    continue;
                }
                this.content.put(monomial, generic2);
            }
            this.degree = TreePolynomial.degree(this);
            this.sugar = Math.max(this.sugar, treePolynomial.sugar);
            this.normalized = false;
            return this;
        }
        return this.copy().subtract(polynomial);
    }

    @Override
    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        if (generic.signum() == 0) {
            return this;
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this.subtract(polynomial);
        }
        if (this.mutable) {
            TreePolynomial treePolynomial = (TreePolynomial)polynomial;
            for (Map.Entry entry : treePolynomial.content.entrySet()) {
                Monomial monomial = (Monomial)entry.getKey();
                Generic generic2 = ((Generic)entry.getValue()).multiply(generic);
                Generic generic3 = this.coefficient(monomial).subtract(generic2);
                if (generic3.signum() == 0) {
                    this.content.remove(monomial);
                    continue;
                }
                this.content.put(monomial, generic3);
            }
            this.degree = TreePolynomial.degree(this);
            this.sugar = Math.max(this.sugar, treePolynomial.sugar);
            this.normalized = false;
            return this;
        }
        return this.copy().multiplyAndSubtract(generic, polynomial);
    }

    @Override
    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        if (generic.signum() == 0) {
            return this;
        }
        if (monomial.degree() == 0) {
            return this.multiplyAndSubtract(generic, polynomial);
        }
        if (this.mutable) {
            TreePolynomial treePolynomial = (TreePolynomial)polynomial;
            for (Map.Entry entry : treePolynomial.content.entrySet()) {
                Monomial monomial2 = ((Monomial)entry.getKey()).multiply(monomial);
                Generic generic2 = ((Generic)entry.getValue()).multiply(generic);
                Generic generic3 = this.coefficient(monomial2).subtract(generic2);
                if (generic3.signum() == 0) {
                    this.content.remove(monomial2);
                    continue;
                }
                this.content.put(monomial2, generic3);
            }
            this.degree = TreePolynomial.degree(this);
            this.sugar = Math.max(this.sugar, treePolynomial.sugar + monomial.degree());
            this.normalized = false;
            return this;
        }
        return this.copy().multiplyAndSubtract(monomial, generic, polynomial);
    }

    @Override
    public Polynomial multiply(Generic generic) {
        if (generic.signum() == 0) {
            return this.valueof(JSCLInteger.valueOf(0L));
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        if (this.mutable) {
            for (Map.Entry entry : this.content.entrySet()) {
                entry.setValue(((Generic)entry.getValue()).multiply(generic));
            }
            this.normalized = false;
            return this;
        }
        return this.copy().multiply(generic);
    }

    @Override
    public Polynomial multiply(Monomial monomial) {
        if (this.defined) {
            TreePolynomial treePolynomial = this.newinstance();
            for (Map.Entry entry : this.content.entrySet()) {
                Monomial monomial2 = ((Monomial)entry.getKey()).multiply(monomial);
                Generic generic = (Generic)entry.getValue();
                Generic generic2 = treePolynomial.coefficient(monomial2).add(generic);
                if (generic2.signum() == 0) {
                    treePolynomial.content.remove(monomial2);
                    continue;
                }
                treePolynomial.content.put(monomial2, generic2);
            }
            treePolynomial.degree = TreePolynomial.degree(treePolynomial);
            treePolynomial.sugar = this.sugar + monomial.degree();
            return treePolynomial;
        }
        if (monomial.degree() == 0) {
            return this;
        }
        TreePolynomial treePolynomial = this.newinstance();
        for (Map.Entry entry : this.content.entrySet()) {
            treePolynomial.content.put(((Monomial)entry.getKey()).multiply(monomial), (Generic)entry.getValue());
        }
        treePolynomial.degree = this.degree + monomial.degree();
        treePolynomial.sugar = this.sugar + monomial.degree();
        return treePolynomial;
    }

    @Override
    public Polynomial divide(Generic generic) throws ArithmeticException {
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        if (this.mutable) {
            for (Map.Entry entry : this.content.entrySet()) {
                entry.setValue(((Generic)entry.getValue()).divide(generic));
            }
            this.normalized = false;
            return this;
        }
        return this.copy().divide(generic);
    }

    @Override
    public Polynomial divide(Monomial monomial) throws ArithmeticException {
        if (monomial.degree() == 0) {
            return this;
        }
        TreePolynomial treePolynomial = this.newinstance();
        for (Map.Entry entry : this.content.entrySet()) {
            treePolynomial.content.put(((Monomial)entry.getKey()).divide(monomial), (Generic)entry.getValue());
        }
        treePolynomial.degree = this.degree + monomial.degree();
        treePolynomial.sugar = this.sugar + monomial.degree();
        return treePolynomial;
    }

    @Override
    public Polynomial gcd(Polynomial polynomial) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int degree() {
        return this.degree;
    }

    @Override
    public Polynomial valueof(Polynomial polynomial) {
        TreePolynomial treePolynomial = this.newinstance();
        treePolynomial.init(polynomial);
        return treePolynomial;
    }

    @Override
    public Polynomial valueof(Generic generic) {
        TreePolynomial treePolynomial = this.newinstance();
        treePolynomial.init(generic);
        return treePolynomial;
    }

    @Override
    public Polynomial valueof(Monomial monomial) {
        TreePolynomial treePolynomial = this.newinstance();
        treePolynomial.init(monomial);
        return treePolynomial;
    }

    @Override
    public Polynomial freeze() {
        this.mutable = false;
        return this;
    }

    @Override
    public Term head() {
        return this.content.size() > 0 ? this.term((Monomial)this.content.lastKey()) : null;
    }

    @Override
    public Term tail() {
        return this.content.size() > 0 ? this.term((Monomial)this.content.firstKey()) : null;
    }

    @Override
    public Generic coefficient(Monomial monomial) {
        Generic generic = (Generic)this.content.get(monomial);
        return generic == null ? this.coefficient(JSCLInteger.valueOf(0L)) : generic;
    }

    void init(Polynomial polynomial) {
        TreePolynomial treePolynomial = (TreePolynomial)polynomial;
        this.content.putAll(treePolynomial.content);
        this.degree = treePolynomial.degree;
        this.sugar = treePolynomial.sugar;
    }

    void init(Expression expression) {
        int n = 0;
        int n2 = expression.size();
        for (int i = 0; i < n2; ++i) {
            Literal literal = expression.literal(i);
            JSCLInteger jSCLInteger = expression.coef(i);
            Monomial monomial = this.monomial(literal);
            Generic generic = this.coefficient((literal = literal.divide(monomial.literalValue())).degree() > 0 ? jSCLInteger.multiply(Expression.valueOf(literal)) : jSCLInteger);
            Generic generic2 = this.coefficient(monomial);
            Generic generic3 = generic2.add(generic);
            if (generic3.signum() == 0) {
                this.content.remove(monomial);
            } else {
                this.content.put(monomial, generic3);
            }
            n = Math.max(n, monomial.degree());
        }
        this.degree = TreePolynomial.degree(this);
        this.sugar = n;
    }

    void init(Generic generic) {
        if (generic instanceof Expression) {
            this.init((Expression)generic);
        } else {
            Generic generic2 = this.coefficient(generic);
            if (generic2.signum() != 0) {
                this.content.put(this.monomial(Literal.valueOf()), generic2);
            }
            this.degree = 0;
            this.sugar = 0;
        }
    }

    void init(Monomial monomial) {
        this.content.put(monomial, this.coefficient(JSCLInteger.valueOf(1L)));
        this.degree = monomial.degree();
        this.sugar = monomial.degree();
    }

    protected TreePolynomial newinstance() {
        return new TreePolynomial(this.monomialFactory, this.coefFactory);
    }

    class ContentIterator
    implements Iterator {
        final boolean direction;
        final Iterator iterator;
        SortedMap map;

        ContentIterator(boolean bl, Monomial monomial) {
            this.direction = bl;
            if (bl) {
                this.iterator = null;
                this.map = TreePolynomial.this.subContent(monomial, true);
            } else {
                this.iterator = TreePolynomial.this.subContent(monomial, false).entrySet().iterator();
                if (monomial != null && TreePolynomial.this.content.containsKey(monomial)) {
                    this.iterator.next();
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.direction ? this.map.size() > 0 : this.iterator.hasNext();
        }

        public Object next() {
            if (this.direction) {
                Monomial monomial = (Monomial)this.map.lastKey();
                this.map = TreePolynomial.this.content.headMap(monomial);
                return TreePolynomial.this.term(monomial);
            }
            return TreePolynomial.this.term((Map.Entry)this.iterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

