/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.polynomial.NestedPolynomial;
import jscl.math.polynomial.Polynomial;

final class PolynomialWrapper
extends Generic {
    final Polynomial content;

    PolynomialWrapper(Polynomial polynomial) {
        this.content = polynomial;
    }

    Polynomial content() {
        return this.content;
    }

    public PolynomialWrapper add(PolynomialWrapper polynomialWrapper) {
        return new PolynomialWrapper(this.content.add(polynomialWrapper.content));
    }

    @Override
    public Generic add(Generic generic) {
        if (generic instanceof PolynomialWrapper) {
            return this.add((PolynomialWrapper)generic);
        }
        return this.add(this.valueof(generic));
    }

    public PolynomialWrapper subtract(PolynomialWrapper polynomialWrapper) {
        return new PolynomialWrapper(this.content.subtract(polynomialWrapper.content));
    }

    @Override
    public Generic subtract(Generic generic) {
        if (generic instanceof PolynomialWrapper) {
            return this.subtract((PolynomialWrapper)generic);
        }
        return this.subtract(this.valueof(generic));
    }

    public PolynomialWrapper multiply(PolynomialWrapper polynomialWrapper) {
        return new PolynomialWrapper(this.content.multiply(polynomialWrapper.content));
    }

    @Override
    public Generic multiply(Generic generic) {
        if (generic instanceof PolynomialWrapper) {
            return this.multiply((PolynomialWrapper)generic);
        }
        return this.multiply(this.valueof(generic));
    }

    public PolynomialWrapper divide(PolynomialWrapper polynomialWrapper) throws ArithmeticException {
        return new PolynomialWrapper(this.content.divide(polynomialWrapper.content));
    }

    @Override
    public Generic divide(Generic generic) throws ArithmeticException {
        if (generic instanceof PolynomialWrapper) {
            return this.divide((PolynomialWrapper)generic);
        }
        return this.divide(this.valueof(generic));
    }

    public PolynomialWrapper gcd(PolynomialWrapper polynomialWrapper) {
        return new PolynomialWrapper(this.content.gcd(polynomialWrapper.content));
    }

    @Override
    public Generic gcd(Generic generic) {
        if (generic instanceof PolynomialWrapper) {
            return this.gcd((PolynomialWrapper)generic);
        }
        return this.gcd(this.valueof(generic));
    }

    @Override
    public Generic gcd() {
        return this.content.gcd();
    }

    @Override
    public Generic negate() {
        return new PolynomialWrapper(this.content.negate());
    }

    @Override
    public int signum() {
        return this.content.signum();
    }

    @Override
    public int degree() {
        return this.content.degree();
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        return null;
    }

    @Override
    public Generic derivative(Variable variable) {
        return null;
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        return null;
    }

    @Override
    public Generic function(Variable variable) {
        return null;
    }

    @Override
    public Generic expand() {
        return null;
    }

    @Override
    public Generic factorize() {
        return null;
    }

    @Override
    public Generic elementary() {
        return null;
    }

    @Override
    public Generic simplify() {
        return null;
    }

    @Override
    public Generic numeric() {
        return null;
    }

    @Override
    public Generic valueof(Generic generic) {
        if (generic instanceof PolynomialWrapper) {
            return new PolynomialWrapper(this.content.valueof(((PolynomialWrapper)generic).content));
        }
        return new PolynomialWrapper(this.content.valueof(generic));
    }

    @Override
    public Generic[] sumValue() {
        return null;
    }

    @Override
    public Generic[] productValue() throws NotProductException {
        return null;
    }

    @Override
    public Power powerValue() throws NotPowerException {
        return null;
    }

    @Override
    public Expression expressionValue() throws NotExpressionException {
        return this.content.genericValue().expressionValue();
    }

    @Override
    public JSCLInteger integerValue() throws NotIntegerException {
        throw new NotIntegerException();
    }

    @Override
    public Variable variableValue() throws NotVariableException {
        throw new NotVariableException();
    }

    @Override
    public Variable[] variables() {
        return new Variable[0];
    }

    @Override
    public boolean isPolynomial(Variable variable) {
        return false;
    }

    @Override
    public boolean isConstant(Variable variable) {
        return false;
    }

    public int compareTo(PolynomialWrapper polynomialWrapper) {
        return this.content.compareTo(polynomialWrapper.content);
    }

    @Override
    public int compareTo(Generic generic) {
        if (generic instanceof PolynomialWrapper) {
            return this.compareTo((PolynomialWrapper)generic);
        }
        return this.compareTo(this.valueof(generic));
    }

    public static Generic factory(Variable[] variableArray) {
        if (variableArray.length > 1) {
            Variable[] variableArray2 = new Variable[variableArray.length - 1];
            for (int i = 0; i < variableArray2.length; ++i) {
                variableArray2[i] = variableArray[i + 1];
            }
            return new PolynomialWrapper(NestedPolynomial.factory(variableArray2));
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.signum() < 0) {
            stringBuffer.append("-").append(this.negate());
        } else {
            stringBuffer.append("(").append(this.content).append(")");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        return "";
    }
}

