/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Collection;
import java.util.Iterator;
import jscl.math.Arithmetic;
import jscl.math.Expression;
import jscl.math.Field;
import jscl.math.Generic;
import jscl.math.GenericVariable;
import jscl.math.JSCLInteger;
import jscl.math.Literal;
import jscl.math.NotDivisibleException;
import jscl.math.Rational;
import jscl.math.Variable;
import jscl.math.polynomial.ArrayPolynomial;
import jscl.math.polynomial.ArrayPolynomialBoolean;
import jscl.math.polynomial.ArrayPolynomialGeneric;
import jscl.math.polynomial.ArrayPolynomialInteger;
import jscl.math.polynomial.ArrayPolynomialModular;
import jscl.math.polynomial.ArrayPolynomialRational;
import jscl.math.polynomial.DefinedBooleanMonomial;
import jscl.math.polynomial.GeoBucket;
import jscl.math.polynomial.JSCLBoolean;
import jscl.math.polynomial.ListPolynomial;
import jscl.math.polynomial.ModularInteger;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.NestedPolynomial;
import jscl.math.polynomial.Ordering;
import jscl.math.polynomial.Term;
import jscl.math.polynomial.TreePolynomial;
import jscl.math.polynomial.UnivariatePolynomial;

public abstract class Polynomial
implements Arithmetic,
Comparable {
    final Monomial monomialFactory;
    final Generic coefFactory;
    final Ordering ordering;
    final boolean defined;
    final boolean field;
    boolean normalized;
    int sugar;
    int index = -1;

    Polynomial(Monomial monomial, Generic generic) {
        this.monomialFactory = monomial;
        this.coefFactory = generic;
        this.ordering = monomial.ordering();
        this.defined = monomial instanceof DefinedBooleanMonomial;
        this.field = generic instanceof Field;
    }

    public abstract int size();

    public Ordering ordering() {
        return this.ordering;
    }

    public final Iterator iterator() {
        return this.iterator(false);
    }

    public final Iterator iterator(boolean bl) {
        return this.iterator(bl, null);
    }

    public final Iterator iterator(Monomial monomial) {
        return this.iterator(true, monomial);
    }

    public abstract Iterator iterator(boolean var1, Monomial var2);

    public Polynomial add(Polynomial polynomial) {
        return this.multiplyAndSubtract(this.coefficient(JSCLInteger.valueOf(-1L)), polynomial);
    }

    public abstract Polynomial subtract(Polynomial var1);

    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        return this.subtract(polynomial.multiply(generic));
    }

    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        return this.subtract(polynomial.multiply(monomial).multiply(generic));
    }

    public Polynomial multiply(Polynomial polynomial) {
        Polynomial polynomial2 = this.valueof(JSCLInteger.valueOf(0L));
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Term term = (Term)iterator.next();
            polynomial2 = polynomial2.multiplyAndSubtract(term.monomial(), term.coef().negate(), polynomial);
        }
        return polynomial2;
    }

    public abstract Polynomial multiply(Generic var1);

    public abstract Polynomial multiply(Monomial var1);

    public boolean multiple(Polynomial polynomial) throws ArithmeticException {
        return this.remainder(polynomial).signum() == 0;
    }

    public Polynomial divide(Polynomial polynomial) throws ArithmeticException {
        Polynomial[] polynomialArray = this.divideAndRemainder(polynomial);
        if (polynomialArray[1].signum() == 0) {
            return polynomialArray[0];
        }
        throw new NotDivisibleException();
    }

    public abstract Polynomial divide(Generic var1) throws ArithmeticException;

    public abstract Polynomial divide(Monomial var1) throws ArithmeticException;

    @Override
    public Arithmetic add(Arithmetic arithmetic) {
        return this.add((Polynomial)arithmetic);
    }

    @Override
    public Arithmetic subtract(Arithmetic arithmetic) {
        return this.subtract((Polynomial)arithmetic);
    }

    @Override
    public Arithmetic multiply(Arithmetic arithmetic) {
        return this.multiply((Polynomial)arithmetic);
    }

    @Override
    public Arithmetic divide(Arithmetic arithmetic) throws ArithmeticException {
        return this.divide((Polynomial)arithmetic);
    }

    public Polynomial[] divideAndRemainder(Polynomial polynomial) throws ArithmeticException {
        Polynomial[] polynomialArray = new Polynomial[]{this.valueof(JSCLInteger.valueOf(0L)), this};
        Polynomial polynomial2 = polynomial;
        Iterator iterator = polynomialArray[1].iterator(true);
        while (iterator.hasNext()) {
            Monomial monomial;
            Term term = (Term)iterator.next();
            Monomial monomial2 = term.monomial();
            if (!monomial2.multiple(monomial = polynomial2.head().monomial())) continue;
            Monomial monomial3 = monomial2.divide(monomial);
            Generic generic = term.coef();
            Generic generic2 = polynomial2.head().coef();
            Generic generic3 = generic.divide(generic2);
            polynomialArray[0] = polynomialArray[0].multiplyAndSubtract(monomial3, generic3, this.valueof(JSCLInteger.valueOf(-1L)));
            polynomialArray[1] = polynomialArray[1].multiplyAndSubtract(monomial3, generic3, polynomial2);
            iterator = polynomialArray[1].iterator(true);
        }
        return polynomialArray;
    }

    public Polynomial remainder(Polynomial polynomial) throws ArithmeticException {
        return this.divideAndRemainder(polynomial)[1];
    }

    public Polynomial remainderUpToCoefficient(Polynomial polynomial) throws ArithmeticException {
        Polynomial polynomial2 = this;
        Polynomial polynomial3 = polynomial;
        Iterator iterator = polynomial2.iterator(true);
        while (iterator.hasNext()) {
            Monomial monomial;
            Term term = (Term)iterator.next();
            Monomial monomial2 = term.monomial();
            if (!monomial2.multiple(monomial = polynomial3.head().monomial())) continue;
            Monomial monomial3 = monomial2.divide(monomial);
            Generic generic = term.coef();
            Generic generic2 = polynomial3.head().coef();
            polynomial2 = polynomial2.multiply(generic2).multiplyAndSubtract(monomial3, generic, polynomial3);
            iterator = polynomial2.iterator(true);
        }
        return polynomial2;
    }

    public abstract Polynomial gcd(Polynomial var1);

    public Polynomial scm(Polynomial polynomial) {
        return this.divide(this.gcd(polynomial)).multiply(polynomial);
    }

    public Generic gcd() {
        if (this.field) {
            return this.coefficient(this.tail());
        }
        Generic generic = this.coefficient(JSCLInteger.valueOf(0L));
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            generic = generic.gcd(((Term)iterator.next()).coef());
        }
        return generic.signum() == this.signum() ? generic : generic.negate();
    }

    public final Polynomial[] gcdAndNormalize() {
        Generic generic = this.gcd();
        return new Polynomial[]{this.valueof(generic), generic.signum() == 0 ? this : this.divide(generic)};
    }

    public final Polynomial normalize() {
        if (this.normalized) {
            return this;
        }
        Polynomial polynomial = this.gcdAndNormalize()[1];
        polynomial.normalized = true;
        return polynomial;
    }

    public Monomial monomialGcd() {
        Monomial monomial = this.monomial(this.tail());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            monomial = monomial.gcd(((Term)iterator.next()).monomial());
        }
        return monomial;
    }

    public Polynomial pow(int n) {
        Polynomial polynomial;
        if (n < 0) {
            throw new ArithmeticException();
        }
        if (n == 0) {
            polynomial = this.valueof(JSCLInteger.valueOf(1L));
        } else if (n % 2 == 0) {
            Polynomial polynomial2 = this.pow(n / 2);
            polynomial = polynomial2.multiply(polynomial2);
        } else {
            polynomial = this.multiply(this.pow(n - 1));
        }
        return polynomial;
    }

    public Polynomial abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public Polynomial negate() {
        return this.multiply(this.coefficient(JSCLInteger.valueOf(-1L)));
    }

    public final int signum() {
        return this.coefficient(this.tail()).signum();
    }

    static int degree(Polynomial polynomial) {
        return polynomial.monomial(polynomial.head()).degree();
    }

    public abstract int degree();

    public abstract Polynomial valueof(Polynomial var1);

    public abstract Polynomial valueof(Generic var1);

    public abstract Polynomial valueof(Monomial var1);

    public final Polynomial copy() {
        return this.valueof(this);
    }

    public abstract Polynomial freeze();

    public Term head() {
        Iterator iterator = this.iterator(true);
        return iterator.hasNext() ? (Term)iterator.next() : null;
    }

    public Term tail() {
        Iterator iterator = this.iterator();
        return iterator.hasNext() ? (Term)iterator.next() : null;
    }

    public Generic coefficient(Monomial monomial) {
        Iterator iterator = this.iterator(false, monomial);
        Term term = iterator.hasNext() ? (Term)iterator.next() : null;
        return this.coefficient(term == null || this.ordering.compare(term.monomial(), monomial) == 0 ? term : null);
    }

    Monomial monomial(Term term) {
        return term == null ? this.monomial(Literal.valueOf()) : term.monomial();
    }

    Generic coefficient(Term term) {
        return term == null ? this.coefficient(JSCLInteger.valueOf(0L)) : term.coef();
    }

    protected Monomial monomial(Literal literal) {
        return this.monomialFactory.valueof(literal);
    }

    protected Generic coefficient(Generic generic) {
        return this.coefFactory == null ? generic : this.coefFactory.valueof(generic);
    }

    public Polynomial reduce(Collection collection, boolean bl) {
        Iterator iterator;
        Polynomial polynomial = this;
        Iterator iterator2 = iterator = bl ? polynomial.iterator(polynomial.head().monomial()) : polynomial.iterator(true);
        block0: while (iterator.hasNext()) {
            Term term = (Term)iterator.next();
            Monomial monomial = term.monomial();
            for (Polynomial polynomial2 : collection) {
                Monomial monomial2 = polynomial2.head().monomial();
                if (!monomial.multiple(monomial2)) continue;
                Monomial monomial3 = monomial.divide(monomial2);
                polynomial = polynomial.reduce(term.coef(), monomial3, polynomial2);
                iterator = bl ? polynomial.iterator(monomial) : polynomial.iterator(true);
                continue block0;
            }
            bl = true;
        }
        return polynomial;
    }

    public Polynomial reduce(Generic generic, Monomial monomial, Polynomial polynomial) {
        if (this.field) {
            return this.multiplyAndSubtract(monomial, generic.divide(polynomial.head().coef()), polynomial);
        }
        Generic generic2 = generic;
        Generic generic3 = polynomial.head().coef();
        Generic generic4 = generic2.gcd(generic3);
        generic2 = generic2.divide(generic4);
        generic3 = generic3.divide(generic4);
        return this.multiply(generic3).multiplyAndSubtract(monomial, generic2, polynomial).normalize();
    }

    public Polynomial reduce(Generic generic, Polynomial polynomial) {
        return this.reduce(generic, this.monomial(Literal.valueOf()), polynomial);
    }

    public int sugar() {
        return this.sugar;
    }

    public int index() {
        return this.index;
    }

    public void setSugar(int n) {
        this.sugar = n;
    }

    public void setIndex(int n) {
        if (this.index != -1) {
            throw new ArithmeticException();
        }
        this.index = n;
    }

    public Generic genericValue() {
        Generic generic = JSCLInteger.valueOf(0L);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Term term = (Term)iterator.next();
            Monomial monomial = term.monomial();
            Expression expression = term.coef().expressionValue();
            generic = ((Generic)generic).add(monomial.degree() > 0 ? ((Generic)expression).multiply(Expression.valueOf(monomial.literalValue())) : expression);
        }
        return generic;
    }

    public Generic[] elements() {
        int n = this.size();
        Generic[] genericArray = new Generic[n];
        Iterator iterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            genericArray[i] = ((Term)iterator.next()).coef();
        }
        return genericArray;
    }

    public static Polynomial factory(Variable variable) {
        return new UnivariatePolynomial(variable);
    }

    public static Polynomial factory(Variable[] variableArray) {
        return new NestedPolynomial(variableArray);
    }

    public static Polynomial factory(Variable[] variableArray, Ordering ordering) {
        return Polynomial.factory(variableArray, ordering, 0);
    }

    public static Polynomial factory(Variable[] variableArray, Ordering ordering, int n) {
        return Polynomial.factory(variableArray, ordering, n, 0);
    }

    public static Polynomial factory(Variable[] variableArray, Ordering ordering, int n, int n2) {
        return Polynomial.factory(Monomial.factory(variableArray, ordering, n2 & 0x30), n, n2 & 3, (n2 & 0x40) > 0);
    }

    static Polynomial factory(Monomial monomial, int n, int n2, boolean bl) {
        if (bl) {
            return new GeoBucket(Polynomial.factory(monomial, n, n2, false));
        }
        switch (n2) {
            case 1: {
                return new ArrayPolynomial(monomial, Polynomial.generic(n));
            }
            case 2: {
                return new TreePolynomial(monomial, Polynomial.generic(n));
            }
            case 3: {
                return new ListPolynomial(monomial, Polynomial.generic(n));
            }
        }
        switch (n) {
            case -1: {
                return new ArrayPolynomialGeneric(monomial, null);
            }
            case 0: {
                return new ArrayPolynomialInteger(monomial);
            }
            case 1: {
                return new ArrayPolynomialRational(monomial);
            }
            case 2: {
                return new ArrayPolynomialBoolean(monomial);
            }
        }
        return new ArrayPolynomialModular(monomial, ModularInteger.factory(n));
    }

    static Generic generic(int n) {
        switch (n) {
            case -1: {
                return null;
            }
            case 0: {
                return JSCLInteger.factory;
            }
            case 1: {
                return Rational.factory;
            }
            case 2: {
                return JSCLBoolean.factory;
            }
        }
        return ModularInteger.factory(n);
    }

    static Polynomial factory(Polynomial polynomial, int n) {
        Monomial monomial = polynomial.monomialFactory;
        return Polynomial.factory(monomial.unknown(), monomial.ordering(), n);
    }

    public int compareTo(Polynomial polynomial) {
        Term term;
        Iterator iterator = this.iterator(true);
        Iterator iterator2 = polynomial.iterator(true);
        Term term2 = iterator.hasNext() ? (Term)iterator.next() : null;
        Term term3 = term = iterator2.hasNext() ? (Term)iterator2.next() : null;
        while (term2 != null || term != null) {
            int n;
            int n2 = term2 == null ? 1 : (n = term == null ? -1 : this.ordering.compare(term2.monomial(), term.monomial()));
            if (n < 0) {
                return -1;
            }
            if (n > 0) {
                return 1;
            }
            n = term2.coef().compareTo(term.coef());
            if (n < 0) {
                return -1;
            }
            if (n > 0) {
                return 1;
            }
            term2 = iterator.hasNext() ? (Term)iterator.next() : null;
            term = iterator2.hasNext() ? (Term)iterator2.next() : null;
        }
        return 0;
    }

    public int compareTo(Object object) {
        return this.compareTo((Polynomial)object);
    }

    public boolean equals(Object object) {
        if (object instanceof Polynomial) {
            return this.compareTo((Polynomial)object) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.signum() == 0) {
            stringBuffer.append("0");
        }
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Term term = (Term)iterator.next();
            Monomial monomial = term.monomial();
            Generic generic = term.coef();
            if (generic instanceof Expression) {
                Generic generic2 = generic = generic.signum() > 0 ? GenericVariable.valueOf(generic).expressionValue() : GenericVariable.valueOf(generic.negate()).expressionValue().negate();
            }
            if (generic.signum() > 0 && n > 0) {
                stringBuffer.append("+");
            }
            if (monomial.degree() == 0) {
                stringBuffer.append(generic);
            } else {
                if (generic.abs().compareTo(JSCLInteger.valueOf(1L)) == 0) {
                    if (generic.signum() < 0) {
                        stringBuffer.append("-");
                    }
                } else {
                    stringBuffer.append(generic).append("*");
                }
                stringBuffer.append(monomial);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toMathML() {
        String string = "<cn>0</cn>";
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            String string2;
            Term term = (Term)iterator.next();
            Monomial monomial = term.monomial();
            Generic generic = term.coef();
            if (generic instanceof Expression) {
                generic = generic.signum() > 0 ? GenericVariable.valueOf(generic).expressionValue() : GenericVariable.valueOf(generic.negate()).expressionValue().negate();
            }
            Generic generic2 = generic.abs();
            String string3 = monomial.degree() == 0 ? generic2.toMathML() : (string2 = generic2.compareTo(JSCLInteger.valueOf(1L)) == 0 ? monomial.toMathML() : "<apply><times/>" + generic2.toMathML() + monomial.toMathML() + "</apply>");
            string = n == 0 ? (generic.signum() < 0 ? "<apply><minus/>" + string2 + "</apply>" : string2) : (generic.signum() < 0 ? "<apply><minus/>" + string + string2 + "</apply>" : "<apply><plus/>" + string + string2 + "</apply>");
            ++n;
        }
        return string;
    }
}

