/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.MonomialIterator;

class MonomialDivisor
extends MonomialIterator {
    MonomialDivisor(Monomial monomial, Monomial monomial2) {
        super(monomial, monomial2);
        if (this.hasNext()) {
            this.seek();
        }
    }

    void seek() {
        int n = this.current.element.length;
        while (n > 0 && this.current.element[--n] <= this.monomial.element[n]) {
        }
        int n2 = n;
        while (n > 0) {
            int n3 = n2;
            this.current.element[n3] = this.current.element[n3] + this.current.element[--n];
            this.current.element[n] = 0;
        }
        if (n2 < this.current.element.length && this.current.element[n2] > this.monomial.element[n2]) {
            this.increment();
        }
    }

    @Override
    void increment() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.current.element.length && this.current.element[n] == 0; ++n) {
        }
        if (n < this.current.element.length) {
            n2 = this.current.element[n];
            this.current.element[n] = 0;
            ++n;
        }
        while (n < this.current.element.length && this.current.element[n] == this.monomial.element[n]) {
            n2 += this.current.element[n];
            this.current.element[n] = 0;
            ++n;
        }
        if (n < this.current.element.length) {
            int n3 = n;
            this.current.element[n3] = this.current.element[n3] + 1;
            this.fill(n2 - 1);
        } else {
            ++this.current.degree;
            this.fill(n2 + 1);
        }
    }

    private void fill(int n) {
        int n2 = 0;
        while (n2 < this.current.element.length) {
            int n3 = Math.min(this.monomial.element[n2] - this.current.element[n2], n);
            int n4 = n2++;
            this.current.element[n4] = this.current.element[n4] + n3;
            n -= n3;
        }
    }
}

