/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Iterator;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.Term;

final class GeoBucket
extends Polynomial {
    final Polynomial factory;
    Polynomial[] content;
    int size;
    boolean mutable = true;
    boolean canonicalized = true;

    GeoBucket(Polynomial polynomial) {
        super(polynomial.monomialFactory, polynomial.coefFactory);
        this.factory = polynomial;
    }

    GeoBucket(int n, Polynomial polynomial) {
        this(polynomial);
        this.init(n);
    }

    @Override
    public int size() {
        return this.size;
    }

    void init(int n) {
        this.content = new Polynomial[n];
        this.size = n;
    }

    void resize(int n) {
        Polynomial[] polynomialArray = new Polynomial[n];
        System.arraycopy(this.content, 0, polynomialArray, 0, Math.min(this.size, n));
        this.content = polynomialArray;
        this.size = n;
    }

    @Override
    public Iterator iterator(boolean bl, Monomial monomial) {
        return new ContentIterator(bl, monomial);
    }

    Term behead(Term term, int n, int n2) {
        Monomial monomial = term.monomial();
        Polynomial polynomial = this.factory.valueof(monomial).multiply(term.coef());
        this.content[n] = this.content[n].subtract(polynomial);
        this.content[n2] = this.content[n2].add(polynomial);
        return new Term(monomial, this.content[n2].coefficient(monomial));
    }

    void canonicalize() {
        Polynomial polynomial = this.factory.valueof(JSCLInteger.valueOf(0L));
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            Polynomial polynomial2 = this.content[i];
            if (polynomial2 == null) continue;
            polynomial = polynomial.add(polynomial2);
            n = Math.max(n, polynomial2.sugar());
            this.content[i] = null;
        }
        this.resize(GeoBucket.log(polynomial.size()) + 1);
        this.set(polynomial.normalize());
        this.canonicalized = true;
        this.setSugar(n);
        this.mutable = false;
    }

    static int log(int n) {
        int n2 = 0;
        while (n > 3) {
            ++n2;
            n >>= 2;
        }
        return n2;
    }

    Polynomial polynomial() {
        if (this.canonicalized) {
            return this.content[this.size - 1];
        }
        throw new UnsupportedOperationException();
    }

    void set(Polynomial polynomial) {
        this.content[this.size - 1] = polynomial;
    }

    @Override
    public Polynomial subtract(Polynomial polynomial) {
        if (this.mutable) {
            Polynomial polynomial2;
            Polynomial polynomial3 = ((GeoBucket)polynomial).polynomial();
            int n = GeoBucket.log(polynomial3.size());
            if (n >= this.size) {
                this.resize(n + 1);
            }
            Polynomial polynomial4 = ((polynomial2 = this.content[n]) == null ? this.factory.valueof(JSCLInteger.valueOf(0L)) : polynomial2).subtract(polynomial3);
            this.content[n] = null;
            while (n < GeoBucket.log(polynomial4.size())) {
                if (++n >= this.size) {
                    this.resize(n + 1);
                }
                if ((polynomial2 = this.content[n]) != null) {
                    polynomial4 = polynomial2.add(polynomial4);
                }
                this.content[n] = null;
            }
            this.content[n] = polynomial4;
            this.canonicalized = false;
            this.normalized = false;
            return this;
        }
        return this.copy().subtract(polynomial);
    }

    @Override
    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        if (this.mutable) {
            Polynomial polynomial2;
            Polynomial polynomial3 = ((GeoBucket)polynomial).polynomial();
            int n = GeoBucket.log(polynomial3.size());
            if (n >= this.size) {
                this.resize(n + 1);
            }
            Polynomial polynomial4 = ((polynomial2 = this.content[n]) == null ? this.factory.valueof(JSCLInteger.valueOf(0L)) : polynomial2).multiplyAndSubtract(generic, polynomial3);
            this.content[n] = null;
            while (n < GeoBucket.log(polynomial4.size())) {
                if (++n >= this.size) {
                    this.resize(n + 1);
                }
                if ((polynomial2 = this.content[n]) != null) {
                    polynomial4 = polynomial2.add(polynomial4);
                }
                this.content[n] = null;
            }
            this.content[n] = polynomial4;
            this.canonicalized = false;
            this.normalized = false;
            return this;
        }
        return this.copy().multiplyAndSubtract(generic, polynomial);
    }

    @Override
    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        if (this.mutable) {
            Polynomial polynomial2;
            Polynomial polynomial3 = ((GeoBucket)polynomial).polynomial();
            int n = GeoBucket.log(polynomial3.size());
            if (n >= this.size) {
                this.resize(n + 1);
            }
            Polynomial polynomial4 = ((polynomial2 = this.content[n]) == null ? this.factory.valueof(JSCLInteger.valueOf(0L)) : polynomial2).multiplyAndSubtract(monomial, generic, polynomial3);
            this.content[n] = null;
            while (n < GeoBucket.log(polynomial4.size())) {
                if (++n >= this.size) {
                    this.resize(n + 1);
                }
                if ((polynomial2 = this.content[n]) != null) {
                    polynomial4 = polynomial2.add(polynomial4);
                }
                this.content[n] = null;
            }
            this.content[n] = polynomial4;
            this.canonicalized = false;
            this.normalized = false;
            return this;
        }
        return this.copy().multiplyAndSubtract(monomial, generic, polynomial);
    }

    @Override
    public Polynomial multiply(Generic generic) {
        if (this.mutable) {
            if (this.canonicalized) {
                this.set(this.polynomial().multiply(generic));
            } else {
                for (int i = 0; i < this.size; ++i) {
                    Polynomial polynomial = this.content[i];
                    if (polynomial == null) continue;
                    this.content[i] = polynomial.multiply(generic);
                }
            }
            this.normalized = false;
            return this;
        }
        return this.copy().multiply(generic);
    }

    @Override
    public Polynomial multiply(Monomial monomial) {
        if (this.mutable) {
            this.set(this.polynomial().multiply(monomial));
            return this;
        }
        return this.copy().multiply(monomial);
    }

    @Override
    public Polynomial divide(Generic generic) throws ArithmeticException {
        if (this.mutable) {
            if (this.canonicalized) {
                this.set(this.polynomial().divide(generic));
            } else {
                for (int i = 0; i < this.size; ++i) {
                    Polynomial polynomial = this.content[i];
                    if (polynomial == null) continue;
                    this.content[i] = polynomial.divide(generic);
                }
            }
            this.normalized = false;
            return this;
        }
        return this.copy().divide(generic);
    }

    @Override
    public Polynomial divide(Monomial monomial) throws ArithmeticException {
        if (this.mutable) {
            this.set(this.polynomial().divide(monomial));
            return this;
        }
        return this.copy().divide(monomial);
    }

    @Override
    public Polynomial gcd(Polynomial polynomial) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic gcd() {
        if (this.field) {
            return this.coefficient(this.tail());
        }
        return this.canonicalized ? this.polynomial().gcd() : this.coefficient(JSCLInteger.valueOf(0L));
    }

    @Override
    public int degree() {
        return this.polynomial().degree();
    }

    public Polynomial valueof(GeoBucket geoBucket) {
        return this.valueof(geoBucket.polynomial().copy());
    }

    @Override
    public Polynomial valueof(Polynomial polynomial) {
        if (polynomial instanceof GeoBucket) {
            return this.valueof((GeoBucket)polynomial);
        }
        GeoBucket geoBucket = new GeoBucket(GeoBucket.log(polynomial.size()) + 1, this.factory);
        geoBucket.set(polynomial);
        return geoBucket;
    }

    @Override
    public Polynomial valueof(Generic generic) {
        return this.valueof(this.factory.valueof(generic));
    }

    @Override
    public Polynomial valueof(Monomial monomial) {
        return this.valueof(this.factory.valueof(monomial));
    }

    @Override
    public Polynomial freeze() {
        this.canonicalize();
        return this;
    }

    @Override
    public Term head() {
        return this.canonicalized ? this.polynomial().head() : super.head();
    }

    @Override
    public Term tail() {
        return this.canonicalized ? this.polynomial().tail() : super.tail();
    }

    @Override
    public Generic coefficient(Monomial monomial) {
        return this.canonicalized ? this.polynomial().coefficient(monomial) : super.coefficient(monomial);
    }

    @Override
    public int sugar() {
        return this.polynomial().sugar();
    }

    @Override
    public int index() {
        return this.polynomial().index();
    }

    @Override
    public void setSugar(int n) {
        this.polynomial().setSugar(n);
    }

    @Override
    public void setIndex(int n) {
        this.polynomial().setIndex(n);
    }

    @Override
    public Generic genericValue() {
        return this.polynomial().genericValue();
    }

    @Override
    public Generic[] elements() {
        return this.polynomial().elements();
    }

    public int compareTo(GeoBucket geoBucket) {
        return this.polynomial().compareTo(geoBucket.polynomial());
    }

    @Override
    public int compareTo(Polynomial polynomial) {
        return this.compareTo((GeoBucket)polynomial);
    }

    @Override
    public String toString() {
        if (this.canonicalized) {
            return this.polynomial().toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.size; ++i) {
            Polynomial polynomial = this.content[i];
            stringBuffer.append(polynomial == null ? this.factory.valueof(JSCLInteger.valueOf(0L)) : polynomial).append(i < this.size - 1 ? ", " : "");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.canonicalized) {
            stringBuffer.append(this.polynomial().toMathML());
        } else {
            stringBuffer.append("<mfenced>");
            stringBuffer.append("<mtable>");
            for (int i = 0; i < this.size; ++i) {
                stringBuffer.append("<mtr>");
                stringBuffer.append("<mtd>");
                Polynomial polynomial = this.content[i];
                stringBuffer.append((polynomial == null ? this.factory.valueof(JSCLInteger.valueOf(0L)) : polynomial).toMathML());
                stringBuffer.append("</mtd>");
                stringBuffer.append("</mtr>");
            }
            stringBuffer.append("</mtable>");
            stringBuffer.append("</mfenced>");
        }
        return stringBuffer.toString();
    }

    class ContentIterator
    implements Iterator {
        final boolean direction;
        Term term;

        ContentIterator(boolean bl, Monomial monomial) {
            this.direction = bl;
            this.term = new Term(monomial, GeoBucket.this.coefficient(JSCLInteger.valueOf(0L)));
            this.seek();
        }

        void seek() {
            Term term;
            do {
                int n = 0;
                term = null;
                for (int i = 0; i < GeoBucket.this.size; ++i) {
                    Term term2;
                    Polynomial polynomial = GeoBucket.this.content[i];
                    if (polynomial == null) continue;
                    Iterator iterator = polynomial.iterator(this.direction, this.term.monomial());
                    Term term3 = term2 = iterator.hasNext() ? (Term)iterator.next() : null;
                    if (term2 == null) continue;
                    if (term == null || (this.direction ? -1 : 1) * GeoBucket.this.ordering.compare(term.monomial(), term2.monomial()) > 0) {
                        term = term2;
                        n = i;
                        continue;
                    }
                    if (GeoBucket.this.ordering.compare(term.monomial(), term2.monomial()) != 0) continue;
                    term = GeoBucket.this.behead(term, n, i);
                    n = i;
                }
            } while (term != null && term.coef().signum() == 0);
            this.term = term;
        }

        @Override
        public boolean hasNext() {
            return this.term != null;
        }

        public Object next() {
            Term term = this.term;
            this.seek();
            return term;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

