/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.math.BigInteger;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.polynomial.ArrayPolynomialGeneric;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;

class ArrayPolynomialInteger
extends ArrayPolynomialGeneric {
    BigInteger[] coef;

    ArrayPolynomialInteger(Monomial monomial) {
        super(monomial, JSCLInteger.factory);
    }

    ArrayPolynomialInteger(int n, Monomial monomial) {
        this(monomial);
        this.init(n);
    }

    @Override
    void init(int n) {
        this.monomial = new Monomial[n];
        this.coef = new BigInteger[n];
        this.size = n;
    }

    @Override
    void resize(int n) {
        int n2 = this.monomial.length;
        if (n < n2) {
            Monomial[] monomialArray = new Monomial[n];
            BigInteger[] bigIntegerArray = new BigInteger[n];
            System.arraycopy(this.monomial, n2 - n, monomialArray, 0, n);
            System.arraycopy(this.coef, n2 - n, bigIntegerArray, 0, n);
            this.monomial = monomialArray;
            this.coef = bigIntegerArray;
            this.size = n;
        }
    }

    @Override
    public Polynomial subtract(Polynomial polynomial) {
        Monomial monomial;
        if (polynomial.signum() == 0) {
            return this;
        }
        ArrayPolynomialInteger arrayPolynomialInteger = (ArrayPolynomialInteger)polynomial;
        ArrayPolynomialInteger arrayPolynomialInteger2 = (ArrayPolynomialInteger)this.newinstance(this.size + arrayPolynomialInteger.size);
        int n = arrayPolynomialInteger2.size;
        int n2 = this.size;
        int n3 = arrayPolynomialInteger.size;
        Monomial monomial2 = n2 > 0 ? this.monomial[--n2] : null;
        Monomial monomial3 = monomial = n3 > 0 ? arrayPolynomialInteger.monomial[--n3] : null;
        while (monomial2 != null || monomial != null) {
            BigInteger bigInteger;
            int n4;
            int n5 = monomial2 == null ? 1 : (n4 = monomial == null ? -1 : -this.ordering.compare(monomial2, monomial));
            if (n4 < 0) {
                bigInteger = this.coef[n2];
                arrayPolynomialInteger2.monomial[--n] = monomial2;
                arrayPolynomialInteger2.coef[n] = bigInteger;
                monomial2 = n2 > 0 ? this.monomial[--n2] : null;
                continue;
            }
            if (n4 > 0) {
                bigInteger = arrayPolynomialInteger.coef[n3].negate();
                arrayPolynomialInteger2.monomial[--n] = monomial;
                arrayPolynomialInteger2.coef[n] = bigInteger;
                monomial = n3 > 0 ? arrayPolynomialInteger.monomial[--n3] : null;
                continue;
            }
            bigInteger = this.coef[n2].subtract(arrayPolynomialInteger.coef[n3]);
            if (bigInteger.signum() != 0) {
                arrayPolynomialInteger2.monomial[--n] = monomial2;
                arrayPolynomialInteger2.coef[n] = bigInteger;
            }
            monomial2 = n2 > 0 ? this.monomial[--n2] : null;
            monomial = n3 > 0 ? arrayPolynomialInteger.monomial[--n3] : null;
        }
        arrayPolynomialInteger2.resize(arrayPolynomialInteger2.size - n);
        arrayPolynomialInteger2.degree = ArrayPolynomialInteger.degree(arrayPolynomialInteger2);
        arrayPolynomialInteger2.sugar = Math.max(this.sugar, arrayPolynomialInteger.sugar);
        return arrayPolynomialInteger2;
    }

    @Override
    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        Monomial monomial;
        if (generic.signum() == 0) {
            return this;
        }
        BigInteger bigInteger = generic.integerValue().content();
        if (bigInteger.compareTo(BigInteger.valueOf(1L)) == 0) {
            return this.subtract(polynomial);
        }
        ArrayPolynomialInteger arrayPolynomialInteger = (ArrayPolynomialInteger)polynomial;
        ArrayPolynomialInteger arrayPolynomialInteger2 = (ArrayPolynomialInteger)this.newinstance(this.size + arrayPolynomialInteger.size);
        int n = arrayPolynomialInteger2.size;
        int n2 = this.size;
        int n3 = arrayPolynomialInteger.size;
        Monomial monomial2 = n2 > 0 ? this.monomial[--n2] : null;
        Monomial monomial3 = monomial = n3 > 0 ? arrayPolynomialInteger.monomial[--n3] : null;
        while (monomial2 != null || monomial != null) {
            BigInteger bigInteger2;
            int n4;
            int n5 = monomial2 == null ? 1 : (n4 = monomial == null ? -1 : -this.ordering.compare(monomial2, monomial));
            if (n4 < 0) {
                bigInteger2 = this.coef[n2];
                arrayPolynomialInteger2.monomial[--n] = monomial2;
                arrayPolynomialInteger2.coef[n] = bigInteger2;
                monomial2 = n2 > 0 ? this.monomial[--n2] : null;
                continue;
            }
            if (n4 > 0) {
                bigInteger2 = arrayPolynomialInteger.coef[n3].multiply(bigInteger).negate();
                arrayPolynomialInteger2.monomial[--n] = monomial;
                arrayPolynomialInteger2.coef[n] = bigInteger2;
                monomial = n3 > 0 ? arrayPolynomialInteger.monomial[--n3] : null;
                continue;
            }
            bigInteger2 = this.coef[n2].subtract(arrayPolynomialInteger.coef[n3].multiply(bigInteger));
            if (bigInteger2.signum() != 0) {
                arrayPolynomialInteger2.monomial[--n] = monomial2;
                arrayPolynomialInteger2.coef[n] = bigInteger2;
            }
            monomial2 = n2 > 0 ? this.monomial[--n2] : null;
            monomial = n3 > 0 ? arrayPolynomialInteger.monomial[--n3] : null;
        }
        arrayPolynomialInteger2.resize(arrayPolynomialInteger2.size - n);
        arrayPolynomialInteger2.degree = ArrayPolynomialInteger.degree(arrayPolynomialInteger2);
        arrayPolynomialInteger2.sugar = Math.max(this.sugar, arrayPolynomialInteger.sugar);
        return arrayPolynomialInteger2;
    }

    @Override
    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        Monomial monomial2;
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (generic.signum() == 0) {
            return this;
        }
        if (monomial.degree() == 0) {
            return this.multiplyAndSubtract(generic, polynomial);
        }
        BigInteger bigInteger = generic.integerValue().content();
        ArrayPolynomialInteger arrayPolynomialInteger = (ArrayPolynomialInteger)polynomial;
        ArrayPolynomialInteger arrayPolynomialInteger2 = (ArrayPolynomialInteger)this.newinstance(this.size + arrayPolynomialInteger.size);
        int n = arrayPolynomialInteger2.size;
        int n2 = this.size;
        int n3 = arrayPolynomialInteger.size;
        Monomial monomial3 = n2 > 0 ? this.monomial[--n2] : null;
        Monomial monomial4 = monomial2 = n3 > 0 ? arrayPolynomialInteger.monomial[--n3].multiply(monomial) : null;
        while (monomial3 != null || monomial2 != null) {
            BigInteger bigInteger2;
            int n4;
            int n5 = monomial3 == null ? 1 : (n4 = monomial2 == null ? -1 : -this.ordering.compare(monomial3, monomial2));
            if (n4 < 0) {
                bigInteger2 = this.coef[n2];
                arrayPolynomialInteger2.monomial[--n] = monomial3;
                arrayPolynomialInteger2.coef[n] = bigInteger2;
                monomial3 = n2 > 0 ? this.monomial[--n2] : null;
                continue;
            }
            if (n4 > 0) {
                bigInteger2 = arrayPolynomialInteger.coef[n3].multiply(bigInteger).negate();
                arrayPolynomialInteger2.monomial[--n] = monomial2;
                arrayPolynomialInteger2.coef[n] = bigInteger2;
                monomial2 = n3 > 0 ? arrayPolynomialInteger.monomial[--n3].multiply(monomial) : null;
                continue;
            }
            bigInteger2 = this.coef[n2].subtract(arrayPolynomialInteger.coef[n3].multiply(bigInteger));
            if (bigInteger2.signum() != 0) {
                arrayPolynomialInteger2.monomial[--n] = monomial3;
                arrayPolynomialInteger2.coef[n] = bigInteger2;
            }
            monomial3 = n2 > 0 ? this.monomial[--n2] : null;
            monomial2 = n3 > 0 ? arrayPolynomialInteger.monomial[--n3].multiply(monomial) : null;
        }
        arrayPolynomialInteger2.resize(arrayPolynomialInteger2.size - n);
        arrayPolynomialInteger2.degree = ArrayPolynomialInteger.degree(arrayPolynomialInteger2);
        arrayPolynomialInteger2.sugar = Math.max(this.sugar, arrayPolynomialInteger.sugar + monomial.degree());
        return arrayPolynomialInteger2;
    }

    @Override
    public Polynomial multiply(Generic generic) {
        if (generic.signum() == 0) {
            return this.valueof(JSCLInteger.valueOf(0L));
        }
        BigInteger bigInteger = generic.integerValue().content();
        if (bigInteger.compareTo(BigInteger.valueOf(1L)) == 0) {
            return this;
        }
        ArrayPolynomialInteger arrayPolynomialInteger = (ArrayPolynomialInteger)this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            arrayPolynomialInteger.monomial[i] = this.monomial[i];
            arrayPolynomialInteger.coef[i] = this.coef[i].multiply(bigInteger);
        }
        arrayPolynomialInteger.degree = this.degree;
        arrayPolynomialInteger.sugar = this.sugar;
        return arrayPolynomialInteger;
    }

    @Override
    public Polynomial multiply(Monomial monomial) {
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (monomial.degree() == 0) {
            return this;
        }
        ArrayPolynomialInteger arrayPolynomialInteger = (ArrayPolynomialInteger)this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            arrayPolynomialInteger.monomial[i] = this.monomial[i].multiply(monomial);
            arrayPolynomialInteger.coef[i] = this.coef[i];
        }
        arrayPolynomialInteger.degree = this.degree + monomial.degree();
        arrayPolynomialInteger.sugar = this.sugar + monomial.degree();
        return arrayPolynomialInteger;
    }

    @Override
    public Polynomial divide(Generic generic) throws ArithmeticException {
        BigInteger bigInteger = generic.integerValue().content();
        if (bigInteger.compareTo(BigInteger.valueOf(1L)) == 0) {
            return this;
        }
        ArrayPolynomialInteger arrayPolynomialInteger = (ArrayPolynomialInteger)this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            arrayPolynomialInteger.monomial[i] = this.monomial[i];
            arrayPolynomialInteger.coef[i] = this.coef[i].divide(bigInteger);
        }
        arrayPolynomialInteger.degree = this.degree;
        arrayPolynomialInteger.sugar = this.sugar;
        return arrayPolynomialInteger;
    }

    @Override
    public Polynomial gcd(Polynomial polynomial) {
        return this.valueof(this.genericValue().gcd(polynomial.genericValue()));
    }

    @Override
    public Generic gcd() {
        BigInteger bigInteger = BigInteger.valueOf(0L);
        for (int i = this.size - 1; i >= 0 && (bigInteger = bigInteger.gcd(this.coef[i])).compareTo(BigInteger.valueOf(1L)) != 0; --i) {
        }
        return new JSCLInteger(bigInteger.signum() == this.signum() ? bigInteger : bigInteger.negate());
    }

    @Override
    protected Generic coefficient(Generic generic) {
        return this.coefFactory.valueof(generic);
    }

    @Override
    protected Generic getCoef(int n) {
        return new JSCLInteger(this.coef[n]);
    }

    @Override
    protected void setCoef(int n, Generic generic) {
        this.coef[n] = generic.integerValue().content();
    }

    @Override
    protected ArrayPolynomialGeneric newinstance(int n) {
        return new ArrayPolynomialInteger(n, this.monomialFactory);
    }
}

