/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.operator;

import jscl.math.Generic;
import jscl.math.GenericVariable;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.NotVariableException;
import jscl.math.Variable;
import jscl.math.function.Frac;
import jscl.math.function.Pow;
import jscl.math.operator.Operator;
import jscl.util.ArrayComparator;

public class Factorial
extends Operator {
    public Factorial(Generic generic) {
        super("", new Generic[]{generic});
    }

    @Override
    public Generic compute() {
        try {
            return this.parameter[0].integerValue().factorial();
        }
        catch (NotIntegerException notIntegerException) {
            return this.expressionValue();
        }
    }

    @Override
    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int n = comparator.compare(this, variable);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        Factorial factorial = (Factorial)variable;
        return ArrayComparator.comparator.compare(this.parameter, factorial.parameter);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            JSCLInteger jSCLInteger = this.parameter[0].integerValue();
            stringBuffer.append(jSCLInteger);
        }
        catch (NotIntegerException notIntegerException) {
            try {
                Variable variable = this.parameter[0].variableValue();
                if (variable instanceof Frac || variable instanceof Pow) {
                    stringBuffer.append(GenericVariable.valueOf(this.parameter[0]));
                } else {
                    stringBuffer.append(variable);
                }
            }
            catch (NotVariableException notVariableException) {
                stringBuffer.append(GenericVariable.valueOf(this.parameter[0]));
            }
        }
        stringBuffer.append("!");
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<apply><factorial/>");
        stringBuffer.append(this.parameter[0].toMathML());
        stringBuffer.append("</apply>");
        return stringBuffer.toString();
    }

    @Override
    protected Variable newinstance() {
        return new Factorial(null);
    }
}

