/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.numeric;

import jscl.math.numeric.JSCLDouble;
import jscl.math.numeric.Numeric;
import jscl.math.numeric.NumericVector;
import jscl.util.ArrayComparator;

public class NumericMatrix
extends Numeric {
    protected final Numeric[][] element;
    protected final int n;
    protected final int p;

    public NumericMatrix(Numeric[][] numericArray) {
        this.element = numericArray;
        this.n = numericArray.length;
        this.p = numericArray.length > 0 ? numericArray[0].length : 0;
    }

    public Numeric[][] elements() {
        return this.element;
    }

    public NumericMatrix add(NumericMatrix numericMatrix) {
        NumericMatrix numericMatrix2 = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                numericMatrix2.element[i][j] = this.element[i][j].add(numericMatrix.element[i][j]);
            }
        }
        return numericMatrix2;
    }

    @Override
    public Numeric add(Numeric numeric) {
        if (numeric instanceof NumericMatrix) {
            return this.add((NumericMatrix)numeric);
        }
        return this.add(this.valueof(numeric));
    }

    public NumericMatrix subtract(NumericMatrix numericMatrix) {
        NumericMatrix numericMatrix2 = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                numericMatrix2.element[i][j] = this.element[i][j].subtract(numericMatrix.element[i][j]);
            }
        }
        return numericMatrix2;
    }

    @Override
    public Numeric subtract(Numeric numeric) {
        if (numeric instanceof NumericMatrix) {
            return this.subtract((NumericMatrix)numeric);
        }
        return this.subtract(this.valueof(numeric));
    }

    public NumericMatrix multiply(NumericMatrix numericMatrix) {
        if (this.p != numericMatrix.n) {
            throw new ArithmeticException();
        }
        NumericMatrix numericMatrix2 = this.newinstance(new Numeric[this.n][numericMatrix.p]);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < numericMatrix.p; ++j) {
                numericMatrix2.element[i][j] = JSCLDouble.valueOf(0.0);
                for (int k = 0; k < this.p; ++k) {
                    numericMatrix2.element[i][j] = numericMatrix2.element[i][j].add(this.element[i][k].multiply(numericMatrix.element[k][j]));
                }
            }
        }
        return numericMatrix2;
    }

    @Override
    public Numeric multiply(Numeric numeric) {
        if (numeric instanceof NumericMatrix) {
            return this.multiply((NumericMatrix)numeric);
        }
        if (numeric instanceof NumericVector) {
            NumericVector numericVector = ((NumericVector)numeric).newinstance(new Numeric[this.n]);
            NumericVector numericVector2 = (NumericVector)numeric;
            if (this.p != numericVector2.n) {
                throw new ArithmeticException();
            }
            for (int i = 0; i < this.n; ++i) {
                numericVector.element[i] = JSCLDouble.valueOf(0.0);
                for (int j = 0; j < this.p; ++j) {
                    numericVector.element[i] = numericVector.element[i].add(this.element[i][j].multiply(numericVector2.element[j]));
                }
            }
            return numericVector;
        }
        NumericMatrix numericMatrix = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                numericMatrix.element[i][j] = this.element[i][j].multiply(numeric);
            }
        }
        return numericMatrix;
    }

    @Override
    public Numeric divide(Numeric numeric) throws ArithmeticException {
        if (numeric instanceof NumericMatrix) {
            return this.multiply(((NumericMatrix)numeric).inverse());
        }
        if (numeric instanceof NumericVector) {
            throw new ArithmeticException();
        }
        NumericMatrix numericMatrix = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                numericMatrix.element[i][j] = this.element[i][j].divide(numeric);
            }
        }
        return numericMatrix;
    }

    @Override
    public Numeric negate() {
        NumericMatrix numericMatrix = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                numericMatrix.element[i][j] = this.element[i][j].negate();
            }
        }
        return numericMatrix;
    }

    @Override
    public int signum() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                int n = this.element[i][j].signum();
                if (n < 0) {
                    return -1;
                }
                if (n <= 0) continue;
                return 1;
            }
        }
        return 0;
    }

    @Override
    public Numeric valueof(Numeric numeric) {
        if (numeric instanceof NumericMatrix || numeric instanceof NumericVector) {
            throw new ArithmeticException();
        }
        NumericMatrix numericMatrix = (NumericMatrix)NumericMatrix.identity(this.n, this.p).multiply(numeric);
        return this.newinstance(numericMatrix.element);
    }

    public Numeric[] vectors() {
        Numeric[] numericArray = new NumericVector[this.n];
        for (int i = 0; i < this.n; ++i) {
            numericArray[i] = new NumericVector(new Numeric[this.p]);
            for (int j = 0; j < this.p; ++j) {
                ((NumericVector)numericArray[i]).element[j] = this.element[i][j];
            }
        }
        return numericArray;
    }

    public Numeric transpose() {
        NumericMatrix numericMatrix = this.newinstance(new Numeric[this.p][this.n]);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                numericMatrix.element[j][i] = this.element[i][j];
            }
        }
        return numericMatrix;
    }

    public Numeric trace() {
        Numeric numeric = JSCLDouble.valueOf(0.0);
        for (int i = 0; i < this.n; ++i) {
            numeric = ((Numeric)numeric).add(this.element[i][i]);
        }
        return numeric;
    }

    @Override
    public Numeric inverse() {
        NumericMatrix numericMatrix = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                numericMatrix.element[i][j] = this.inverseElement(i, j);
            }
        }
        return numericMatrix.transpose().divide(this.determinant());
    }

    Numeric inverseElement(int n, int n2) {
        NumericMatrix numericMatrix = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                numericMatrix.element[i][j] = i == n ? JSCLDouble.valueOf(j == n2 ? 1.0 : 0.0) : this.element[i][j];
            }
        }
        return numericMatrix.determinant();
    }

    public Numeric determinant() {
        if (this.n > 1) {
            Numeric numeric = JSCLDouble.valueOf(0.0);
            for (int i = 0; i < this.n; ++i) {
                if (this.element[i][0].signum() == 0) continue;
                NumericMatrix numericMatrix = this.newinstance(new Numeric[this.n - 1][this.n - 1]);
                for (int j = 0; j < this.n - 1; ++j) {
                    for (int k = 0; k < this.n - 1; ++k) {
                        numericMatrix.element[j][k] = this.element[j < i ? j : j + 1][k + 1];
                    }
                }
                numeric = i % 2 == 0 ? ((Numeric)numeric).add(this.element[i][0].multiply(numericMatrix.determinant())) : ((Numeric)numeric).subtract(this.element[i][0].multiply(numericMatrix.determinant()));
            }
            return numeric;
        }
        if (this.n > 0) {
            return this.element[0][0];
        }
        return JSCLDouble.valueOf(0.0);
    }

    @Override
    public Numeric log() {
        throw new ArithmeticException();
    }

    @Override
    public Numeric exp() {
        throw new ArithmeticException();
    }

    @Override
    public Numeric conjugate() {
        NumericMatrix numericMatrix = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                numericMatrix.element[i][j] = this.element[i][j].conjugate();
            }
        }
        return numericMatrix;
    }

    public int compareTo(NumericMatrix numericMatrix) {
        return ArrayComparator.comparator.compare(this.vectors(), numericMatrix.vectors());
    }

    @Override
    public int compareTo(Numeric numeric) {
        if (numeric instanceof NumericMatrix) {
            return this.compareTo((NumericMatrix)numeric);
        }
        return this.compareTo(this.valueof(numeric));
    }

    public static NumericMatrix identity(int n) {
        return NumericMatrix.identity(n, n);
    }

    public static NumericMatrix identity(int n, int n2) {
        NumericMatrix numericMatrix = new NumericMatrix(new Numeric[n][n2]);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                numericMatrix.element[i][j] = i == j ? JSCLDouble.valueOf(1.0) : JSCLDouble.valueOf(0.0);
            }
        }
        return numericMatrix;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.n; ++i) {
            stringBuffer.append("{");
            for (int j = 0; j < this.p; ++j) {
                stringBuffer.append(this.element[i][j]).append(j < this.p - 1 ? ", " : "");
            }
            stringBuffer.append("}").append(i < this.n - 1 ? ",\n" : "");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<matrix>");
        for (int i = 0; i < this.n; ++i) {
            stringBuffer.append("<matrixrow>");
            for (int j = 0; j < this.p; ++j) {
                stringBuffer.append(this.element[i][j].toMathML());
            }
            stringBuffer.append("</matrixrow>");
        }
        stringBuffer.append("</matrix>");
        return stringBuffer.toString();
    }

    protected NumericMatrix newinstance() {
        return this.newinstance(new Numeric[this.n][this.p]);
    }

    protected NumericMatrix newinstance(Numeric[][] numericArray) {
        return new NumericMatrix(numericArray);
    }
}

