/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function.trigonometric;

import jscl.math.Function;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.function.Exp;
import jscl.math.function.Trigonometric;
import jscl.math.function.trigonometric.Asin;
import jscl.math.function.trigonometric.Cos;

public class Sin
extends Trigonometric {
    public Sin(Generic generic) {
        super("sin", new Generic[]{generic});
    }

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        return new Cos(this.parameter[0]).evaluate().negate();
    }

    @Override
    public Generic derivative(int n) {
        return new Cos(this.parameter[0]).evaluate();
    }

    @Override
    public Generic evaluate() {
        if (this.parameter[0].signum() < 0) {
            return new Sin(this.parameter[0].negate()).evaluate().negate();
        }
        if (this.parameter[0].signum() == 0) {
            return JSCLInteger.valueOf(0L);
        }
        if (this.parameter[0].compareTo(Constant.pi) == 0) {
            return JSCLInteger.valueOf(0L);
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalelem() {
        return new Exp(Constant.i.multiply(this.parameter[0])).evalelem().subtract(new Exp(Constant.i.multiply(this.parameter[0].negate())).evalelem()).multiply(Constant.i.negate().multiply(Constant.half));
    }

    @Override
    public Generic evalsimp() {
        if (this.parameter[0].signum() < 0) {
            return new Sin(this.parameter[0].negate()).evaluate().negate();
        }
        if (this.parameter[0].signum() == 0) {
            return JSCLInteger.valueOf(0L);
        }
        if (this.parameter[0].compareTo(Constant.pi) == 0) {
            return JSCLInteger.valueOf(0L);
        }
        try {
            Variable variable = this.parameter[0].variableValue();
            if (variable instanceof Asin) {
                Generic[] genericArray = ((Asin)variable).parameters();
                return genericArray[0];
            }
        }
        catch (NotVariableException notVariableException) {
            // empty catch block
        }
        return this.identity();
    }

    @Override
    public Generic identity(Generic generic, Generic generic2) {
        return new Cos(generic2).evalsimp().multiply(new Sin(generic).evalsimp()).add(new Cos(generic).evalsimp().multiply(new Sin(generic2).evalsimp()));
    }

    @Override
    public Generic evalfunc() {
        return ((Function)this.parameter[0]).sin();
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).sin();
    }

    @Override
    protected Variable newinstance() {
        return new Sin(null);
    }
}

