/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function.hyperbolic;

import jscl.math.Function;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Frac;
import jscl.math.function.Log;
import jscl.math.function.Trigonometric;
import jscl.math.function.hyperbolic.Acoth;
import jscl.math.function.hyperbolic.Cosh;
import jscl.math.function.hyperbolic.Sinh;

public class Coth
extends Trigonometric {
    public Coth(Generic generic) {
        super("coth", new Generic[]{generic});
    }

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        return new Log(JSCLInteger.valueOf(4L).multiply(new Sinh(this.parameter[0]).evaluate())).evaluate();
    }

    @Override
    public Generic derivative(int n) {
        return JSCLInteger.valueOf(1L).subtract(new Coth(this.parameter[0]).evaluate().pow(2));
    }

    @Override
    public Generic evaluate() {
        if (this.parameter[0].signum() < 0) {
            return new Coth(this.parameter[0].negate()).evaluate().negate();
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalelem() {
        return new Frac(new Cosh(this.parameter[0]).evalelem(), new Sinh(this.parameter[0]).evalelem()).evalelem();
    }

    @Override
    public Generic evalsimp() {
        if (this.parameter[0].signum() < 0) {
            return new Coth(this.parameter[0].negate()).evaluate().negate();
        }
        try {
            Variable variable = this.parameter[0].variableValue();
            if (variable instanceof Acoth) {
                Generic[] genericArray = ((Acoth)variable).parameters();
                return genericArray[0];
            }
        }
        catch (NotVariableException notVariableException) {
            // empty catch block
        }
        return this.identity();
    }

    @Override
    public Generic identity(Generic generic, Generic generic2) {
        Generic generic3 = new Coth(generic).evalsimp();
        Generic generic4 = new Coth(generic2).evalsimp();
        return new Frac(generic3.multiply(generic4).add(JSCLInteger.valueOf(1L)), generic3.add(generic4)).evalsimp();
    }

    @Override
    public Generic evalfunc() {
        return ((Function)this.parameter[0]).coth();
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).coth();
    }

    @Override
    protected Variable newinstance() {
        return new Coth(null);
    }
}

