/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Antiderivative;
import jscl.math.Function;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NumericWrapper;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.function.Algebraic;
import jscl.math.function.Constant;
import jscl.math.function.Frac;
import jscl.math.function.Inv;
import jscl.math.function.Root;

public class Sqrt
extends Algebraic {
    public Sqrt(Generic generic) {
        super("sqrt", new Generic[]{generic});
    }

    @Override
    public Root rootValue() {
        return new Root(new Generic[]{this.parameter[0].negate(), JSCLInteger.valueOf(0L), JSCLInteger.valueOf(1L)}, 0);
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        Root root = this.rootValue();
        Generic[] genericArray = root.parameters();
        if (genericArray[0].isPolynomial(variable)) {
            return Antiderivative.compute(root, variable);
        }
        throw new NotIntegrableException();
    }

    @Override
    public Generic derivative(int n) {
        return Constant.half.multiply(new Inv(this.evaluate()).evaluate());
    }

    public boolean imaginary() {
        return this.parameter[0].compareTo(JSCLInteger.valueOf(-1L)) == 0;
    }

    @Override
    public Generic evaluate() {
        try {
            JSCLInteger jSCLInteger;
            JSCLInteger jSCLInteger2 = this.parameter[0].integerValue();
            if (jSCLInteger2.signum() >= 0 && ((Generic)(jSCLInteger = jSCLInteger2.sqrt())).pow(2).compareTo(jSCLInteger2) == 0) {
                return jSCLInteger;
            }
        }
        catch (NotIntegerException notIntegerException) {
            // empty catch block
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalelem() {
        return this.evaluate();
    }

    @Override
    public Generic evalsimp() {
        try {
            JSCLInteger jSCLInteger = this.parameter[0].integerValue();
            if (jSCLInteger.signum() < 0) {
                return Constant.i.multiply(new Sqrt(jSCLInteger.negate()).evalsimp());
            }
            Generic generic = jSCLInteger.sqrt();
            if (generic.pow(2).compareTo(jSCLInteger) == 0) {
                return generic;
            }
            generic = jSCLInteger.factorize();
            Generic[] genericArray = generic.productValue();
            Generic generic2 = JSCLInteger.valueOf(1L);
            for (int i = 0; i < genericArray.length; ++i) {
                Power power = genericArray[i].powerValue();
                Generic generic3 = power.value();
                int n = power.exponent();
                generic2 = ((Generic)generic2).multiply(generic3.pow(n / 2).multiply(new Sqrt(generic3).expressionValue().pow(n % 2)));
            }
            return generic2;
        }
        catch (NotIntegerException notIntegerException) {
            Generic[] genericArray = Frac.separateCoefficient(this.parameter[0]);
            if (genericArray[0].compareTo(JSCLInteger.valueOf(1L)) != 0 || genericArray[1].compareTo(JSCLInteger.valueOf(1L)) != 0) {
                return new Sqrt(genericArray[2]).evalsimp().multiply(new Frac(new Sqrt(genericArray[0]).evalsimp(), new Sqrt(genericArray[1]).evalsimp()).evalsimp());
            }
            return this.expressionValue();
        }
    }

    @Override
    public Generic evalfunc() {
        return ((Function)this.parameter[0]).sqrt();
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).sqrt();
    }

    @Override
    public String toMathML() {
        if (this.parameter[0].compareTo(JSCLInteger.valueOf(-1L)) == 0) {
            return "<imaginaryi/>";
        }
        return "<apply><root/>" + this.parameter[0].toMathML() + "</apply>";
    }

    @Override
    protected Variable newinstance() {
        return new Sqrt(null);
    }
}

