/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.Variable;
import jscl.util.ArrayComparator;

public abstract class Function
extends Variable {
    protected final Generic[] parameter;

    public Function(String string, Generic[] genericArray) {
        super(string);
        this.parameter = genericArray;
    }

    public Generic[] parameters() {
        return this.parameter;
    }

    public abstract Generic evaluate();

    public abstract Generic evalelem();

    public abstract Generic evalsimp();

    public abstract Generic evalfunc();

    public abstract Generic evalnum();

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        int n = -1;
        for (int i = 0; i < this.parameter.length; ++i) {
            if (n == -1 && this.parameter[i].isIdentity(variable)) {
                n = i;
                continue;
            }
            if (this.parameter[i].isConstant(variable)) continue;
            n = -1;
            break;
        }
        if (n < 0) {
            throw new NotIntegrableException();
        }
        return this.antiderivative(n);
    }

    public abstract Generic antiderivative(int var1) throws NotIntegrableException;

    @Override
    public Generic derivative(Variable variable) {
        if (this.isIdentity(variable)) {
            return JSCLInteger.valueOf(1L);
        }
        Generic generic = JSCLInteger.valueOf(0L);
        for (int i = 0; i < this.parameter.length; ++i) {
            generic = ((Generic)generic).add(this.parameter[i].derivative(variable).multiply(this.derivative(i)));
        }
        return generic;
    }

    public abstract Generic derivative(int var1);

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        Function function = (Function)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            function.parameter[i] = this.parameter[i].substitute(variable, generic);
        }
        if (function.isIdentity(variable)) {
            return generic;
        }
        return function.evaluate();
    }

    @Override
    public Generic expand() {
        Function function = (Function)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            function.parameter[i] = this.parameter[i].expand();
        }
        return function.evaluate();
    }

    @Override
    public Generic factorize() {
        Function function = (Function)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            function.parameter[i] = this.parameter[i].factorize();
        }
        return function.expressionValue();
    }

    @Override
    public Generic elementary() {
        Function function = (Function)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            function.parameter[i] = this.parameter[i].elementary();
        }
        return function.evalelem();
    }

    @Override
    public Generic simplify() {
        Function function = (Function)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            function.parameter[i] = this.parameter[i].simplify();
        }
        return function.evalsimp();
    }

    @Override
    public Generic function(Variable variable) {
        Function function = (Function)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            function.parameter[i] = this.parameter[i].function(variable);
        }
        return function.evalfunc();
    }

    @Override
    public Generic numeric() {
        Function function = (Function)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            function.parameter[i] = this.parameter[i].numeric();
        }
        return function.evalnum();
    }

    @Override
    public boolean isConstant(Variable variable) {
        boolean bl = !this.isIdentity(variable);
        for (int i = 0; i < this.parameter.length; ++i) {
            bl = bl && this.parameter[i].isConstant(variable);
        }
        return bl;
    }

    @Override
    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int n = comparator.compare(this, variable);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        Function function = (Function)variable;
        n = this.name.compareTo(function.name);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return ArrayComparator.comparator.compare(this.parameter, function.parameter);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append("(");
        for (int i = 0; i < this.parameter.length; ++i) {
            stringBuffer.append(this.parameter[i]).append(i < this.parameter.length - 1 ? ", " : "");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<apply>");
        stringBuffer.append("<" + this.name + "/>");
        for (int i = 0; i < this.parameter.length; ++i) {
            stringBuffer.append(this.parameter[i].toMathML());
        }
        stringBuffer.append("</apply>");
        return stringBuffer.toString();
    }
}

