/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Expression;
import jscl.math.Function;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Exp;
import jscl.math.function.Inv;
import jscl.math.function.Sqrt;
import jscl.math.numeric.JSCLDouble;
import jscl.math.numeric.Numeric;
import jscl.util.ArrayComparator;

public class Constant
extends Variable {
    public static final Generic e = new Exp(JSCLInteger.valueOf(1L)).expressionValue();
    public static final Generic pi = new Constant("pi").expressionValue();
    public static final Generic i = new Sqrt(JSCLInteger.valueOf(-1L)).expressionValue();
    public static final Generic half = new Inv(JSCLInteger.valueOf(2L)).expressionValue();
    public static final Generic third = new Inv(JSCLInteger.valueOf(3L)).expressionValue();
    public static final Generic j = half.negate().multiply(JSCLInteger.valueOf(1L).subtract(i.multiply(new Sqrt(JSCLInteger.valueOf(3L)).expressionValue())));
    public static final Generic jbar = half.negate().multiply(JSCLInteger.valueOf(1L).add(i.multiply(new Sqrt(JSCLInteger.valueOf(3L)).expressionValue())));
    public static final Generic infinity = new Constant("oo").expressionValue();
    static final int PRIMECHARS = 3;
    protected int prime;
    protected Generic[] subscript;

    public Constant(String string) {
        this(string, 0);
    }

    public Constant(String string, int n) {
        this(string, n, new Generic[0]);
    }

    public Constant(String string, int n, Generic[] genericArray) {
        super(string);
        this.prime = n;
        this.subscript = genericArray;
    }

    public int prime() {
        return this.prime;
    }

    public Generic[] subscript() {
        return this.subscript;
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        return null;
    }

    @Override
    public Generic derivative(Variable variable) {
        if (this.isIdentity(variable)) {
            return JSCLInteger.valueOf(1L);
        }
        return JSCLInteger.valueOf(0L);
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        Constant constant = (Constant)this.newinstance();
        for (int i = 0; i < this.subscript.length; ++i) {
            constant.subscript[i] = this.subscript[i].substitute(variable, generic);
        }
        if (constant.isIdentity(variable)) {
            return generic;
        }
        return constant.expressionValue();
    }

    @Override
    public Generic expand() {
        Constant constant = (Constant)this.newinstance();
        for (int i = 0; i < this.subscript.length; ++i) {
            constant.subscript[i] = this.subscript[i].expand();
        }
        return constant.expressionValue();
    }

    @Override
    public Generic factorize() {
        Constant constant = (Constant)this.newinstance();
        for (int i = 0; i < this.subscript.length; ++i) {
            constant.subscript[i] = this.subscript[i].factorize();
        }
        return constant.expressionValue();
    }

    @Override
    public Generic elementary() {
        Constant constant = (Constant)this.newinstance();
        for (int i = 0; i < this.subscript.length; ++i) {
            constant.subscript[i] = this.subscript[i].elementary();
        }
        return constant.expressionValue();
    }

    @Override
    public Generic simplify() {
        Constant constant = (Constant)this.newinstance();
        for (int i = 0; i < this.subscript.length; ++i) {
            constant.subscript[i] = this.subscript[i].simplify();
        }
        return constant.expressionValue();
    }

    @Override
    public Generic function(Variable variable) {
        if (this.isIdentity(variable)) {
            return Function.identity;
        }
        return this.numeric().function(variable);
    }

    @Override
    public Generic numeric() {
        return new NumericWrapper(this);
    }

    public Numeric numericValue() {
        Expression expression = this.expressionValue();
        if (expression.compareTo(pi) == 0) {
            return JSCLDouble.valueOf(Math.PI);
        }
        if (expression.compareTo(infinity) == 0) {
            return JSCLDouble.valueOf(Double.POSITIVE_INFINITY);
        }
        throw new ArithmeticException();
    }

    @Override
    public boolean isConstant(Variable variable) {
        return !this.isIdentity(variable);
    }

    @Override
    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int n = comparator.compare(this, variable);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        Constant constant = (Constant)variable;
        n = this.name.compareTo(constant.name);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        n = ArrayComparator.comparator.compare(this.subscript, constant.subscript);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        if (this.prime < constant.prime) {
            return -1;
        }
        if (this.prime > constant.prime) {
            return 1;
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        for (int i = 0; i < this.subscript.length; ++i) {
            stringBuffer.append("[").append(this.subscript[i]).append("]");
        }
        if (this.prime != 0) {
            if (this.prime <= 3) {
                stringBuffer.append(Constant.primechars(this.prime));
            } else {
                stringBuffer.append("{").append(this.prime).append("}");
            }
        }
        return stringBuffer.toString();
    }

    static String primechars(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("'");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        if ("pi".equals(this.name)) {
            return "<pi/>";
        }
        if ("oo".equals(this.name)) {
            return "<infinity/>";
        }
        return "<ci>" + this.bodyToMathML() + "</ci>";
    }

    public String bodyToMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.subscript.length == 0) {
            if (this.prime == 0) {
                stringBuffer.append(this.nameToMathML());
            } else if (this.prime <= 3) {
                stringBuffer.append(this.nameToMathML() + Constant.primecharsToMathML(this.prime));
            } else {
                stringBuffer.append("<msup>");
                stringBuffer.append("<mi>" + this.nameToMathML() + "</mi>");
                stringBuffer.append(this.primeToMathML());
                stringBuffer.append("</msup>");
            }
        } else if (this.prime == 0) {
            stringBuffer.append("<msub>");
            stringBuffer.append("<mi>" + this.nameToMathML() + "</mi>");
            stringBuffer.append(this.subscriptToMathML());
            stringBuffer.append("</msub>");
        } else if (this.prime <= 3) {
            stringBuffer.append("<msub>");
            stringBuffer.append("<mi>" + this.nameToMathML() + Constant.primecharsToMathML(this.prime) + "</mi>");
            stringBuffer.append(this.subscriptToMathML());
            stringBuffer.append("</msub>");
        } else {
            stringBuffer.append("<msubsup>");
            stringBuffer.append("<mi>" + this.nameToMathML() + "</mi>");
            stringBuffer.append(this.subscriptToMathML());
            stringBuffer.append(this.primeToMathML());
            stringBuffer.append("</msubsup>");
        }
        return stringBuffer.toString();
    }

    String subscriptToMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<mrow>");
        for (int i = 0; i < this.subscript.length; ++i) {
            stringBuffer.append(this.subscript[i].toMathML());
        }
        stringBuffer.append("</mrow>");
        return stringBuffer.toString();
    }

    String primeToMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<mfenced>");
        stringBuffer.append("<mn>" + String.valueOf(this.prime) + "</mn>");
        stringBuffer.append("</mfenced>");
        return stringBuffer.toString();
    }

    static String primecharsToMathML(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\u2032");
        }
        return stringBuffer.toString();
    }

    @Override
    protected Variable newinstance() {
        return new Constant(this.name, this.prime, new Generic[this.subscript.length]);
    }
}

