/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.JSCLVector;
import jscl.math.Matrix;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.function.Exp;
import jscl.math.function.Frac;
import jscl.math.function.Function;
import jscl.math.function.Log;

public class Conjugate
extends Function {
    public Conjugate(Generic generic) {
        super("conjugate", new Generic[]{generic});
    }

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        return Constant.half.multiply(this.evaluate().pow(2));
    }

    @Override
    public Generic derivative(int n) {
        return JSCLInteger.valueOf(1L);
    }

    @Override
    public Generic evaluate() {
        try {
            return this.parameter[0].integerValue();
        }
        catch (NotIntegerException notIntegerException) {
            if (this.parameter[0] instanceof Matrix) {
                return ((Matrix)this.parameter[0]).conjugate();
            }
            if (this.parameter[0] instanceof JSCLVector) {
                return ((JSCLVector)this.parameter[0]).conjugate();
            }
            return this.expressionValue();
        }
    }

    @Override
    public Generic evalelem() {
        try {
            return this.parameter[0].integerValue();
        }
        catch (NotIntegerException notIntegerException) {
            return this.expressionValue();
        }
    }

    @Override
    public Generic evalsimp() {
        try {
            return this.parameter[0].integerValue();
        }
        catch (NotIntegerException notIntegerException) {
            Generic[] genericArray;
            if (this.parameter[0].signum() < 0) {
                return new Conjugate(this.parameter[0].negate()).evalsimp().negate();
            }
            if (this.parameter[0].compareTo(Constant.i) == 0) {
                return Constant.i.negate();
            }
            try {
                genericArray = this.parameter[0].variableValue();
                if (genericArray instanceof Conjugate) {
                    Generic[] genericArray2 = ((Conjugate)genericArray).parameters();
                    return genericArray2[0];
                }
                if (genericArray instanceof Exp) {
                    Generic[] genericArray3 = ((Exp)genericArray).parameters();
                    return new Exp(new Conjugate(genericArray3[0]).evalsimp()).evalsimp();
                }
                if (genericArray instanceof Log) {
                    Generic[] genericArray4 = ((Log)genericArray).parameters();
                    return new Log(new Conjugate(genericArray4[0]).evalsimp()).evalsimp();
                }
            }
            catch (NotVariableException notVariableException) {
                Generic[] genericArray5 = this.parameter[0].sumValue();
                if (genericArray5.length > 1) {
                    Generic generic = JSCLInteger.valueOf(0L);
                    for (int i = 0; i < genericArray5.length; ++i) {
                        generic = ((Generic)generic).add(new Conjugate(genericArray5[i]).evalsimp());
                    }
                    return generic;
                }
                Generic[] genericArray6 = genericArray5[0].productValue();
                Generic generic = JSCLInteger.valueOf(1L);
                for (int i = 0; i < genericArray6.length; ++i) {
                    Power power = genericArray6[i].powerValue();
                    generic = ((Generic)generic).multiply(new Conjugate(power.value()).evalsimp().pow(power.exponent()));
                }
                return generic;
            }
            genericArray = Frac.separateCoefficient(this.parameter[0]);
            if (genericArray[0].compareTo(JSCLInteger.valueOf(1L)) != 0 || genericArray[1].compareTo(JSCLInteger.valueOf(1L)) != 0) {
                return new Conjugate(genericArray[2]).evalsimp().multiply(new Frac(genericArray[0], genericArray[1]).evalsimp());
            }
            return this.expressionValue();
        }
    }

    @Override
    public Generic evalfunc() {
        return ((jscl.math.Function)this.parameter[0]).conjugate();
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).conjugate();
    }

    @Override
    protected Variable newinstance() {
        return new Conjugate(null);
    }
}

