/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.Variable;

public class TechnicalVariable
extends Variable {
    private final int[] subscript;

    public TechnicalVariable(String string) {
        this(string, new int[0]);
    }

    public TechnicalVariable(String string, int[] nArray) {
        super(string);
        this.subscript = nArray;
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        throw new NotIntegrableException();
    }

    @Override
    public Generic derivative(Variable variable) {
        if (this.isIdentity(variable)) {
            return JSCLInteger.valueOf(1L);
        }
        return JSCLInteger.valueOf(0L);
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        if (this.isIdentity(variable)) {
            return generic;
        }
        return this.expressionValue();
    }

    @Override
    public Generic expand() {
        return this.expressionValue();
    }

    @Override
    public Generic factorize() {
        return this.expressionValue();
    }

    @Override
    public Generic elementary() {
        return this.expressionValue();
    }

    @Override
    public Generic simplify() {
        return this.expressionValue();
    }

    @Override
    public Generic function(Variable variable) {
        throw new ArithmeticException();
    }

    @Override
    public Generic numeric() {
        throw new ArithmeticException();
    }

    @Override
    public boolean isConstant(Variable variable) {
        return !this.isIdentity(variable);
    }

    @Override
    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int n = comparator.compare(this, variable);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        TechnicalVariable technicalVariable = (TechnicalVariable)variable;
        n = this.name.compareTo(technicalVariable.name);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return this.compareSubscript(this.subscript, technicalVariable.subscript);
    }

    public int compareSubscript(int[] nArray, int[] nArray2) {
        if (nArray.length < nArray2.length) {
            return -1;
        }
        if (nArray.length > nArray2.length) {
            return 1;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < nArray2[i]) {
                return -1;
            }
            if (nArray[i] <= nArray2[i]) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        if (this.subscript.length == 1) {
            stringBuffer.append(this.subscript[0]);
        } else {
            for (int i = 0; i < this.subscript.length; ++i) {
                stringBuffer.append("[").append(this.subscript[i]).append("]");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        return null;
    }

    @Override
    protected Variable newinstance() {
        return new TechnicalVariable(this.name);
    }
}

