/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import jscl.math.Generic;
import jscl.math.JSCLBoolean;
import jscl.math.JSCLInteger;
import jscl.math.JSCLVector;
import jscl.math.Matrix;
import jscl.math.ModularInteger;
import jscl.math.NumericWrapper;
import jscl.math.Rational;
import jscl.math.function.Comparison;
import jscl.math.function.Constant;
import jscl.math.function.Cubic;
import jscl.math.function.Exp;
import jscl.math.function.ImplicitFunction;
import jscl.math.function.Log;
import jscl.math.function.Pow;
import jscl.math.function.Root;
import jscl.math.function.Sqrt;
import jscl.math.function.bool.And;
import jscl.math.function.bool.Implies;
import jscl.math.function.bool.Not;
import jscl.math.function.bool.Or;
import jscl.math.function.bool.Xor;
import jscl.math.function.hyperbolic.Acosh;
import jscl.math.function.hyperbolic.Acoth;
import jscl.math.function.hyperbolic.Asinh;
import jscl.math.function.hyperbolic.Atanh;
import jscl.math.function.hyperbolic.Cosh;
import jscl.math.function.hyperbolic.Coth;
import jscl.math.function.hyperbolic.Sinh;
import jscl.math.function.hyperbolic.Tanh;
import jscl.math.function.trigonometric.Acos;
import jscl.math.function.trigonometric.Acot;
import jscl.math.function.trigonometric.Asin;
import jscl.math.function.trigonometric.Atan;
import jscl.math.function.trigonometric.Cos;
import jscl.math.function.trigonometric.Cot;
import jscl.math.function.trigonometric.Sin;
import jscl.math.function.trigonometric.Tan;
import jscl.math.numeric.Complex;
import jscl.math.numeric.JSCLDouble;
import jscl.math.operator.Binomial;
import jscl.math.operator.Coefficient;
import jscl.math.operator.Derivative;
import jscl.math.operator.Division;
import jscl.math.operator.Elementary;
import jscl.math.operator.FactorOf;
import jscl.math.operator.Factorial;
import jscl.math.operator.Factorize;
import jscl.math.operator.Graph;
import jscl.math.operator.Groebner;
import jscl.math.operator.IndefiniteIntegral;
import jscl.math.operator.Integral;
import jscl.math.operator.Limit;
import jscl.math.operator.Numeric;
import jscl.math.operator.Product;
import jscl.math.operator.Quote;
import jscl.math.operator.Remainder;
import jscl.math.operator.Simplify;
import jscl.math.operator.Solve;
import jscl.math.operator.Substitute;
import jscl.math.operator.Sum;
import jscl.math.operator.matrix.Determinant;
import jscl.math.operator.matrix.Trace;
import jscl.math.operator.matrix.Transpose;
import jscl.math.operator.number.EulerPhi;
import jscl.math.operator.number.Mod;
import jscl.math.operator.number.ModInverse;
import jscl.math.operator.number.ModPow;
import jscl.math.operator.number.PrimitiveRoots;
import jscl.math.operator.product.ComplexProduct;
import jscl.math.operator.product.GeometricProduct;
import jscl.math.operator.product.MatrixProduct;
import jscl.math.operator.product.QuaternionProduct;
import jscl.math.operator.product.TensorProduct;
import jscl.math.operator.product.VectorProduct;
import jscl.math.operator.vector.Curl;
import jscl.math.operator.vector.Dalembertian;
import jscl.math.operator.vector.Del;
import jscl.math.operator.vector.Divergence;
import jscl.math.operator.vector.Grad;
import jscl.math.operator.vector.Jacobian;
import jscl.math.operator.vector.Laplacian;

public class Predef {
    public static final Generic pi = Constant.pi;
    public static final Generic oo = Constant.infinity;
    public static final Generic lex = Groebner.lex;
    public static final Generic tdl = Groebner.tdl;
    public static final Generic drl = Groebner.drl;

    public static Generic elim(int n) {
        return Groebner.elim.apply(new Generic[]{JSCLInteger.valueOf(n)});
    }

    public static Generic cl(int n, int n2) {
        return GeometricProduct.cl.apply(new Generic[]{JSCLInteger.valueOf(n), JSCLInteger.valueOf(n2)});
    }

    public static ImplicitFunction.Curried function(String string, int n) {
        return ImplicitFunction.apply(string, new int[]{n});
    }

    public static ImplicitFunction.Curried[] function(String string, int n, int n2) {
        return ImplicitFunction.apply(string, new int[]{n}, n2);
    }

    public static ImplicitFunction.Curried function(String string, int[] nArray) {
        return ImplicitFunction.apply(string, nArray);
    }

    public static ImplicitFunction.Curried[] function(String string, int[] nArray, int n) {
        return ImplicitFunction.apply(string, nArray, n);
    }

    public static Generic[] root(Generic[] genericArray) {
        return Root.apply(genericArray);
    }

    public static Generic cubic(Generic generic) {
        return new Cubic(generic).expressionValue();
    }

    public static Generic sqrt(Generic generic) {
        return new Sqrt(generic).expressionValue();
    }

    public static Generic sin(Generic generic) {
        return new Sin(generic).expressionValue();
    }

    public static Generic cos(Generic generic) {
        return new Cos(generic).expressionValue();
    }

    public static Generic tan(Generic generic) {
        return new Tan(generic).expressionValue();
    }

    public static Generic cot(Generic generic) {
        return new Cot(generic).expressionValue();
    }

    public static Generic arcsin(Generic generic) {
        return new Asin(generic).expressionValue();
    }

    public static Generic arccos(Generic generic) {
        return new Acos(generic).expressionValue();
    }

    public static Generic arctan(Generic generic) {
        return new Atan(generic).expressionValue();
    }

    public static Generic arccot(Generic generic) {
        return new Acot(generic).expressionValue();
    }

    public static Generic sinh(Generic generic) {
        return new Sinh(generic).expressionValue();
    }

    public static Generic cosh(Generic generic) {
        return new Cosh(generic).expressionValue();
    }

    public static Generic tanh(Generic generic) {
        return new Tanh(generic).expressionValue();
    }

    public static Generic coth(Generic generic) {
        return new Coth(generic).expressionValue();
    }

    public static Generic arcsinh(Generic generic) {
        return new Asinh(generic).expressionValue();
    }

    public static Generic arccosh(Generic generic) {
        return new Acosh(generic).expressionValue();
    }

    public static Generic arctanh(Generic generic) {
        return new Atanh(generic).expressionValue();
    }

    public static Generic arccoth(Generic generic) {
        return new Acoth(generic).expressionValue();
    }

    public static Generic exp(Generic generic) {
        return new Exp(generic).expressionValue();
    }

    public static Generic ln(Generic generic) {
        return new Log(generic).expressionValue();
    }

    public static Generic power(Generic generic, Generic generic2) {
        return new Pow(generic, generic2).expressionValue();
    }

    public static Generic[] vector(String string, int n, int n2) {
        return new JSCLVector(string, n, n2).elements();
    }

    public static Generic[] vector(String string, int n) {
        return new JSCLVector(string, 0, n).elements();
    }

    public static Generic[][] matrix(String string, int n, int n2) {
        return new Matrix(string, 0, n, n2).elements();
    }

    public static Generic[][] matrix(String string, int n) {
        return new Matrix(string, 0, n, n).elements();
    }

    public static Generic variable(String string) {
        return new Constant(string).expressionValue();
    }

    public static Generic variable(String string, int n) {
        return new Constant(string, n).expressionValue();
    }

    public static Generic integral(Generic generic, Generic generic2) {
        return new IndefiniteIntegral(generic, generic2).expressionValue();
    }

    public static Generic integral(Generic generic, Generic generic2, Generic generic3, Generic generic4) {
        return new Integral(generic, generic2, generic3, generic4).expressionValue();
    }

    public static Generic d(Generic generic, Generic generic2) {
        return new Derivative(generic, generic2, generic2, JSCLInteger.valueOf(1L)).expressionValue();
    }

    public static Generic d(Generic generic, Generic generic2, Generic generic3) {
        return new Derivative(generic, generic2, generic3, JSCLInteger.valueOf(1L)).expressionValue();
    }

    public static Generic d(Generic generic, Generic generic2, Generic generic3, Generic generic4) {
        return new Derivative(generic, generic2, generic3, generic4).expressionValue();
    }

    public static Generic modint(String string, String string2) {
        return ModularInteger.valueOf(string, string2);
    }

    public static Generic integer(String string) {
        return JSCLInteger.valueOf(string);
    }

    public static Generic rational(String string, String string2) {
        return Rational.valueOf(string, string2);
    }

    public static Generic real(double d) {
        return new NumericWrapper(JSCLDouble.valueOf(d));
    }

    public static Generic complex(double d, double d2) {
        return new NumericWrapper(Complex.valueOf(d, d2));
    }

    public static Generic bool(boolean bl) {
        return JSCLBoolean.valueOf(bl);
    }

    public static Generic vector(Generic[] genericArray) {
        return new JSCLVector(genericArray);
    }

    public static Generic matrix(Generic[][] genericArray) {
        return new Matrix(genericArray);
    }

    public static Object graph(Generic generic) {
        return jscl.math.Graph.apply(generic.expand());
    }

    public static Object graph(Generic[] genericArray) {
        return jscl.math.Graph.apply(new JSCLVector(genericArray).expand());
    }

    public static Generic function(Generic generic, Generic generic2) {
        return new Graph(generic, generic2).expressionValue();
    }

    public static Generic elementary(Generic generic) {
        return new Elementary(generic).expressionValue();
    }

    public static Generic factorize(Generic generic) {
        return new Factorize(generic).expressionValue();
    }

    public static Generic simplify(Generic generic) {
        return new Simplify(generic).expressionValue();
    }

    public static Generic numeric(Generic generic) {
        return new Numeric(generic).expressionValue();
    }

    public static Generic quote(Generic generic) {
        return new Quote(generic).expressionValue();
    }

    public static Generic sum(Generic generic, Generic generic2, Generic generic3, Generic generic4) {
        return new Sum(generic, generic2, generic3, generic4).expressionValue();
    }

    public static Generic product(Generic generic, Generic generic2, Generic generic3, Generic generic4) {
        return new Product(generic, generic2, generic3, generic4).expressionValue();
    }

    public static Generic limit(Generic generic, Generic generic2, Generic generic3) {
        return new Limit(generic, generic2, generic3, JSCLInteger.valueOf(0L)).expressionValue();
    }

    public static Generic limit(Generic generic, Generic generic2, Generic generic3, int n) {
        return new Limit(generic, generic2, generic3, JSCLInteger.valueOf(n)).expressionValue();
    }

    public static Generic factorial(Generic generic) {
        return new Factorial(generic).expressionValue();
    }

    public static Generic quotient(Generic generic, Generic generic2) {
        return new Division(generic, generic2).expressionValue();
    }

    public static Generic rem(Generic generic, Generic generic2) {
        return new Remainder(generic, generic2).expressionValue();
    }

    public static Generic factorof(Generic generic, Generic generic2) {
        return new FactorOf(generic, generic2).expressionValue();
    }

    public static Generic eq(Generic generic, Generic generic2) {
        return new Comparison("eq", generic, generic2).expressionValue();
    }

    public static Generic neq(Generic generic, Generic generic2) {
        return new Comparison("neq", generic, generic2).expressionValue();
    }

    public static Generic leq(Generic generic, Generic generic2) {
        return new Comparison("leq", generic, generic2).expressionValue();
    }

    public static Generic lt(Generic generic, Generic generic2) {
        return new Comparison("lt", generic, generic2).expressionValue();
    }

    public static Generic geq(Generic generic, Generic generic2) {
        return new Comparison("geq", generic, generic2).expressionValue();
    }

    public static Generic gt(Generic generic, Generic generic2) {
        return new Comparison("gt", generic, generic2).expressionValue();
    }

    public static Generic approx(Generic generic, Generic generic2) {
        return new Comparison("approx", generic, generic2).expressionValue();
    }

    public static Generic and(Generic generic, Generic generic2) {
        return new And(generic, generic2).expressionValue();
    }

    public static Generic or(Generic generic, Generic generic2) {
        return new Or(generic, generic2).expressionValue();
    }

    public static Generic xor(Generic generic, Generic generic2) {
        return new Xor(generic, generic2).expressionValue();
    }

    public static Generic not(Generic generic) {
        return new Not(generic).expressionValue();
    }

    public static Generic implies(Generic generic, Generic generic2) {
        return new Implies(generic, generic2).expressionValue();
    }

    public static Generic transpose(Generic generic) {
        return new Transpose(generic).expressionValue();
    }

    public static Generic trace(Generic generic) {
        return new Trace(generic).expressionValue();
    }

    public static Generic determinant(Generic generic) {
        return new Determinant(generic).expressionValue();
    }

    public static Generic grad(Generic generic, Generic[] genericArray) {
        return new Grad(generic, new JSCLVector(genericArray)).expressionValue();
    }

    public static Generic divergence(Generic generic, Generic[] genericArray) {
        return new Divergence(generic, new JSCLVector(genericArray)).expressionValue();
    }

    public static Generic curl(Generic generic, Generic[] genericArray) {
        return new Curl(generic, new JSCLVector(genericArray)).expressionValue();
    }

    public static Generic laplacian(Generic generic, Generic[] genericArray) {
        return new Laplacian(generic, new JSCLVector(genericArray)).expressionValue();
    }

    public static Generic dalembertian(Generic generic, Generic[] genericArray) {
        return new Dalembertian(generic, new JSCLVector(genericArray)).expressionValue();
    }

    public static Generic jacobian(Generic generic, Generic[] genericArray) {
        return new Jacobian(generic, new JSCLVector(genericArray)).expressionValue();
    }

    public static Generic del(Generic generic, Generic[] genericArray) {
        return new Del(generic, new JSCLVector(genericArray), JSCLInteger.valueOf(0L)).expressionValue();
    }

    public static Generic del(Generic generic, Generic[] genericArray, Generic generic2) {
        return new Del(generic, new JSCLVector(genericArray), generic2).expressionValue();
    }

    public static Generic groebner(Generic generic, Generic[] genericArray) {
        return new Groebner(generic, new JSCLVector(genericArray), lex, JSCLInteger.valueOf(0L)).expressionValue();
    }

    public static Generic groebner(Generic generic, Generic[] genericArray, Generic generic2) {
        return new Groebner(generic, new JSCLVector(genericArray), generic2, JSCLInteger.valueOf(0L)).expressionValue();
    }

    public static Generic groebner(Generic generic, Generic[] genericArray, Generic generic2, int n) {
        return new Groebner(generic, new JSCLVector(genericArray), generic2, JSCLInteger.valueOf(n)).expressionValue();
    }

    public static Generic coef(Generic generic, Generic generic2) {
        return new Coefficient(generic, generic2).expressionValue();
    }

    public static Generic subst(Generic generic, Generic generic2, Generic generic3) {
        return new Substitute(generic, generic2, generic3).expressionValue();
    }

    public static Generic subst(Generic generic, Generic[] genericArray, Generic[] genericArray2) {
        return new Substitute(generic, new JSCLVector(genericArray), new JSCLVector(genericArray2)).expressionValue();
    }

    public static Generic solve(Generic generic, Generic generic2) {
        return new Solve(generic, generic2, JSCLInteger.valueOf(0L)).expressionValue();
    }

    public static Generic solve(Generic generic, Generic generic2, int n) {
        return new Solve(generic, generic2, JSCLInteger.valueOf(n)).expressionValue();
    }

    public static Generic complex(Generic[] genericArray, Generic[] genericArray2) {
        return new ComplexProduct(new JSCLVector(genericArray), new JSCLVector(genericArray2)).expressionValue();
    }

    public static Generic quaternion(Generic[] genericArray, Generic[] genericArray2) {
        return new QuaternionProduct(new JSCLVector(genericArray), new JSCLVector(genericArray2)).expressionValue();
    }

    public static Generic vector(Generic[] genericArray, Generic[] genericArray2) {
        return new VectorProduct(new JSCLVector(genericArray), new JSCLVector(genericArray2)).expressionValue();
    }

    public static Generic matrix(Generic[][] genericArray, Generic[][] genericArray2) {
        return new MatrixProduct(new Matrix(genericArray), new Matrix(genericArray2)).expressionValue();
    }

    public static Generic tensor(Generic[][] genericArray, Generic[][] genericArray2) {
        return new TensorProduct(new Matrix(genericArray), new Matrix(genericArray2)).expressionValue();
    }

    public static Generic geometric(Generic[] genericArray, Generic[] genericArray2) {
        return new GeometricProduct(new JSCLVector(genericArray), new JSCLVector(genericArray2), JSCLInteger.valueOf(0L)).expressionValue();
    }

    public static Generic geometric(Generic[] genericArray, Generic[] genericArray2, Generic generic) {
        return new GeometricProduct(new JSCLVector(genericArray), new JSCLVector(genericArray2), generic).expressionValue();
    }

    public static Generic mod(Generic generic, Generic generic2) {
        return new Mod(generic, generic2).expressionValue();
    }

    public static Generic modpow(Generic generic, Generic generic2, Generic generic3) {
        return new ModPow(generic, generic2, generic3).expressionValue();
    }

    public static Generic modinv(Generic generic, Generic generic2) {
        return new ModInverse(generic, generic2).expressionValue();
    }

    public static Generic phi(Generic generic) {
        return new EulerPhi(generic).expressionValue();
    }

    public static Generic primitiveroots(Generic generic) {
        return new PrimitiveRoots(generic).expressionValue();
    }

    public static Generic C(Generic generic, Generic generic2) {
        return new Binomial(generic, generic2).expressionValue();
    }
}

