/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotDivisibleException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.function.Frac;
import jscl.math.function.Pow;
import jscl.math.polynomial.Monomial;

public class Literal
implements Comparable {
    Variable[] variable;
    int[] power;
    int degree;
    int size;

    Literal() {
    }

    Literal(int n) {
        this.init(n);
    }

    public int size() {
        return this.size;
    }

    public Variable variable(int n) {
        return this.variable[n];
    }

    public int power(int n) {
        return this.power[n];
    }

    void init(int n) {
        this.variable = new Variable[n];
        this.power = new int[n];
        this.size = n;
    }

    void resize(int n) {
        if (n < this.variable.length) {
            Variable[] variableArray = new Variable[n];
            int[] nArray = new int[n];
            System.arraycopy(this.variable, 0, variableArray, 0, n);
            System.arraycopy(this.power, 0, nArray, 0, n);
            this.variable = variableArray;
            this.power = nArray;
            this.size = n;
        }
    }

    public Literal multiply(Literal literal) {
        Variable variable;
        Literal literal2 = this.newinstance(this.size + literal.size);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Variable variable2 = n2 < this.size ? this.variable[n2] : null;
        Variable variable3 = variable = n3 < literal.size ? literal.variable[n3] : null;
        while (variable2 != null || variable != null) {
            int n4;
            int n5;
            int n6 = variable2 == null ? 1 : (n5 = variable == null ? -1 : variable2.compareTo(variable));
            if (n5 < 0) {
                n4 = this.power[n2];
                literal2.variable[n] = variable2;
                literal2.power[n] = n4;
                literal2.degree += n4;
                ++n;
                variable2 = ++n2 < this.size ? this.variable[n2] : null;
                continue;
            }
            if (n5 > 0) {
                n4 = literal.power[n3];
                literal2.variable[n] = variable;
                literal2.power[n] = n4;
                literal2.degree += n4;
                ++n;
                variable = ++n3 < literal.size ? literal.variable[n3] : null;
                continue;
            }
            n4 = this.power[n2] + literal.power[n3];
            literal2.variable[n] = variable2;
            literal2.power[n] = n4;
            literal2.degree += n4;
            ++n;
            variable2 = ++n2 < this.size ? this.variable[n2] : null;
            variable = n3 < literal.size ? literal.variable[++n3] : null;
        }
        literal2.resize(n);
        return literal2;
    }

    public Literal divide(Literal literal) throws ArithmeticException {
        Variable variable;
        Literal literal2 = this.newinstance(this.size + literal.size);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Variable variable2 = n2 < this.size ? this.variable[n2] : null;
        Variable variable3 = variable = n3 < literal.size ? literal.variable[n3] : null;
        while (variable2 != null || variable != null) {
            int n4;
            int n5;
            int n6 = variable2 == null ? 1 : (n5 = variable == null ? -1 : variable2.compareTo(variable));
            if (n5 < 0) {
                n4 = this.power[n2];
                literal2.variable[n] = variable2;
                literal2.power[n] = n4;
                literal2.degree += n4;
                ++n;
                variable2 = ++n2 < this.size ? this.variable[n2] : null;
                continue;
            }
            if (n5 > 0) {
                throw new NotDivisibleException();
            }
            n4 = this.power[n2] - literal.power[n3];
            if (n4 < 0) {
                throw new NotDivisibleException();
            }
            if (n4 != 0) {
                literal2.variable[n] = variable2;
                literal2.power[n] = n4;
                literal2.degree += n4;
                ++n;
            }
            variable2 = ++n2 < this.size ? this.variable[n2] : null;
            variable = n3 < literal.size ? literal.variable[++n3] : null;
        }
        literal2.resize(n);
        return literal2;
    }

    public Literal gcd(Literal literal) {
        Variable variable;
        Literal literal2 = this.newinstance(Math.min(this.size, literal.size));
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Variable variable2 = n2 < this.size ? this.variable[n2] : null;
        Variable variable3 = variable = n3 < literal.size ? literal.variable[n3] : null;
        while (variable2 != null || variable != null) {
            int n4;
            int n5 = variable2 == null ? 1 : (n4 = variable == null ? -1 : variable2.compareTo(variable));
            if (n4 < 0) {
                variable2 = ++n2 < this.size ? this.variable[n2] : null;
                continue;
            }
            if (n4 > 0) {
                variable = ++n3 < literal.size ? literal.variable[n3] : null;
                continue;
            }
            int n6 = Math.min(this.power[n2], literal.power[n3]);
            literal2.variable[n] = variable2;
            literal2.power[n] = n6;
            literal2.degree += n6;
            ++n;
            variable2 = ++n2 < this.size ? this.variable[n2] : null;
            variable = n3 < literal.size ? literal.variable[++n3] : null;
        }
        literal2.resize(n);
        return literal2;
    }

    public Literal scm(Literal literal) {
        Variable variable;
        Literal literal2 = this.newinstance(this.size + literal.size);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Variable variable2 = n2 < this.size ? this.variable[n2] : null;
        Variable variable3 = variable = n3 < literal.size ? literal.variable[n3] : null;
        while (variable2 != null || variable != null) {
            int n4;
            int n5;
            int n6 = variable2 == null ? 1 : (n5 = variable == null ? -1 : variable2.compareTo(variable));
            if (n5 < 0) {
                n4 = this.power[n2];
                literal2.variable[n] = variable2;
                literal2.power[n] = n4;
                literal2.degree += n4;
                ++n;
                variable2 = ++n2 < this.size ? this.variable[n2] : null;
                continue;
            }
            if (n5 > 0) {
                n4 = literal.power[n3];
                literal2.variable[n] = variable;
                literal2.power[n] = n4;
                literal2.degree += n4;
                ++n;
                variable = ++n3 < literal.size ? literal.variable[n3] : null;
                continue;
            }
            n4 = Math.max(this.power[n2], literal.power[n3]);
            literal2.variable[n] = variable2;
            literal2.power[n] = n4;
            literal2.degree += n4;
            ++n;
            variable2 = ++n2 < this.size ? this.variable[n2] : null;
            variable = n3 < literal.size ? literal.variable[++n3] : null;
        }
        literal2.resize(n);
        return literal2;
    }

    public Generic[] productValue() throws NotProductException {
        Generic[] genericArray = new Generic[this.size];
        for (int i = 0; i < genericArray.length; ++i) {
            genericArray[i] = this.variable[i].expressionValue().pow(this.power[i]);
        }
        return genericArray;
    }

    public Power powerValue() throws NotPowerException {
        if (this.size == 0) {
            return new Power(JSCLInteger.valueOf(1L), 1);
        }
        if (this.size == 1) {
            Variable variable = this.variable[0];
            int n = this.power[0];
            return new Power(variable.expressionValue(), n);
        }
        throw new NotPowerException();
    }

    public Variable variableValue() throws NotVariableException {
        if (this.size == 0) {
            throw new NotVariableException();
        }
        if (this.size == 1) {
            Variable variable = this.variable[0];
            int n = this.power[0];
            if (n == 1) {
                return variable;
            }
            throw new NotVariableException();
        }
        throw new NotVariableException();
    }

    public Variable[] variables() {
        Variable[] variableArray = new Variable[this.size];
        System.arraycopy(this.variable, 0, variableArray, 0, this.size);
        return variableArray;
    }

    public int degree() {
        return this.degree;
    }

    public int compareTo(Literal literal) {
        Variable variable;
        int n = this.size;
        int n2 = literal.size;
        Variable variable2 = n == 0 ? null : this.variable[--n];
        Variable variable3 = variable = n2 == 0 ? null : literal.variable[--n2];
        while (variable2 != null || variable != null) {
            int n3;
            int n4 = variable2 == null ? -1 : (n3 = variable == null ? 1 : variable2.compareTo(variable));
            if (n3 < 0) {
                return -1;
            }
            if (n3 > 0) {
                return 1;
            }
            int n5 = this.power[n];
            int n6 = literal.power[n2];
            if (n5 < n6) {
                return -1;
            }
            if (n5 > n6) {
                return 1;
            }
            variable2 = n == 0 ? null : this.variable[--n];
            variable = n2 == 0 ? null : literal.variable[--n2];
        }
        return 0;
    }

    public int compareTo(Object object) {
        return this.compareTo((Literal)object);
    }

    public static Literal valueOf() {
        return new Literal(0);
    }

    public static Literal valueOf(Variable variable) {
        return Literal.valueOf(variable, 1);
    }

    public static Literal valueOf(Variable variable, int n) {
        Literal literal = new Literal();
        literal.init(variable, n);
        return literal;
    }

    void init(Variable variable, int n) {
        if (n != 0) {
            this.init(1);
            this.variable[0] = variable;
            this.power[0] = n;
            this.degree = n;
        } else {
            this.init(0);
        }
    }

    public static Literal valueOf(Monomial monomial) {
        Literal literal = new Literal();
        literal.init(monomial);
        return literal;
    }

    void init(Monomial monomial) {
        int n;
        TreeMap<Variable, Integer> treeMap = new TreeMap<Variable, Integer>();
        Variable[] variableArray = monomial.unknown();
        for (int i = 0; i < variableArray.length; ++i) {
            n = monomial.element(i);
            if (n <= 0) continue;
            treeMap.put(variableArray[i], new Integer(n));
        }
        this.init(treeMap.size());
        Iterator iterator = treeMap.entrySet().iterator();
        n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Variable variable = (Variable)entry.getKey();
            int n2 = (Integer)entry.getValue();
            this.variable[n] = variable;
            this.power[n] = n2;
            this.degree += n2;
            ++n;
        }
    }

    Map content() {
        TreeMap<Variable, Integer> treeMap = new TreeMap<Variable, Integer>();
        for (int i = 0; i < this.size; ++i) {
            treeMap.put(this.variable[i], new Integer(this.power[i]));
        }
        return treeMap;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.degree == 0) {
            stringBuffer.append("1");
        }
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                stringBuffer.append("*");
            }
            Variable variable = this.variable[i];
            int n = this.power[i];
            if (n == 1) {
                stringBuffer.append(variable);
                continue;
            }
            if (variable instanceof Frac || variable instanceof Pow) {
                stringBuffer.append("(").append(variable).append(")");
            } else {
                stringBuffer.append(variable);
            }
            stringBuffer.append("^").append(n);
        }
        return stringBuffer.toString();
    }

    public String toMathML() {
        String string = "<cn>1</cn>";
        boolean bl = true;
        for (int i = 0; i < this.size; ++i) {
            Variable variable = this.variable[i];
            int n = this.power[i];
            String string2 = n == 1 ? variable.toMathML() : "<apply><power/>" + variable.toMathML() + "<cn>" + n + "</cn></apply>";
            string = bl ? string2 : "<apply><times/>" + string + string2 + "</apply>";
            bl = false;
        }
        return string;
    }

    protected Literal newinstance(int n) {
        return new Literal(n);
    }
}

