/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import jscl.math.ExpressionVariable;
import jscl.math.Function;
import jscl.math.Generic;
import jscl.math.IntegerVariable;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.Variable;

public abstract class GenericVariable
extends Variable {
    Generic content;

    GenericVariable(Generic generic) {
        super("");
        this.content = generic;
    }

    public static Generic content(Generic generic) {
        try {
            Variable variable = generic.variableValue();
            if (variable instanceof GenericVariable) {
                generic = ((GenericVariable)variable).content;
            }
        }
        catch (NotVariableException notVariableException) {
            // empty catch block
        }
        return generic;
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        return this.content.antiderivative(variable);
    }

    @Override
    public Generic derivative(Variable variable) {
        return this.content.derivative(variable);
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        GenericVariable genericVariable = (GenericVariable)this.newinstance();
        genericVariable.content = this.content.substitute(variable, generic);
        if (genericVariable.isIdentity(variable)) {
            return generic;
        }
        return genericVariable.expressionValue();
    }

    @Override
    public Generic expand() {
        return this.content.expand();
    }

    @Override
    public Generic factorize() {
        GenericVariable genericVariable = (GenericVariable)this.newinstance();
        genericVariable.content = this.content.factorize();
        return genericVariable.expressionValue();
    }

    @Override
    public Generic elementary() {
        GenericVariable genericVariable = (GenericVariable)this.newinstance();
        genericVariable.content = this.content.elementary();
        return genericVariable.expressionValue();
    }

    @Override
    public Generic simplify() {
        GenericVariable genericVariable = (GenericVariable)this.newinstance();
        genericVariable.content = this.content.simplify();
        return genericVariable.expressionValue();
    }

    @Override
    public Generic function(Variable variable) {
        if (this.isIdentity(variable)) {
            return Function.identity;
        }
        return this.content.function(variable);
    }

    @Override
    public Generic numeric() {
        return this.content.numeric();
    }

    @Override
    public boolean isConstant(Variable variable) {
        return this.content.isConstant(variable);
    }

    @Override
    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int n = comparator.compare(this, variable);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        GenericVariable genericVariable = (GenericVariable)variable;
        return this.content.compareTo(genericVariable.content);
    }

    public static GenericVariable valueOf(Generic generic) {
        return GenericVariable.valueOf(generic, false);
    }

    public static GenericVariable valueOf(Generic generic, boolean bl) {
        if (bl) {
            return new IntegerVariable(generic);
        }
        return new ExpressionVariable(generic);
    }

    @Override
    public String toString() {
        return this.content.toString();
    }

    @Override
    public String toMathML() {
        return this.content.toMathML();
    }
}

